/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.impl.digest;

import java.security.MessageDigest;

public abstract class Digest
extends MessageDigest {
    private final byte[] buf = new byte[4];
    private int off = 0;
    private long byteCount;

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();

    protected Digest(String algorithm) {
        super(algorithm);
    }

    @Override
    protected void engineUpdate(byte input) {
        this.buf[this.off++] = input;
        if (this.off == this.buf.length) {
            this.processWord(this.buf, 0);
            this.off = 0;
        }
        ++this.byteCount;
    }

    @Override
    protected void engineUpdate(byte[] input, int inOff, int len) {
        while (this.off != 0 && len > 0) {
            this.update(input[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.buf.length) {
            this.processWord(input, inOff);
            inOff += this.buf.length;
            len -= this.buf.length;
            this.byteCount += (long)this.buf.length;
        }
        while (len > 0) {
            this.update(input[inOff]);
            ++inOff;
            --len;
        }
    }

    @Override
    protected void engineReset() {
        this.byteCount = 0L;
        this.off = 0;
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
    }

    protected void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.off != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }
}

