/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<K, V> header;
    private final boolean accessOrder;

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    @Override
    void init() {
        this.header = new Entry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(HashMap.Entry[] entryArray, boolean bl) {
        int n = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            if (bl) {
                entry.hash = entry.key == null ? 0 : this.hash(entry.key);
            }
            int n2 = LinkedHashMap.indexFor(entry.hash, n);
            entry.next = entryArray[n2];
            entryArray[n2] = entry;
            entry = entry.after;
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return (V)entry.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int n, K k, V v, int n2) {
        super.addEntry(n, k, v, n2);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        }
    }

    @Override
    void createEntry(int n, K k, V v, int n2) {
        Entry<K, V> entry;
        HashMap.Entry entry2 = this.table[n2];
        this.table[n2] = entry = new Entry<K, V>(n, k, v, entry2);
        ((Entry)entry).addBefore((Entry)this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((LinkedHashMap)LinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry entry = this.lastReturned;
            this.nextEntry = entry.after;
            return entry;
        }
    }

    private static class Entry<K, V>
    extends HashMap.Entry<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int n, K k, V v, HashMap.Entry<K, V> entry) {
            super(n, k, v, entry);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<K, V> entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(HashMap<K, V> hashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap;
            if (linkedHashMap.accessOrder) {
                ++linkedHashMap.modCount;
                this.remove();
                this.addBefore(linkedHashMap.header);
            }
        }

        @Override
        void recordRemoval(HashMap<K, V> hashMap) {
            this.remove();
        }
    }
}

