/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.OpenConverter;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

final class ConvertingMethod {
    private static final String[] noStrings = new String[0];
    private final Method method;
    private final OpenConverter returnConverter;
    private final OpenConverter[] paramConverters;
    private final boolean paramConversionIsIdentity;

    static ConvertingMethod from(Method method) {
        try {
            return new ConvertingMethod(method);
        }
        catch (OpenDataException openDataException) {
            String string = "Method " + method.getDeclaringClass().getName() + "." + method.getName() + " has parameter or return type that " + "cannot be translated into an open type";
            throw new IllegalArgumentException(string, openDataException);
        }
    }

    Method getMethod() {
        return this.method;
    }

    Descriptor getDescriptor() {
        return Introspector.descriptorForElement(this.method);
    }

    Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    String getName() {
        return this.method.getName();
    }

    OpenType getOpenReturnType() {
        return this.returnConverter.getOpenType();
    }

    OpenType[] getOpenParameterTypes() {
        OpenType[] openTypeArray = new OpenType[this.paramConverters.length];
        for (int i = 0; i < this.paramConverters.length; ++i) {
            openTypeArray[i] = this.paramConverters[i].getOpenType();
        }
        return openTypeArray;
    }

    void checkCallFromOpen() throws IllegalArgumentException {
        try {
            for (OpenConverter openConverter : this.paramConverters) {
                openConverter.checkReconstructible();
            }
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new IllegalArgumentException(invalidObjectException);
        }
    }

    void checkCallToOpen() throws IllegalArgumentException {
        try {
            this.returnConverter.checkReconstructible();
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new IllegalArgumentException(invalidObjectException);
        }
    }

    String[] getOpenSignature() {
        if (this.paramConverters.length == 0) {
            return noStrings;
        }
        String[] stringArray = new String[this.paramConverters.length];
        for (int i = 0; i < this.paramConverters.length; ++i) {
            stringArray[i] = this.paramConverters[i].getOpenClass().getName();
        }
        return stringArray;
    }

    final Object toOpenReturnValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
        return this.returnConverter.toOpenValue(mXBeanLookup, object);
    }

    final Object fromOpenReturnValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
        return this.returnConverter.fromOpenValue(mXBeanLookup, object);
    }

    final Object[] toOpenParameters(MXBeanLookup mXBeanLookup, Object[] objectArray) throws OpenDataException {
        if (this.paramConversionIsIdentity || objectArray == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.paramConverters[i].toOpenValue(mXBeanLookup, objectArray[i]);
        }
        return objectArray2;
    }

    final Object[] fromOpenParameters(MXBeanLookup mXBeanLookup, Object[] objectArray) throws InvalidObjectException {
        if (this.paramConversionIsIdentity || objectArray == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.paramConverters[i].fromOpenValue(mXBeanLookup, objectArray[i]);
        }
        return objectArray2;
    }

    final Object toOpenParameter(MXBeanLookup mXBeanLookup, Object object, int n) throws OpenDataException {
        return this.paramConverters[n].toOpenValue(mXBeanLookup, object);
    }

    final Object fromOpenParameter(MXBeanLookup mXBeanLookup, Object object, int n) throws InvalidObjectException {
        return this.paramConverters[n].fromOpenValue(mXBeanLookup, object);
    }

    Object invokeWithOpenReturn(MXBeanLookup mXBeanLookup, Object object, Object[] objectArray) throws MBeanException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2;
        try {
            objectArray2 = this.fromOpenParameters(mXBeanLookup, objectArray);
        }
        catch (InvalidObjectException invalidObjectException) {
            String string = this.methodName() + ": cannot convert parameters " + "from open values: " + invalidObjectException;
            throw new MBeanException(invalidObjectException, string);
        }
        Object object2 = this.method.invoke(object, objectArray2);
        try {
            return this.returnConverter.toOpenValue(mXBeanLookup, object2);
        }
        catch (OpenDataException openDataException) {
            String string = this.methodName() + ": cannot convert return " + "value to open value: " + openDataException;
            throw new MBeanException(openDataException, string);
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass() + "." + this.method.getName();
    }

    private ConvertingMethod(Method method) throws OpenDataException {
        this.method = method;
        this.returnConverter = OpenConverter.toConverter(method.getGenericReturnType());
        Type[] typeArray = method.getGenericParameterTypes();
        this.paramConverters = new OpenConverter[typeArray.length];
        boolean bl = true;
        for (int i = 0; i < typeArray.length; ++i) {
            this.paramConverters[i] = OpenConverter.toConverter(typeArray[i]);
            bl &= this.paramConverters[i].isIdentity();
        }
        this.paramConversionIsIdentity = bl;
    }
}

