/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader {
    private String version;
    public GpxData data;
    private InputSource inputSource;

    public GpxReader(InputStream inputStream) throws IOException {
        this.inputSource = new InputSource(UTFInputStreamReader.create(inputStream, "UTF-8"));
    }

    public boolean parse(boolean bl) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
            return true;
        }
        catch (SAXException sAXException) {
            if (bl) {
                parser.tryToFinish();
                if (parser.currentData.isEmpty()) {
                    throw sAXException;
                }
                return false;
            }
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        private GpxData currentData;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.init;
        private GpxLink currentLink;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuffer accumulator = new StringBuffer();
        private boolean nokiaSportsTrackerBug = false;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.states = new Stack();
            this.currentData = new GpxData();
        }

        private double parseCoord(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes attributes) {
            return new LatLon(this.parseCoord(attributes.getValue("lat")), this.parseCoord(attributes.getValue("lon")));
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string3);
            switch (this.currentState) {
                case init: {
                    this.states.push(this.currentState);
                    this.currentState = State.gpx;
                    this.currentData.creator = attributes.getValue("creator");
                    GpxReader.this.version = attributes.getValue("version");
                    if (GpxReader.this.version != null && GpxReader.this.version.startsWith("1.0")) {
                        GpxReader.this.version = "1.0";
                        break;
                    }
                    if ("1.1".equals(GpxReader.this.version)) break;
                    GpxReader.this.version = "1.1";
                    break;
                }
                case gpx: {
                    if (string3.equals("metadata")) {
                        this.states.push(this.currentState);
                        this.currentState = State.metadata;
                        break;
                    }
                    if (string3.equals("wpt")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (string3.equals("rte")) {
                        this.states.push(this.currentState);
                        this.currentState = State.rte;
                        this.currentRoute = new GpxRoute();
                        break;
                    }
                    if (string3.equals("trk")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trk;
                        this.currentTrack = new ArrayList<Collection<WayPoint>>();
                        this.currentTrackAttr = new HashMap<String, Object>();
                        break;
                    }
                    if (string3.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (!string3.equals("gpx") || attributes.getValue("creator") == null || !attributes.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                    this.nokiaSportsTrackerBug = true;
                    break;
                }
                case metadata: {
                    if (string3.equals("author")) {
                        this.states.push(this.currentState);
                        this.currentState = State.author;
                        break;
                    }
                    if (string3.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (string3.equals("copyright")) {
                        this.states.push(this.currentState);
                        this.currentState = State.copyright;
                        this.currentData.attr.put("meta.copyright.author", attributes.getValue("author"));
                        break;
                    }
                    if (!string3.equals("link")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.link;
                    this.currentLink = new GpxLink(attributes.getValue("href"));
                    break;
                }
                case author: {
                    if (string3.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string3.equals("email")) break;
                    this.currentData.attr.put("meta.author.email", attributes.getValue("id") + "@" + attributes.getValue("domain"));
                    break;
                }
                case trk: {
                    if (string3.equals("trkseg")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trkseg;
                        this.currentTrackSeg = new ArrayList<WayPoint>();
                        break;
                    }
                    if (string3.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string3.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case trkseg: {
                    if (!string3.equals("trkpt")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.wpt;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                    break;
                }
                case wpt: {
                    if (string3.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string3.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case rte: {
                    if (string3.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (string3.equals("rtept")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (!string3.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '\u0001') continue;
                    cArray[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(cArray, n, n2);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case rte: {
                    return this.currentRoute.attr;
                }
                case metadata: {
                    return this.currentData.attr;
                }
                case wpt: {
                    return this.currentWayPoint.attr;
                }
                case trk: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.elements.pop();
            switch (this.currentState) {
                case gpx: 
                case metadata: {
                    if (string3.equals("name")) {
                        this.currentData.attr.put("meta.name", this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("desc")) {
                        this.currentData.attr.put("meta.desc", this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("time")) {
                        this.currentData.attr.put("meta.time", this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("keywords")) {
                        this.currentData.attr.put("meta.keywords", this.accumulator.toString());
                        break;
                    }
                    if (GpxReader.this.version.equals("1.0") && string3.equals("author")) {
                        this.currentData.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (GpxReader.this.version.equals("1.0") && string3.equals("email")) {
                        this.currentData.attr.put("meta.author.email", this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("url") || string3.equals("urlname")) {
                        this.currentData.attr.put(string3, this.accumulator.toString());
                        break;
                    }
                    if ((this.currentState != State.metadata || !string3.equals("metadata")) && (this.currentState != State.gpx || !string3.equals("gpx"))) break;
                    this.convertUrlToLink(this.currentData.attr);
                    this.currentState = this.states.pop();
                    break;
                }
                case author: {
                    if (string3.equals("author")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string3.equals("name")) {
                        this.currentData.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("email") || !string3.equals("link")) break;
                    this.currentData.attr.put("meta.author.link", this.currentLink);
                    break;
                }
                case copyright: {
                    if (string3.equals("copyright")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string3.equals("year")) {
                        this.currentData.attr.put("meta.copyright.year", this.accumulator.toString());
                        break;
                    }
                    if (!string3.equals("license")) break;
                    this.currentData.attr.put("meta.copyright.license", this.accumulator.toString());
                    break;
                }
                case link: {
                    if (string3.equals("text")) {
                        this.currentLink.text = this.accumulator.toString();
                    } else if (string3.equals("type")) {
                        this.currentLink.type = this.accumulator.toString();
                    } else if (string3.equals("link")) {
                        if (this.currentLink.uri == null && this.accumulator != null && this.accumulator.toString().length() != 0) {
                            this.currentLink = new GpxLink(this.accumulator.toString());
                        }
                        this.currentState = this.states.pop();
                    }
                    if (this.currentState == State.author) {
                        this.currentData.attr.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.link) break;
                    Map<String, Object> map = this.getAttr();
                    if (!map.containsKey("meta.links")) {
                        map.put("meta.links", new LinkedList());
                    }
                    ((Collection)map.get("meta.links")).add(this.currentLink);
                    break;
                }
                case wpt: {
                    if (string3.equals("ele") || string3.equals("magvar") || string3.equals("name") || string3.equals("src") || string3.equals("geoidheight") || string3.equals("type") || string3.equals("sym") || string3.equals("url") || string3.equals("urlname")) {
                        this.currentWayPoint.attr.put(string3, this.accumulator.toString());
                        break;
                    }
                    if (string3.equals("hdop") || string3.equals("vdop") || string3.equals("pdop")) {
                        try {
                            this.currentWayPoint.attr.put(string3, Float.valueOf(Float.parseFloat(this.accumulator.toString())));
                        }
                        catch (Exception exception) {
                            this.currentWayPoint.attr.put(string3, new Float(0.0f));
                        }
                        break;
                    }
                    if (string3.equals("time")) {
                        this.currentWayPoint.attr.put(string3, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string3.equals("cmt") || string3.equals("desc")) {
                        this.currentWayPoint.attr.put(string3, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string3.equals("rtept")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentWayPoint.attr);
                        this.currentRoute.routePoints.add(this.currentWayPoint);
                        break;
                    }
                    if (string3.equals("trkpt")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentWayPoint.attr);
                        this.currentTrackSeg.add(this.currentWayPoint);
                        break;
                    }
                    if (!string3.equals("wpt")) break;
                    this.currentState = this.states.pop();
                    this.convertUrlToLink(this.currentWayPoint.attr);
                    this.currentData.waypoints.add(this.currentWayPoint);
                    break;
                }
                case trkseg: {
                    if (!string3.equals("trkseg")) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case trk: {
                    if (string3.equals("trk")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentTrackAttr);
                        this.currentData.tracks.add(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                        break;
                    }
                    if (!string3.equals("name") && !string3.equals("cmt") && !string3.equals("desc") && !string3.equals("src") && !string3.equals("type") && !string3.equals("number") && !string3.equals("url") && !string3.equals("urlname")) break;
                    this.currentTrackAttr.put(string3, this.accumulator.toString());
                    break;
                }
                case ext: {
                    if (!string3.equals("extensions")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                default: {
                    if (string3.equals("wpt")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!string3.equals("rte")) break;
                    this.currentState = this.states.pop();
                    this.convertUrlToLink(this.currentRoute.attr);
                    this.currentData.routes.add(this.currentRoute);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
            }
            GpxReader.this.data = this.currentData;
        }

        private void convertUrlToLink(Map<String, Object> map) {
            String string = (String)map.get("url");
            String string2 = (String)map.get("urlname");
            if (string != null) {
                if (!map.containsKey("meta.links")) {
                    map.put("meta.links", new LinkedList());
                }
                GpxLink gpxLink = new GpxLink(string);
                gpxLink.text = string2;
                ((Collection)map.get("meta.links")).add(gpxLink);
            }
        }

        public void tryToFinish() throws SAXException {
            ArrayList<String> arrayList = new ArrayList<String>(this.elements);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)arrayList.get(i), (String)arrayList.get(i));
            }
            this.endDocument();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        init,
        gpx,
        metadata,
        wpt,
        rte,
        trk,
        ext,
        author,
        link,
        trkseg,
        copyright;

    }
}

