/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Toolkit;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.ComboPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JosmComboBox
extends JComboBox {
    public static final String DEFAULT_PROTOTYPE_DISPLAY_VALUE = "Prototype display value";

    public JosmComboBox() {
        this(DEFAULT_PROTOTYPE_DISPLAY_VALUE);
    }

    public JosmComboBox(Object object) {
        this.init(object);
    }

    public JosmComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init(comboBoxModel != null && comboBoxModel.getSize() > 0 ? comboBoxModel.getElementAt(0) : null);
    }

    public JosmComboBox(Object[] objectArray) {
        super(objectArray);
        this.init(objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
    }

    public JosmComboBox(Vector<?> vector) {
        super(vector);
        this.init(vector != null && !vector.isEmpty() ? vector.get(0) : null);
    }

    protected void init(Object object) {
        if (object != null) {
            this.setPrototypeDisplayValue(object);
            int n = Toolkit.getDefaultToolkit().getScreenSize().height;
            int n2 = n / this.getPreferredSize().height / 2;
            for (int i = 0; i < this.getUI().getAccessibleChildrenCount(this); ++i) {
                int n3;
                Accessible accessible = this.getUI().getAccessibleChild(this, i);
                if (!(accessible instanceof ComboPopup)) continue;
                JList<Object> jList = ((ComboPopup)((Object)accessible)).getList();
                if (jList == null) break;
                if (jList.getPrototypeCellValue() != object) {
                    jList.setPrototypeCellValue(object);
                }
                if ((n3 = jList.getFixedCellHeight()) <= 0) break;
                n2 = n / n3 / 2;
                break;
            }
            this.setMaximumRowCount(Math.max(this.getMaximumRowCount(), n2));
        }
    }
}

