/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private int currentProgressValue = 0;
    private ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer progressRenderer) {
        super(new CancelHandler());
        CheckParameterUtil.ensureParameterNotNull(progressRenderer, "delegate");
        this.delegate = progressRenderer;
    }

    public void doBeginTask() {
        GuiHelper.runInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText("");
                SwingRenderingProgressMonitor.this.delegate.setMaximum(100);
            }
        });
    }

    public void doFinishTask() {
    }

    protected void updateProgress(double d) {
        int n = (int)(d * 100.0);
        if (n != this.currentProgressValue) {
            this.currentProgressValue = n;
            GuiHelper.runInEDT(new Runnable(){

                public void run() {
                    SwingRenderingProgressMonitor.this.delegate.setValue(SwingRenderingProgressMonitor.this.currentProgressValue);
                }
            });
        }
    }

    protected void doSetCustomText(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText(string);
            }
        });
    }

    protected void doSetTitle(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setTaskTitle(string);
            }
        });
    }

    protected void doSetIntermediate(final boolean bl) {
        GuiHelper.runInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setIndeterminate(bl);
            }
        });
    }

    public void setProgressTaskId(ProgressTaskId progressTaskId) {
    }

    public ProgressTaskId getProgressTaskId() {
        return null;
    }

    public Component getWindowParent() {
        return Main.parent;
    }
}

