/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Puwg;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuwgProjectionChoice
extends ListProjectionChoice
implements Alias {
    public PuwgProjectionChoice() {
        super("core:puwg", I18n.tr("PUWG (Poland)", new Object[0]), Puwg.zones, I18n.tr("PUWG Zone", new Object[0]));
    }

    @Override
    public Projection getProjection() {
        return new Puwg(this.index);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[Puwg.zones.length];
        for (int i = 0; i < Puwg.zones.length; ++i) {
            stringArray[i] = Puwg.zones[i].toCode();
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (Puwg.PuwgData puwgData : Puwg.zones) {
            if (!string.equals(puwgData.toCode())) continue;
            return Collections.singleton(string);
        }
        return null;
    }

    @Override
    public String getAlias() {
        return Puwg.class.getName();
    }

    @Override
    protected String indexToZone(int n) {
        return Puwg.zones[n].toCode();
    }

    @Override
    protected int zoneToIndex(String string) {
        for (int i = 0; i < Puwg.zones.length; ++i) {
            if (!string.equals(Puwg.zones[i].toCode())) continue;
            return i;
        }
        return this.defaultIndex;
    }
}

