/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentRelationLoadingTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private DataSet referrers;
    private boolean full;
    private OsmDataLayer layer;
    private Relation child;
    private ArrayList<Relation> parents;
    private Runnable continuation;

    public ParentRelationLoadingTask(Relation relation, OsmDataLayer osmDataLayer, boolean bl, PleaseWaitProgressMonitor pleaseWaitProgressMonitor) {
        super(I18n.tr("Download referring relations", new Object[0]), pleaseWaitProgressMonitor, false);
        CheckParameterUtil.ensureValidPrimitiveId(relation, "child");
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.referrers = null;
        this.layer = osmDataLayer;
        this.parents = new ArrayList();
        this.child = relation;
    }

    public void setContinuation(Runnable runnable) {
        this.continuation = runnable;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean hasError() {
        return this.lastException != null;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public List<Relation> getParents() {
        return this.parents;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        OsmApi.getOsmApi().cancel();
    }

    protected void showLastException() {
        String string = this.lastException.getMessage();
        if (string == null) {
            string = this.lastException.toString();
        }
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Error", new Object[0]), 0);
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            this.showLastException();
            return;
        }
        this.parents.clear();
        for (Relation relation : this.referrers.getRelations()) {
            this.parents.add((Relation)this.getLayer().data.getPrimitiveById(relation));
        }
        if (this.continuation != null) {
            this.continuation.run();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.indeterminateSubTask(null);
            OsmServerBackreferenceReader osmServerBackreferenceReader = new OsmServerBackreferenceReader(this.child, this.full);
            this.referrers = osmServerBackreferenceReader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
            if (this.referrers != null) {
                DataSetMerger dataSetMerger = new DataSetMerger(this.getLayer().data, this.referrers);
                dataSetMerger.merge();
                for (DataSource dataSource : this.referrers.dataSources) {
                    this.getLayer().data.dataSources.add(dataSource);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ParentRelationLoadingTask.this.getLayer().onPostDownloadFromServer();
                    }
                });
                if (dataSetMerger.getConflicts().isEmpty()) {
                    return;
                }
                this.getLayer().getConflicts().add(dataSetMerger.getConflicts());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", dataSetMerger.getConflicts().size()), I18n.tr("Warning", new Object[0]), 2);
            }
        }
        catch (Exception exception) {
            if (this.canceled) {
                System.out.println(I18n.tr("Warning: Ignoring exception because task was canceled. Exception: {0}", exception.toString()));
                return;
            }
            this.lastException = exception;
        }
    }
}

