/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionListDialog
extends ToggleDialog {
    private JList lstPrimitives;
    private SelectionListModel model;
    private SelectAction actSelect;
    private SearchAction actSearch;
    private ZoomToJOSMSelectionAction actZoomToJOSMSelection;
    private ZoomToListSelection actZoomToListSelection;
    private SetRelationSelection actSetRelationSelection;
    private EditRelationSelection actEditRelationSelection;
    private DownloadSelectedIncompleteMembersAction actDownloadSelectedIncompleteMembers;
    private SelectionPopup popupMenu;

    protected void buildContentPanel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new SelectionListModel(defaultListSelectionModel);
        this.lstPrimitives = new JList(this.model);
        this.lstPrimitives.setSelectionMode(2);
        this.lstPrimitives.setSelectionModel(defaultListSelectionModel);
        this.lstPrimitives.setCellRenderer(new OsmPrimitivRenderer());
        this.lstPrimitives.setTransferHandler(null);
        this.actSelect = new SelectAction();
        final SideButton sideButton = new SideButton(this.actSelect);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSelect);
        sideButton.createArrow(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionHistoryPopup.launch(sideButton, SelectionListDialog.this.model.getSelectionHistory());
            }
        });
        this.actSearch = new SearchAction();
        final SideButton sideButton2 = new SideButton(this.actSearch);
        sideButton2.createArrow(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPopupMenu.launch(sideButton2);
            }
        });
        this.createLayout(this.lstPrimitives, true, Arrays.asList(sideButton, sideButton2));
    }

    public SelectionListDialog() {
        super(I18n.tr("Selection", new Object[0]), "selectionlist", I18n.tr("Open a selection list window.", new Object[0]), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection", new Object[0])), 84, 5007), 150, true);
        this.buildContentPanel();
        this.model.addListDataListener(new TitleUpdater());
        this.actZoomToJOSMSelection = new ZoomToJOSMSelectionAction();
        this.model.addListDataListener(this.actZoomToJOSMSelection);
        this.actZoomToListSelection = new ZoomToListSelection();
        this.actSetRelationSelection = new SetRelationSelection();
        this.actEditRelationSelection = new EditRelationSelection();
        this.actDownloadSelectedIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
        this.lstPrimitives.addMouseListener(new SelectionPopupMenuLauncher());
        this.lstPrimitives.addMouseListener(new DblClickHandler());
        this.popupMenu = new SelectionPopup(this.lstPrimitives);
        InputMapUtils.addEnterAction(this.lstPrimitives, this.actZoomToListSelection);
    }

    @Override
    public void showNotify() {
        MapView.addEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().addSelectionListener(this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        DatasetEventManager.getInstance().addDatasetListener(this.model, DatasetEventManager.FireMode.IN_EDT);
        MapView.addEditLayerChangeListener(this.actSearch);
        this.model.editLayerChanged(null, Main.map.mapView.getEditLayer());
        if (Main.map.mapView.getEditLayer() != null) {
            this.model.setJOSMSelection(Main.map.mapView.getEditLayer().data.getAllSelected());
        }
        this.actSearch.updateEnabledState();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this.actSearch);
        MapView.removeEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().removeSelectionListener(this.model);
        DatasetEventManager.getInstance().removeDatasetListener(this.model);
    }

    public void addPopupMenuSeparator() {
        this.popupMenu.addSeparator();
    }

    public JMenuItem addPopupMenuAction(Action action) {
        return this.popupMenu.add(action);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenu.addPopupMenuListener(popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenu.addPopupMenuListener(popupMenuListener);
    }

    public Collection<OsmPrimitive> getSelectedPrimitives() {
        return this.model.getSelected();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OsmPrimitiveQuickComparator
    implements Comparator<OsmPrimitive> {
        private OsmPrimitiveQuickComparator() {
        }

        private int compareId(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            long l;
            long l2 = osmPrimitive.getUniqueId();
            if (l2 < (l = osmPrimitive2.getUniqueId())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }

        private int compareType(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return -1;
            }
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (osmPrimitive2.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            if (osmPrimitive.getType().equals((Object)osmPrimitive2.getType())) {
                return this.compareId(osmPrimitive, osmPrimitive2);
            }
            return this.compareType(osmPrimitive, osmPrimitive2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members", new Object[0]));
            this.updateEnabledState();
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(List<Relation> list) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (Relation relation : list) {
                hashSet.addAll(relation.getIncompleteMembers());
            }
            return hashSet;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> list = SelectionListDialog.this.model.getSelectedRelationsWithIncompleteMembers();
            if (list.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(list, this.buildSetOfIncompleteMembers(list), Main.map.mapView.getEditLayer()));
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelectedRelationsWithIncompleteMembers().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionHistoryPopup
    extends JPopupMenu {
        public static void launch(Component component, Collection<Collection<? extends OsmPrimitive>> collection) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            SelectionHistoryPopup selectionHistoryPopup = new SelectionHistoryPopup(collection);
            Rectangle rectangle = component.getBounds();
            selectionHistoryPopup.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SelectionHistoryPopup(Collection<Collection<? extends OsmPrimitive>> collection) {
            for (Collection<? extends OsmPrimitive> collection2 : collection) {
                this.add(new SelectionMenuItem(collection2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        private final DefaultNameFormatter df = DefaultNameFormatter.getInstance();
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> collection) {
            this.sel = collection;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive object : collection) {
                if (!object.isSelectable()) continue;
                if (object instanceof Way) {
                    ++n;
                    continue;
                }
                if (object instanceof Node) {
                    ++n2;
                    continue;
                }
                if (!(object instanceof Relation)) continue;
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} way", "{0} ways", n, n));
            }
            if (n2 != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} node", "{0} nodes", n2, n2));
            }
            if (n3 != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} relation", "{0} relations", n3, n3));
            }
            if (n + n2 + n3 == 0) {
                stringBuffer.append(I18n.tr("Unselectable now", new Object[0]));
                this.sel = new ArrayList<OsmPrimitive>();
            }
            if (n + n2 + n3 == 1) {
                stringBuffer.append(": ");
                for (OsmPrimitive osmPrimitive : collection) {
                    stringBuffer.append(osmPrimitive.getDisplayName(this.df));
                }
                this.setText(stringBuffer.toString());
            } else {
                this.setText(I18n.tr("Selection: {0}", stringBuffer));
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }

    protected static class SearchPopupMenu
    extends JPopupMenu {
        public static void launch(Component component) {
            if (org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory().isEmpty()) {
                return;
            }
            SearchPopupMenu searchPopupMenu = new SearchPopupMenu();
            Rectangle rectangle = component.getBounds();
            searchPopupMenu.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SearchPopupMenu() {
            for (SearchAction.SearchSetting searchSetting : org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory()) {
                this.add(new SearchMenuItem(searchSetting));
            }
        }
    }

    protected static class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected final SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting searchSetting) {
            super(searchSetting.toString());
            this.s = searchSetting;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(this.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectionListModel
    extends AbstractListModel
    implements MapView.EditLayerChangeListener,
    SelectionChangedListener,
    DataSetListener {
        private static final int SELECTION_HISTORY_SIZE = 10;
        private LinkedList<Collection<? extends OsmPrimitive>> history;
        private final List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        private DefaultListSelectionModel selectionModel;

        public SelectionListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public String getJOSMSelectionSummary() {
            if (this.selection.isEmpty()) {
                return I18n.tr("Selection", new Object[0]);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive osmPrimitive : this.selection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        ++n;
                        break;
                    }
                    case WAY: {
                        ++n2;
                        break;
                    }
                    case RELATION: {
                        ++n3;
                    }
                }
            }
            return I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", n3, n2, n);
        }

        public void remember(Collection<? extends OsmPrimitive> collection) {
            int n;
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            if (this.history == null) {
                return;
            }
            if (this.history.isEmpty()) {
                this.history.add(collection);
                return;
            }
            if (((Object)this.history.getFirst()).equals(collection)) {
                return;
            }
            this.history.addFirst(collection);
            for (n = 1; n < this.history.size(); ++n) {
                if (!((Object)this.history.get(n)).equals(collection)) continue;
                this.history.remove(n);
                break;
            }
            n = Main.pref.getInteger("select.history-size", 10);
            while (this.history.size() > n) {
                this.history.removeLast();
            }
        }

        public List<Collection<? extends OsmPrimitive>> getSelectionHistory() {
            return this.history;
        }

        @Override
        public Object getElementAt(int n) {
            return this.selection.get(n);
        }

        @Override
        public int getSize() {
            return this.selection.size();
        }

        public Collection<OsmPrimitive> getSelected() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                hashSet.add(this.selection.get(i));
            }
            return hashSet;
        }

        public Collection<OsmPrimitive> getAllElements() {
            return this.selection;
        }

        public void setSelected(Collection<OsmPrimitive> collection) {
            this.selectionModel.clearSelection();
            if (collection == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        @Override
        protected void fireContentsChanged(Object object, int n, int n2) {
            Collection<OsmPrimitive> collection = this.getSelected();
            super.fireContentsChanged(object, n, n2);
            this.setSelected(collection);
        }

        public void setJOSMSelection(Collection<? extends OsmPrimitive> collection) {
            OsmPrimitive osmPrimitive;
            this.selection.clear();
            if (collection == null) {
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            this.selection.addAll(collection);
            this.sort();
            this.fireContentsChanged(this, 0, this.getSize());
            this.remember(collection);
            double d = -1.0;
            if (this.selection.size() == 1 && (osmPrimitive = this.selection.get(0)) instanceof Way) {
                d = ((Way)osmPrimitive).getLength();
            }
            Main.map.statusLine.setDist(d);
        }

        public void update(Collection<? extends OsmPrimitive> collection) {
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            Collection<OsmPrimitive> collection2 = this.getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                super.fireContentsChanged(this, n, n);
            }
            this.setSelected(collection2);
        }

        public List<Relation> getSelectedRelationsWithIncompleteMembers() {
            LinkedList<Relation> linkedList = new LinkedList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                Relation relation;
                OsmPrimitive osmPrimitive;
                if (!this.selectionModel.isSelectedIndex(i) || !((osmPrimitive = this.selection.get(i)) instanceof Relation) || osmPrimitive.isNew() || !(relation = (Relation)osmPrimitive).hasIncompleteMembers()) continue;
                linkedList.add(relation);
            }
            return linkedList;
        }

        public void sort() {
            if (this.selection.size() > Main.pref.getInteger("selection.no_sort_above", 100000)) {
                return;
            }
            if (this.selection.size() > Main.pref.getInteger("selection.fast_sort_above", 10000)) {
                Collections.sort(this.selection, new OsmPrimitiveQuickComparator());
            } else {
                Collections.sort(this.selection, new OsmPrimitiveComparator());
            }
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            if (osmDataLayer2 == null) {
                this.setJOSMSelection(null);
                this.history = null;
            } else {
                this.history = osmDataLayer2.data.getSelectionHistory();
                this.setJOSMSelection(osmDataLayer2.data.getAllSelected());
            }
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.setJOSMSelection(collection);
        }

        @Override
        public void dataChanged(DataChangedEvent dataChangedEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
            this.update(nodeMovedEvent.getPrimitives());
        }

        @Override
        public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
            this.update(abstractDatasetChangedEvent.getPrimitives());
        }

        @Override
        public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
            this.update(relationMembersChangedEvent.getPrimitives());
        }

        @Override
        public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
            this.update(tagsChangedEvent.getPrimitives());
        }

        @Override
        public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
            this.update(wayNodesChangedEvent.getPrimitives());
        }

        @Override
        public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        }

        @Override
        public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        }
    }

    class SetRelationSelection
    extends AbstractAction
    implements ListSelectionListener {
        public SetRelationSelection() {
            this.putValue("Name", I18n.tr("Select in relation list", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select relation in relation list.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "selectionlist"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = (Relation)SelectionListDialog.this.model.getSelected().toArray()[0];
            Main.map.relationListDialog.selectRelation(relation);
        }

        public void updateEnabledState() {
            Object[] objectArray = SelectionListDialog.this.model.getSelected().toArray();
            this.setEnabled(objectArray.length == 1 && objectArray[0] instanceof Relation);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class EditRelationSelection
    extends SetRelationSelection {
        public EditRelationSelection() {
            this.putValue("Name", I18n.tr("Call editor for relation", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Call relation editor for selected relation", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = (Relation)SelectionListDialog.this.model.getSelected().toArray()[0];
            HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getAllElements();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
            Main.map.relationListDialog.selectRelation(relation);
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, hashSet).setVisible(true);
        }
    }

    class ZoomToListSelection
    extends AbstractAction
    implements ListSelectionListener {
        public ZoomToListSelection() {
            this.putValue("Name", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            boundingXYVisitor.computeBoundingBox(collection);
            if (boundingXYVisitor.getBounds() == null) {
                return;
            }
            boundingXYVisitor.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ZoomToJOSMSelectionAction
    extends AbstractAction
    implements ListDataListener {
        public ZoomToJOSMSelectionAction() {
            this.putValue("Name", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoScaleAction.autoScale("selection");
        }

        public void updateEnabledState() {
            this.setEnabled(SelectionListDialog.this.model.getSize() > 0);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Set the selected elements on the map to the selected items in the list above.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
                return;
            }
            Main.map.mapView.getEditLayer().data.setSelected(collection);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class SearchAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Search for objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            org.openstreetmap.josm.actions.search.SearchAction.search();
        }

        public void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            this.updateEnabledState();
        }
    }

    class TitleUpdater
    implements ListDataListener {
        TitleUpdater() {
        }

        protected void updateTitle() {
            SelectionListDialog.this.setTitle(SelectionListDialog.this.model.getJOSMSelectionSummary());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateTitle();
        }
    }

    class SelectionPopup
    extends ListPopupMenu {
        public SelectionPopup(JList jList) {
            super(jList);
            this.add(SelectionListDialog.this.actZoomToJOSMSelection);
            this.add(SelectionListDialog.this.actZoomToListSelection);
            this.addSeparator();
            this.add(SelectionListDialog.this.actSetRelationSelection);
            this.add(SelectionListDialog.this.actEditRelationSelection);
            this.addSeparator();
            this.add(SelectionListDialog.this.actDownloadSelectedIncompleteMembers);
        }
    }

    class SelectionPopupMenuLauncher
    extends PopupMenuLauncher {
        SelectionPopupMenuLauncher() {
        }

        public void launch(MouseEvent mouseEvent) {
            if (SelectionListDialog.this.model.getSelected().isEmpty()) {
                int n = SelectionListDialog.this.lstPrimitives.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                SelectionListDialog.this.model.setSelected(Collections.singleton((OsmPrimitive)SelectionListDialog.this.model.getElementAt(n)));
            }
            SelectionListDialog.this.popupMenu.show(SelectionListDialog.this.lstPrimitives, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = SelectionListDialog.this.lstPrimitives.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            osmDataLayer.data.setSelected(Collections.singleton((OsmPrimitive)SelectionListDialog.this.model.getElementAt(n)));
        }
    }
}

