/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("This plugin checks for errors in relations.", new Object[0]));
    }

    public void initialize() {
        this.initializePresets();
    }

    public void initializePresets() {
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            block0: for (TaggingPreset taggingPreset : collection) {
                for (TaggingPreset.Item item : taggingPreset.data) {
                    if (!(item instanceof TaggingPreset.Roles)) continue;
                    relationpresets.add(taggingPreset);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visit(Relation relation) {
        Object object;
        Object object2;
        LinkedList<TaggingPreset.Role> linkedList = new LinkedList<TaggingPreset.Role>();
        for (TaggingPreset linkedList2 : relationpresets) {
            void var6_11;
            boolean relationMember = true;
            Object var6_12 = null;
            object2 = linkedList2.data.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof TaggingPreset.Key) {
                    TaggingPreset.Key key = (TaggingPreset.Key)object;
                    if (key.value.equals(relation.get(key.key))) continue;
                    relationMember = false;
                    break;
                }
                if (!(object instanceof TaggingPreset.Roles)) continue;
                TaggingPreset.Roles roles = (TaggingPreset.Roles)object;
            }
            if (!relationMember || var6_11 == null) continue;
            linkedList.addAll(var6_11.roles);
        }
        if (linkedList.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, relation));
        } else {
            HashMap hashMap = new HashMap();
            for (RelationMember relationMember : relation.getMembers()) {
                void var6_17;
                String string = "";
                if (relationMember.hasRole()) {
                    String string2 = relationMember.getRole();
                }
                if ((object2 = (RoleInfo)hashMap.get(var6_17)) == null) {
                    object2 = new RoleInfo();
                }
                ++((RoleInfo)object2).total;
                if (relationMember.isRelation()) {
                    ((RoleInfo)object2).relations.add(relationMember.getRelation());
                } else if (relationMember.isWay()) {
                    ((RoleInfo)object2).ways.add(relationMember.getWay());
                    if (relationMember.getWay().isClosed()) {
                        ((RoleInfo)object2).closedways.add(relationMember.getWay());
                    } else {
                        ((RoleInfo)object2).openways.add(relationMember.getWay());
                    }
                } else if (relationMember.isNode()) {
                    ((RoleInfo)object2).nodes.add(relationMember.getNode());
                }
                hashMap.put(var6_17, object2);
            }
            if (hashMap.isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, relation));
            } else {
                LinkedList<String> linkedList2 = new LinkedList<String>();
                for (TaggingPreset.Role role : linkedList) {
                    Object object3;
                    long l;
                    long l2;
                    linkedList2.add(role.key);
                    object2 = role.key;
                    if ("".equals(object2)) {
                        object2 = I18n.tr("<empty>", new Object[0]);
                    }
                    if ((l2 = (object = (RoleInfo)hashMap.get(role.key)) == null ? 0L : (long)((RoleInfo)object).total) != (l = role.getValidCount(l2))) {
                        if (l2 == 0L) {
                            object3 = I18n.marktr("Role {0} missing");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object3, object2), MessageFormat.format((String)object3, object2), 1706, relation));
                        } else if (l > l2) {
                            object3 = I18n.marktr("Number of {0} roles too low ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object3, object2, l2), MessageFormat.format((String)object3, object2, l2), 1705, relation));
                        } else {
                            object3 = I18n.marktr("Number of {0} roles too high ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object3, object2, l2), MessageFormat.format((String)object3, object2, l2), 1704, relation));
                        }
                    }
                    if (object == null) continue;
                    object3 = new LinkedList();
                    if (!role.types.contains((Object)TaggingPreset.PresetType.WAY)) {
                        object3.addAll(role.types.contains((Object)TaggingPreset.PresetType.CLOSEDWAY) ? ((RoleInfo)object).openways : ((RoleInfo)object).ways);
                    }
                    if (!role.types.contains((Object)TaggingPreset.PresetType.NODE)) {
                        object3.addAll(((RoleInfo)object).nodes);
                    }
                    if (!role.types.contains((Object)TaggingPreset.PresetType.RELATION)) {
                        object3.addAll(((RoleInfo)object).relations);
                    }
                    if (object3.isEmpty()) continue;
                    String string = I18n.marktr("Member for role {0} of wrong type");
                    LinkedList<Relation> linkedList3 = new LinkedList<Relation>((Collection<Relation>)object3);
                    linkedList3.addFirst(relation);
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr(string, object2), MessageFormat.format(string, object2), 1703, (Collection<? extends OsmPrimitive>)linkedList3, (Collection<?>)object3));
                }
                for (String string : hashMap.keySet()) {
                    if (linkedList2.contains(string)) continue;
                    if (string.length() > 0) {
                        object2 = I18n.marktr("Role {0} unknown");
                        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object2, string), MessageFormat.format((String)object2, string), 1701, relation));
                        continue;
                    }
                    object2 = I18n.marktr("Empty role found");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 1702, relation));
                }
            }
        }
    }

    public static class RoleInfo {
        int total = 0;
        Collection<Node> nodes = new LinkedList<Node>();
        Collection<Way> ways = new LinkedList<Way>();
        Collection<Way> closedways = new LinkedList<Way>();
        Collection<Way> openways = new LinkedList<Way>();
        Collection<Relation> relations = new LinkedList<Relation>();
    }
}

