/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class OverlappingAreas
extends Test {
    protected static final int OVERLAPPING_AREAS = 2201;
    protected QuadBuckets<Way> index = new QuadBuckets();

    public OverlappingAreas() {
        super(I18n.tr("Overlapping Areas", new Object[0]), I18n.tr("This test checks if areas overlap.", new Object[0]));
    }

    public void visit(Way way) {
        if (way.isUsable() && way.isClosed() && ElemStyles.hasAreaElemStyle(way, false)) {
            this.index.add(way);
        }
    }

    public void endTest() {
        for (final Way way : this.index) {
            Collection<Way> collection = Utils.filter(this.index.search(way.getBBox()), new Predicate<Way>(){

                @Override
                public boolean evaluate(Way way2) {
                    if (way.equals(way2)) {
                        return false;
                    }
                    return Geometry.polygonIntersection(way.getNodes(), way2.getNodes()) == Geometry.PolygonIntersection.CROSSING;
                }
            });
            if (collection.isEmpty()) continue;
            this.errors.add(new TestError(this, Severity.OTHER, I18n.tr("Overlapping Areas", new Object[0]), 2201, Collections.singletonList(way), collection));
        }
        super.endTest();
    }
}

