/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadPrimitiveAction
extends JosmAction {
    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object...", new Object[0]), "downloadprimitive", I18n.tr("Download OSM object by ID.", new Object[0]), Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download object...", new Object[0])), 79, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    protected void restorePrimitivesHistory(HistoryComboBox historyComboBox) {
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".primitivesHistory", new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
    }

    protected void remindPrimitivesHistory(HistoryComboBox historyComboBox) {
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".primitivesHistory", historyComboBox.getHistory());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(I18n.tr("Object type:", new Object[0]));
        final OsmPrimitiveTypesComboBox osmPrimitiveTypesComboBox = new OsmPrimitiveTypesComboBox();
        osmPrimitiveTypesComboBox.addItem(I18n.trc("osm object types", "mixed"));
        osmPrimitiveTypesComboBox.setToolTipText(I18n.tr("Choose the OSM object type", new Object[0]));
        JLabel jLabel2 = new JLabel(I18n.tr("Object ID:", new Object[0]));
        final OsmIdTextField osmIdTextField = new OsmIdTextField();
        HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setEditor(new BasicComboBoxEditor(){

            protected JTextField createEditorComponent() {
                return osmIdTextField;
            }
        });
        historyComboBox.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded", new Object[0]));
        this.restorePrimitivesHistory(historyComboBox);
        osmIdTextField.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));
        jCheckBox.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        jCheckBox.setSelected(Main.pref.getBoolean("download.newlayer"));
        final JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("Download referrers (parent relations)", new Object[0]));
        jCheckBox2.setToolTipText(I18n.tr("Select if the referrers of the object should be downloaded as well, i.e.,parent relations and for nodes, additionally, parent ways", new Object[0]));
        jCheckBox2.setSelected(Main.pref.getBoolean("downloadprimitive.referrers", true));
        JCheckBox jCheckBox3 = new JCheckBox(I18n.tr("Download relation members", new Object[0]));
        jCheckBox3.setToolTipText(I18n.tr("Select if the members of a relation should be downloaded as well", new Object[0]));
        jCheckBox3.setSelected(Main.pref.getBoolean("downloadprimitive.full", true));
        HtmlPanel htmlPanel = new HtmlPanel(I18n.tr("Object IDs can be separated by comma or space.<br/> Examples: <b><ul><li>1 2 5</li><li>1,2,5</li></ul><br/></b> In mixed mode, specify objects like this: <b>w123, n110, w12, r15</b><br/>", new Object[0]));
        htmlPanel.setBorder(BorderFactory.createEtchedBorder(1));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(osmPrimitiveTypesComboBox, -2, -2, -2)).addGroup(groupLayout.createParallelGroup().addComponent(jLabel2).addComponent(historyComboBox, -2, -2, -2)).addComponent(jCheckBox2).addComponent(jCheckBox3).addComponent(jCheckBox).addComponent(htmlPanel));
        osmPrimitiveTypesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                osmIdTextField.setType(osmPrimitiveTypesComboBox.getType());
                osmIdTextField.performValidation();
                jCheckBox2.setText(osmPrimitiveTypesComboBox.getType() == OsmPrimitiveType.NODE ? I18n.tr("Download referrers (parent relations and ways)", new Object[0]) : I18n.tr("Download referrers (parent relations)", new Object[0]));
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2)).addGroup(groupLayout.createParallelGroup().addComponent(osmPrimitiveTypesComboBox).addComponent(historyComboBox))).addComponent(jCheckBox2).addComponent(jCheckBox3).addComponent(jCheckBox).addComponent(htmlPanel));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download object", new Object[0]), new String[]{I18n.tr("Download object", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Start downloading", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        extendedDialog.setDefaultButton(1);
        extendedDialog.configureContextsensitiveHelp("/Action/DownloadObject", true);
        osmPrimitiveTypesComboBox.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        osmIdTextField.setType(osmPrimitiveTypesComboBox.getType());
        if (Main.pref.getBoolean("downloadprimitive.autopaste", true)) {
            this.tryToPasteFromClipboard(osmIdTextField, osmPrimitiveTypesComboBox);
        }
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        Main.pref.putInteger("downloadprimitive.lasttype", osmPrimitiveTypesComboBox.getSelectedIndex());
        Main.pref.put("downloadprimitive.referrers", jCheckBox2.isSelected());
        Main.pref.put("downloadprimitive.full", jCheckBox3.isSelected());
        Main.pref.put("download.newlayer", jCheckBox.isSelected());
        osmIdTextField.setType(osmPrimitiveTypesComboBox.getType());
        if (!osmIdTextField.readOsmIds()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid ID list specified\nCannot download object.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        this.remindPrimitivesHistory(historyComboBox);
        DownloadPrimitiveAction.processItems(jCheckBox.isSelected(), osmIdTextField.getIds(), jCheckBox2.isSelected(), jCheckBox3.isSelected());
    }

    public static void processItems(boolean bl, final List<PrimitiveId> list, boolean bl2, boolean bl3) {
        OsmDataLayer osmDataLayer = DownloadPrimitiveAction.getEditLayer();
        if (osmDataLayer == null || bl) {
            osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
        }
        final DownloadPrimitivesTask downloadPrimitivesTask = new DownloadPrimitivesTask(osmDataLayer, list, bl3);
        Main.worker.submit(downloadPrimitivesTask);
        if (bl2) {
            for (PrimitiveId primitiveId : list) {
                Main.worker.submit(new DownloadReferrersTask(osmDataLayer, primitiveId));
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Serializable serializable;
                Set<PrimitiveId> set = downloadPrimitivesTask.getMissingPrimitives();
                if (set != null && !set.isEmpty()) {
                    serializable = DownloadPrimitiveAction.reportProblemDialog(set, I18n.trn("Object could not be downloaded", "Some objects could not be downloaded", set.size(), new Object[0]), I18n.trn("One object could not be downloaded.<br>", "{0} objects could not be downloaded.<br>", set.size(), set.size()) + I18n.tr("The server replied with response code 404.<br>This usually means, the server does not know an object with the requested id.", new Object[0]), I18n.tr("missing objects:", new Object[0]), 0);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable((ExtendedDialog)serializable){
                            final /* synthetic */ ExtendedDialog val$dlg;
                            {
                                this.val$dlg = extendedDialog;
                            }

                            public void run() {
                                this.val$dlg.showDialog();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                serializable = new TreeSet<PrimitiveId>();
                DataSet dataSet = JosmAction.getCurrentDataSet();
                for (PrimitiveId primitiveId : list) {
                    OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveId);
                    if (osmPrimitive == null || !osmPrimitive.isDeleted()) continue;
                    serializable.add(primitiveId);
                }
                if (!serializable.isEmpty()) {
                    final ExtendedDialog extendedDialog = DownloadPrimitiveAction.reportProblemDialog(serializable, I18n.trn("Object deleted", "Objects deleted", serializable.size(), new Object[0]), I18n.trn("One downloaded object is deleted.", "{0} downloaded objects are deleted.", serializable.size(), serializable.size()), null, 2);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            extendedDialog.showDialog();
                        }
                    });
                }
            }
        };
        Main.worker.submit(runnable);
    }

    private static ExtendedDialog reportProblemDialog(Set<PrimitiveId> set, String string, String string2, String string3, int n) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new HtmlPanel(string2), GBC.eop());
        if (string3 != null) {
            jComponent = new JLabel(string3);
            jComponent.setFont(jComponent.getFont().deriveFont(0));
            jPanel.add((Component)jComponent, GBC.eol());
        }
        jComponent = new JTextArea();
        ((JTextArea)jComponent).setFont(new Font("Monospaced", jComponent.getFont().getStyle(), jComponent.getFont().getSize()));
        ((JTextComponent)jComponent).setEditable(false);
        jComponent.setBackground(jPanel.getBackground());
        ((JTextArea)jComponent).setColumns(40);
        ((JTextArea)jComponent).setRows(1);
        ((JTextComponent)jComponent).setText(Utils.join(", ", set));
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jPanel.add((Component)jScrollPane, GBC.eop().weight(1.0, 0.0).fill(2));
        return new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Ok", new Object[0])}).setButtonIcons(new String[]{"ok"}).setIcon(n).setContent(jPanel, false);
    }

    private void tryToPasteFromClipboard(OsmIdTextField osmIdTextField, OsmPrimitiveTypesComboBox osmPrimitiveTypesComboBox) {
        String string = Utils.getClipboardContent();
        if (string != null) {
            String string2;
            String[] stringArray;
            if (string.contains("node")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(0);
            }
            if (string.contains("way")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(1);
            }
            if (string.contains("relation")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(2);
            }
            if ((stringArray = string.split("/")).length > 0) {
                string2 = stringArray[stringArray.length - 1];
                if (string2.isEmpty() && string2.length() > 1) {
                    string2 = stringArray[stringArray.length - 2];
                }
            } else {
                string2 = string;
            }
            osmIdTextField.setText(string2);
            osmIdTextField.clearTextIfInvalid();
        }
    }
}

