/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle", new Object[0]), "aligncircle", I18n.tr("Move the selected nodes into a circle.", new Object[0]), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle", new Object[0])), 79, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInCircle"));
    }

    public double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object4;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = AlignInCircleAction.getCurrentDataSet().getSelected();
        Serializable serializable = new LinkedList<Node>();
        LinkedList<Way> linkedList = new LinkedList<Way>();
        EastNorth eastNorth = null;
        double d = 0.0;
        boolean bl = false;
        for (OsmPrimitive object52 : collection) {
            if (object52 instanceof Node) {
                serializable.add((Node)object52);
                continue;
            }
            if (!(object52 instanceof Way)) continue;
            linkedList.add((Way)object52);
        }
        if (serializable.size() <= 2 && linkedList.size() == 1) {
            object4 = (Way)linkedList.get(0);
            if (serializable.size() > 0) {
                if (serializable.size() == 1 && ((Way)object4).containsNode((Node)serializable.get(0))) {
                    bl = true;
                } else {
                    eastNorth = ((Node)serializable.get(((Way)object4).containsNode((Node)serializable.get(0)) ? 1 : 0)).getEastNorth();
                    if (serializable.size() == 2) {
                        d = this.distance(((Node)serializable.get(0)).getEastNorth(), ((Node)serializable.get(1)).getEastNorth());
                    }
                }
                serializable = new LinkedList();
            }
            for (Node node : ((Way)object4).getNodes()) {
                if (serializable.contains(node)) continue;
                serializable.add((Node)node);
            }
        }
        if (serializable.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        if (linkedList.size() != 1) {
            void var10_13;
            object4 = new BigDecimal(0);
            BigDecimal bigDecimal = new BigDecimal(0);
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                object2 = (Node)iterator.next();
                object = new BigDecimal(((Node)object2).getEastNorth().east());
                BigDecimal bigDecimal2 = new BigDecimal(((Node)object2).getEastNorth().north());
                object4 = ((BigDecimal)object4).add((BigDecimal)object, MathContext.DECIMAL128);
                BigDecimal bigDecimal3 = var10_13.add(bigDecimal2, MathContext.DECIMAL128);
            }
            BigDecimal bigDecimal4 = new BigDecimal(serializable.size());
            object4 = ((BigDecimal)object4).divide(bigDecimal4, MathContext.DECIMAL128);
            BigDecimal bigDecimal5 = var10_13.divide(bigDecimal4, MathContext.DECIMAL128);
            object2 = new EastNorth(((BigDecimal)object4).doubleValue(), bigDecimal5.doubleValue());
            object = new LinkedList();
            while (!serializable.isEmpty()) {
                double d2 = -1.0;
                Node node = null;
                Iterator iterator2 = serializable.iterator();
                while (iterator2.hasNext()) {
                    Node node2 = (Node)iterator2.next();
                    double d3 = ((EastNorth)object2).heading(node2.getEastNorth());
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    node = node2;
                }
                object.add(node);
                serializable.remove(node);
            }
            serializable = object;
        }
        if (eastNorth == null) {
            eastNorth = Geometry.getCentroid(serializable);
        }
        if (d == 0.0) {
            object4 = serializable.iterator();
            while (object4.hasNext()) {
                Node node = (Node)object4.next();
                d += this.distance(eastNorth, node.getEastNorth());
            }
            d /= (double)serializable.size();
        }
        object4 = new LinkedList();
        if (bl) {
            double d4 = Math.PI * 2 / (double)serializable.size();
            PolarCoor polarCoor = new PolarCoor(((Node)serializable.get(0)).getEastNorth(), eastNorth, 0.0);
            PolarCoor polarCoor2 = new PolarCoor(((Node)serializable.get(1)).getEastNorth(), eastNorth, 0.0);
            if (polarCoor.angle > polarCoor2.angle) {
                d4 *= -1.0;
            }
            polarCoor.radius = d;
            object = serializable.iterator();
            while (object.hasNext()) {
                Node node = (Node)object.next();
                EastNorth eastNorth2 = polarCoor.toEastNorth();
                object4.add(new MoveCommand((OsmPrimitive)node, eastNorth2.east() - node.getEastNorth().east(), eastNorth2.north() - node.getEastNorth().north()));
                polarCoor.angle += d4;
            }
        } else {
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                object2 = (Node)iterator.next();
                PolarCoor polarCoor = new PolarCoor(((Node)object2).getEastNorth(), eastNorth, 0.0);
                polarCoor.radius = d;
                object = polarCoor.toEastNorth();
                object4.add(new MoveCommand((OsmPrimitive)object2, ((EastNorth)object).east() - ((Node)object2).getEastNorth().east(), ((EastNorth)object).north() - ((Node)object2).getEastNorth().north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle", new Object[0]), (Collection<Command>)object4));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AlignInCircleAction.getCurrentDataSet() != null && !AlignInCircleAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.this.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

