/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.ColorTable;
import com.kitfox.svg.xml.NumberWithUnits;
import com.kitfox.svg.xml.XMLParseUtil;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StyleAttribute
implements Serializable {
    public static final long serialVersionUID = 0L;
    static final Matcher matchUrl = Pattern.compile("\\s*url\\((.*)\\)\\s*").matcher("");
    static final Matcher matchFpNumUnits = Pattern.compile("\\s*([-+]?((\\d*\\.\\d+)|(\\d+))([-+]?[eE]\\d+)?)\\s*(px|cm|mm|in|pc|pt|em|ex)\\s*").matcher("");
    String name;
    String stringValue;
    boolean colorCompatable = false;
    boolean urlCompatable = false;

    public StyleAttribute() {
        this(null, null);
    }

    public StyleAttribute(String string) {
        this.name = string;
        this.stringValue = null;
    }

    public StyleAttribute(String string, String string2) {
        this.name = string;
        this.stringValue = string2;
    }

    public String getName() {
        return this.name;
    }

    public StyleAttribute setName(String string) {
        this.name = string;
        return this;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String[] getStringList() {
        return XMLParseUtil.parseStringList(this.stringValue);
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public boolean getBooleanValue() {
        return this.stringValue.toLowerCase().equals("true");
    }

    public int getIntValue() {
        return XMLParseUtil.findInt(this.stringValue);
    }

    public int[] getIntList() {
        return XMLParseUtil.parseIntList(this.stringValue);
    }

    public double getDoubleValue() {
        return XMLParseUtil.findDouble(this.stringValue);
    }

    public double[] getDoubleList() {
        return XMLParseUtil.parseDoubleList(this.stringValue);
    }

    public float getFloatValue() {
        return XMLParseUtil.findFloat(this.stringValue);
    }

    public float[] getFloatList() {
        return XMLParseUtil.parseFloatList(this.stringValue);
    }

    public float getRatioValue() {
        return (float)XMLParseUtil.parseRatio(this.stringValue);
    }

    public String getUnits() {
        matchFpNumUnits.reset(this.stringValue);
        if (!matchFpNumUnits.matches()) {
            return null;
        }
        return matchFpNumUnits.group(6);
    }

    public NumberWithUnits getNumberWithUnits() {
        return XMLParseUtil.parseNumberWithUnits(this.stringValue);
    }

    public float getFloatValueWithUnits() {
        NumberWithUnits numberWithUnits = this.getNumberWithUnits();
        return StyleAttribute.convertUnitsToPixels(numberWithUnits.getUnits(), numberWithUnits.getValue());
    }

    public static float convertUnitsToPixels(int n, float f) {
        float f2;
        if (n == 0 || n == 9) {
            return f;
        }
        try {
            f2 = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            f2 = 72.0f;
        }
        switch (n) {
            case 4: {
                return f * f2;
            }
            case 2: {
                return f * 0.3936f * f2;
            }
            case 3: {
                return f * 0.1f * 0.3936f * f2;
            }
            case 7: {
                return f * 0.013888889f * f2;
            }
            case 8: {
                return f * 0.16666667f * f2;
            }
        }
        return f;
    }

    public Color getColorValue() {
        return ColorTable.parseColor(this.stringValue);
    }

    public String parseURLFn() {
        matchUrl.reset(this.stringValue);
        if (!matchUrl.matches()) {
            return null;
        }
        return matchUrl.group(1);
    }

    public URL getURLValue(URL uRL) {
        String string = this.parseURLFn();
        if (string == null) {
            return null;
        }
        try {
            return new URL(uRL, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public URL getURLValue(URI uRI) {
        String string = this.parseURLFn();
        if (string == null) {
            return null;
        }
        try {
            URI uRI2 = uRI.resolve(string);
            return uRI2.toURL();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public URI getURIValue() {
        return this.getURIValue(null);
    }

    public URI getURIValue(URI uRI) {
        try {
            String string = this.parseURLFn();
            if (string == null) {
                string = this.stringValue.replaceAll("\\s+", "");
            }
            if (string == null) {
                return null;
            }
            if (Pattern.matches("[a-zA-Z]:!\\\\.*", string)) {
                File file = new File(string);
                return file.toURI();
            }
            URI uRI2 = new URI(string);
            if (uRI2.isAbsolute()) {
                return uRI2;
            }
            if (uRI == null) {
                return uRI2;
            }
            URI uRI3 = new URI(null, uRI.getSchemeSpecificPart(), null);
            URI uRI4 = uRI3.isOpaque() ? new URI(null, uRI.getSchemeSpecificPart(), uRI2.getFragment()) : uRI3.resolve(uRI2);
            return new URI(uRI.getScheme() + ":" + uRI4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            URI uRI = new URI("jar:http://www.kitfox.com/jackal/jackal.jar!/res/doc/about.svg");
            uRI = uRI.resolve("#myFragment");
            System.err.println(uRI.toString());
            uRI = new URI("http://www.kitfox.com/jackal/jackal.html");
            uRI = uRI.resolve("#myFragment");
            System.err.println(uRI.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

