/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.pattern.PatternPaint;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URI;

public class PatternSVG
extends FillElement {
    public static final int GU_OBJECT_BOUNDING_BOX = 0;
    public static final int GU_USER_SPACE_ON_USE = 1;
    int gradientUnits = 0;
    float x;
    float y;
    float width;
    float height;
    AffineTransform patternXform = new AffineTransform();
    Rectangle2D.Float viewBox;
    Paint texPaint;

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
    }

    protected void build() throws SVGException {
        Object object;
        Object object2;
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = null;
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            string = styleAttribute.getStringValue();
        }
        if (string != null) {
            try {
                object2 = this.getXMLBase().resolve(string);
                object = (PatternSVG)this.diagram.getUniverse().getElement((URI)object2);
                this.gradientUnits = ((PatternSVG)object).gradientUnits;
                this.x = ((PatternSVG)object).x;
                this.y = ((PatternSVG)object).y;
                this.width = ((PatternSVG)object).width;
                this.height = ((PatternSVG)object).height;
                this.viewBox = ((PatternSVG)object).viewBox;
                this.patternXform.setTransform(((PatternSVG)object).patternXform);
                this.children.addAll(((PatternSVG)object).children);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = "";
        if (this.getPres(styleAttribute.setName("gradientUnits"))) {
            object2 = styleAttribute.getStringValue().toLowerCase();
        }
        this.gradientUnits = ((String)object2).equals("userspaceonuse") ? 1 : 0;
        object = "";
        if (this.getPres(styleAttribute.setName("patternTransform"))) {
            object = styleAttribute.getStringValue();
        }
        this.patternXform = PatternSVG.parseTransform((String)object);
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("viewBox"))) {
            float[] fArray = styleAttribute.getFloatList();
            this.viewBox = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        this.preparePattern();
    }

    protected void preparePattern() throws SVGException {
        int n = (int)this.width;
        int n2 = (int)this.height;
        float f = 1.0f;
        float f2 = 1.0f;
        if (!this.patternXform.isIdentity()) {
            float f3 = (float)this.patternXform.getTranslateX();
            float f4 = (float)this.patternXform.getTranslateY();
            Point2D.Float float_ = new Point2D.Float();
            Serializable serializable = new Point2D.Float();
            float_.setLocation(this.width, 0.0f);
            this.patternXform.transform(float_, (Point2D)((Object)serializable));
            serializable.x -= f3;
            serializable.y -= f4;
            f = (float)Math.sqrt(serializable.x * serializable.x + serializable.y * serializable.y) * 1.5f / this.width;
            float_.setLocation(this.height, 0.0f);
            this.patternXform.transform(float_, (Point2D)((Object)serializable));
            serializable.x -= f3;
            serializable.y -= f4;
            f2 = (float)Math.sqrt(serializable.x * serializable.x + serializable.y * serializable.y) * 1.5f / this.height;
            n = (int)((float)n * f);
            n2 = (int)((float)n2 * f2);
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Serializable serializable : this.children) {
            if (!(serializable instanceof RenderableElement)) continue;
            AffineTransform affineTransform = new AffineTransform();
            if (this.viewBox == null) {
                affineTransform.translate(-this.x, -this.y);
            } else {
                affineTransform.scale((float)n / this.viewBox.width, (float)n2 / this.viewBox.height);
                affineTransform.translate(-this.viewBox.x, -this.viewBox.y);
            }
            graphics2D.setTransform(affineTransform);
            ((RenderableElement)serializable).render(graphics2D);
        }
        graphics2D.dispose();
        if (this.patternXform.isIdentity()) {
            this.texPaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(this.x, this.y, this.width, this.height));
        } else {
            this.patternXform.scale(1.0f / f, 1.0f / f2);
            this.texPaint = new PatternPaint(bufferedImage, this.patternXform);
        }
    }

    public Paint getPaint(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        return this.texPaint;
    }

    public boolean updateTime(double d) throws SVGException {
        return false;
    }
}

