/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

final class FastShortMessage
extends ShortMessage {
    private int packedMsg;

    public FastShortMessage(int n) throws InvalidMidiDataException {
        this.packedMsg = n;
        this.getDataLength(n & 0xFF);
    }

    public FastShortMessage(ShortMessage shortMessage) {
        this.packedMsg = shortMessage.getStatus() | shortMessage.getData1() << 8 | shortMessage.getData2() << 16;
    }

    int getPackedMsg() {
        return this.packedMsg;
    }

    @Override
    public byte[] getMessage() {
        int n = 0;
        try {
            n = this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            byArray[0] = (byte)(this.packedMsg & 0xFF);
            if (n > 1) {
                byArray[1] = (byte)((this.packedMsg & 0xFF00) >> 8);
                if (n > 2) {
                    byArray[2] = (byte)((this.packedMsg & 0xFF0000) >> 16);
                }
            }
        }
        return byArray;
    }

    @Override
    public int getLength() {
        try {
            return this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return 0;
        }
    }

    @Override
    public void setMessage(int n) throws InvalidMidiDataException {
        int n2 = this.getDataLength(n);
        if (n2 != 0) {
            super.setMessage(n);
        }
        this.packedMsg = this.packedMsg & 0xFFFF00 | n & 0xFF;
    }

    @Override
    public void setMessage(int n, int n2, int n3) throws InvalidMidiDataException {
        this.getDataLength(n);
        this.packedMsg = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
    }

    @Override
    public void setMessage(int n, int n2, int n3, int n4) throws InvalidMidiDataException {
        this.getDataLength(n);
        this.packedMsg = n & 0xF0 | n2 & 0xF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16;
    }

    @Override
    public int getChannel() {
        return this.packedMsg & 0xF;
    }

    @Override
    public int getCommand() {
        return this.packedMsg & 0xF0;
    }

    @Override
    public int getData1() {
        return (this.packedMsg & 0xFF00) >> 8;
    }

    @Override
    public int getData2() {
        return (this.packedMsg & 0xFF0000) >> 16;
    }

    @Override
    public int getStatus() {
        return this.packedMsg & 0xFF;
    }

    @Override
    public Object clone() {
        try {
            return new FastShortMessage(this.packedMsg);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return null;
        }
    }
}

