/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClassTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ClassTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "CLASSES";

    public ClassTreeTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment);
        this.root = this.createClassTree(HEADING);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ClassTreeNode classTreeNode;
                int n = ClassTreeTool.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ClassTreeTool.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && (classTreeNode = (ClassTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    ClassTreeTool.this.tree.setSelectionPath(treePath);
                    ClassTreeTool.this.interpreter.executeCommand("view " + classTreeNode.getReferenceTypeName());
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        ClassTreeToolListener classTreeToolListener = new ClassTreeToolListener();
        this.runtime.addJDIListener(classTreeToolListener);
        this.runtime.addSessionListener(classTreeToolListener);
    }

    ClassTreeNode createClassTree(String string) {
        return new ClassTreeNode(string, null);
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        private String name;
        private ReferenceType refTy;

        ClassTreeNode(String string, ReferenceType referenceType) {
            this.name = string;
            this.refTy = referenceType;
        }

        public String toString() {
            return this.name;
        }

        public ReferenceType getReferenceType() {
            return this.refTy;
        }

        public String getReferenceTypeName() {
            return this.refTy.name();
        }

        private boolean isPackage() {
            return this.refTy == null;
        }

        public boolean isLeaf() {
            return !this.isPackage();
        }

        public void addClass(ReferenceType referenceType) {
            this.addClass(referenceType.name(), referenceType);
        }

        private void addClass(String string, ReferenceType referenceType) {
            if (string.equals("")) {
                return;
            }
            int n = string.indexOf(46);
            if (n < 0) {
                this.insertNode(string, referenceType);
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                ClassTreeNode classTreeNode = this.insertNode(string2, null);
                classTreeNode.addClass(string3, referenceType);
            }
        }

        private ClassTreeNode insertNode(String string, ReferenceType referenceType) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ClassTreeNode classTreeNode = (ClassTreeNode)this.getChildAt(i);
                int n = string.compareTo(classTreeNode.toString());
                if (n == 0) {
                    return classTreeNode;
                }
                if (n >= 0) continue;
                ClassTreeNode classTreeNode2 = new ClassTreeNode(string, referenceType);
                ClassTreeTool.this.treeModel.insertNodeInto(classTreeNode2, this, i);
                return classTreeNode2;
            }
            ClassTreeNode classTreeNode = new ClassTreeNode(string, referenceType);
            ClassTreeTool.this.treeModel.insertNodeInto(classTreeNode, this, this.getChildCount());
            return classTreeNode;
        }

        public void removeClass(String string) {
            if (string.equals("")) {
                return;
            }
            int n = string.indexOf(46);
            if (n < 0) {
                ClassTreeNode classTreeNode = this.findNode(string);
                if (!this.isPackage()) {
                    ClassTreeTool.this.treeModel.removeNodeFromParent(classTreeNode);
                }
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                ClassTreeNode classTreeNode = this.findNode(string2);
                classTreeNode.removeClass(string3);
                if (this.isPackage() && classTreeNode.getChildCount() < 1) {
                    ClassTreeTool.this.treeModel.removeNodeFromParent(classTreeNode);
                }
            }
        }

        private ClassTreeNode findNode(String string) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ClassTreeNode classTreeNode = (ClassTreeNode)this.getChildAt(i);
                int n = string.compareTo(classTreeNode.toString());
                if (n == 0) {
                    return classTreeNode;
                }
                if (n <= 0) continue;
                return null;
            }
            return null;
        }
    }

    private class ClassTreeToolListener
    extends JDIAdapter
    implements JDIListener,
    SessionListener {
        private ClassTreeToolListener() {
        }

        public void sessionStart(EventObject eventObject) {
            try {
                for (ReferenceType referenceType : ClassTreeTool.this.runtime.allClasses()) {
                    ClassTreeTool.this.root.addClass(referenceType);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (NoSessionException noSessionException) {
                // empty catch block
            }
        }

        public void sessionInterrupt(EventObject eventObject) {
        }

        public void sessionContinue(EventObject eventObject) {
        }

        public void classPrepare(ClassPrepareEventSet classPrepareEventSet) {
            ClassTreeTool.this.root.addClass(classPrepareEventSet.getReferenceType());
        }

        public void classUnload(ClassUnloadEventSet classUnloadEventSet) {
            ClassTreeTool.this.root.removeClass(classUnloadEventSet.getClassName());
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            ClassTreeTool.this.root = ClassTreeTool.this.createClassTree(HEADING);
            ClassTreeTool.this.treeModel = new DefaultTreeModel(ClassTreeTool.this.root);
            ClassTreeTool.this.tree.setModel(ClassTreeTool.this.treeModel);
        }
    }
}

