/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUtilConstants;
import sun.awt.X11.XWINProtocol;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XWM
implements MWMConstants,
XUtilConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XWM");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWM");
    private static final Logger stateLog = Logger.getLogger("sun.awt.X11.states.XWM");
    static final XAtom XA_MWM_HINTS = new XAtom();
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static XAtom XA_WM_STATE = new XAtom();
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    static final int AWT_NET_N_KNOWN_STATES = 2;
    static final XAtom XA_E_FRAME_SIZE = new XAtom();
    static final XAtom XA_KDE_NET_WM_FRAME_STRUT = new XAtom();
    static final XAtom XA_KWM_WIN_ICONIFIED = new XAtom();
    static final XAtom XA_KWM_WIN_MAXIMIZED = new XAtom();
    static final XAtom XA_OL_DECOR_DEL = new XAtom();
    static final XAtom XA_OL_DECOR_HEADER = new XAtom();
    static final XAtom XA_OL_DECOR_RESIZE = new XAtom();
    static final XAtom XA_OL_DECOR_PIN = new XAtom();
    static final XAtom XA_OL_DECOR_CLOSE = new XAtom();
    static final XAtom XA_NET_FRAME_EXTENTS = new XAtom();
    static final XAtom XA_NET_REQUEST_FRAME_EXTENTS = new XAtom();
    static final int UNDETERMINED_WM = 1;
    static final int NO_WM = 2;
    static final int OTHER_WM = 3;
    static final int OPENLOOK_WM = 4;
    static final int MOTIF_WM = 5;
    static final int CDE_WM = 6;
    static final int ENLIGHTEN_WM = 7;
    static final int KDE2_WM = 8;
    static final int SAWFISH_WM = 9;
    static final int ICE_WM = 10;
    static final int METACITY_WM = 11;
    static final int COMPIZ_WM = 12;
    static final int LG3D_WM = 13;
    static final int CWM_WM = 14;
    int WMID;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    static final Insets defaultInsets = new Insets(25, 5, 5, 5);
    static XNETProtocol g_net_protocol = null;
    static XWINProtocol g_win_protocol = null;
    static XAtom XA_ENLIGHTENMENT_COMMS = new XAtom("ENLIGHTENMENT_COMMS", false);
    static final XAtom XA_DT_SM_WINDOW_INFO = new XAtom("_DT_SM_WINDOW_INFO", false);
    static final XAtom XA_DT_SM_STATE_INFO = new XAtom("_DT_SM_STATE_INFO", false);
    static final XAtom XA_MOTIF_WM_INFO = new XAtom("_MOTIF_WM_INFO", false);
    static final XAtom XA_DT_WORKSPACE_CURRENT = new XAtom("_DT_WORKSPACE_CURRENT", false);
    static final XAtom XA_ICEWM_WINOPTHINT = new XAtom("_ICEWM_WINOPTHINT", false);
    static final char[] opt = new char[]{'A', 'W', 'T', '_', 'I', 'C', 'E', 'W', 'M', '_', 'T', 'E', 'S', 'T', '\u0000', 'a', 'l', 'l', 'W', 'o', 'r', 'k', 's', 'p', 'a', 'c', 'e', 's', '\u0000', '0', '\u0000'};
    static final XAtom XA_SUN_WM_PROTOCOLS = new XAtom("_SUN_WM_PROTOCOLS", false);
    private static boolean winmgr_running = false;
    private static XErrorHandler detectWMHandler = new XErrorHandler.XBaseErrorHandler(){

        public int handleError(long l, XErrorEvent xErrorEvent) {
            if (xErrorEvent.get_request_code() == 2 && xErrorEvent.get_error_code() == 10) {
                winmgr_running = true;
                return 0;
            }
            return super.handleError(l, xErrorEvent);
        }
    };
    static int awt_wmgr = 1;
    static XWM wm;
    HashMap<Class<?>, Collection<XProtocol>> protocolsMap = new HashMap();
    static boolean inited;
    HashMap storedInsets = new HashMap();
    static int awtWMStaticGravity;

    public String toString() {
        switch (this.WMID) {
            case 2: {
                return "NO WM";
            }
            case 3: {
                return "Other WM";
            }
            case 4: {
                return "OPENLOOK";
            }
            case 5: {
                return "MWM";
            }
            case 6: {
                return "DTWM";
            }
            case 7: {
                return "Enlightenment";
            }
            case 8: {
                return "KWM2";
            }
            case 9: {
                return "Sawfish";
            }
            case 10: {
                return "IceWM";
            }
            case 11: {
                return "Metacity";
            }
            case 12: {
                return "Compiz";
            }
            case 13: {
                return "LookingGlass";
            }
            case 14: {
                return "CWM";
            }
        }
        return "Undetermined WM";
    }

    XWM(int n) {
        this.WMID = n;
        this.initializeProtocols();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Window manager: " + this.toString());
        }
    }

    int getID() {
        return this.WMID;
    }

    static Insets normalize(Insets insets) {
        if (insets.top > 64 || insets.top < 0) {
            insets.top = 28;
        }
        if (insets.left > 32 || insets.left < 0) {
            insets.left = 6;
        }
        if (insets.right > 32 || insets.right < 0) {
            insets.right = 6;
        }
        if (insets.bottom > 32 || insets.bottom < 0) {
            insets.bottom = 6;
        }
        return insets;
    }

    static boolean isNetWMName(String string) {
        if (g_net_protocol != null) {
            return g_net_protocol.isWMName(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initAtoms() {
        long l;
        block6: {
            block5: {
                int n;
                Object[][] objectArrayArray = new Object[][]{{XA_WM_STATE, "WM_STATE"}, {XA_KDE_NET_WM_FRAME_STRUT, "_KDE_NET_WM_FRAME_STRUT"}, {XA_E_FRAME_SIZE, "_E_FRAME_SIZE"}, {XA_KWM_WIN_ICONIFIED, "KWM_WIN_ICONIFIED"}, {XA_KWM_WIN_MAXIMIZED, "KWM_WIN_MAXIMIZED"}, {XA_OL_DECOR_DEL, "_OL_DECOR_DEL"}, {XA_OL_DECOR_HEADER, "_OL_DECOR_HEADER"}, {XA_OL_DECOR_RESIZE, "_OL_DECOR_RESIZE"}, {XA_OL_DECOR_PIN, "_OL_DECOR_PIN"}, {XA_OL_DECOR_CLOSE, "_OL_DECOR_CLOSE"}, {XA_MWM_HINTS, "_MOTIF_WM_HINTS"}, {XA_NET_FRAME_EXTENTS, "_NET_FRAME_EXTENTS"}, {XA_NET_REQUEST_FRAME_EXTENTS, "_NET_REQUEST_FRAME_EXTENTS"}};
                String[] stringArray = new String[objectArrayArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = (String)objectArrayArray[n][1];
                }
                n = XAtom.getAtomSize();
                l = unsafe.allocateMemory(stringArray.length * n);
                XToolkit.awtLock();
                try {
                    int n2 = XlibWrapper.XInternAtoms(XToolkit.getDisplay(), stringArray, false, l);
                    if (n2 == 0) {
                        Object var9_5 = null;
                        break block5;
                    }
                    int n3 = 0;
                    for (int i = 0; i < stringArray.length; ++i, n3 += n) {
                        ((XAtom)objectArrayArray[i][0]).setValues(XToolkit.getDisplay(), stringArray[i], XAtom.getAtom(l + (long)n3));
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    XToolkit.awtUnlock();
                    unsafe.freeMemory(l);
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            unsafe.freeMemory(l);
            return;
        }
        Object var9_6 = null;
        XToolkit.awtUnlock();
        unsafe.freeMemory(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNoWM() {
        XSetWindowAttributes xSetWindowAttributes;
        block8: {
            String string = XlibWrapper.ServerVendor(XToolkit.getDisplay());
            if (string.indexOf("eXcursion") != -1) {
                if (insLog.isLoggable(Level.FINE)) {
                    insLog.finer("eXcursion means NO_WM");
                }
                return true;
            }
            xSetWindowAttributes = new XSetWindowAttributes();
            try {
                long l = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
                String string2 = "WM_S" + l;
                long l2 = XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), XAtom.get(string2).getAtom());
                if (insLog.isLoggable(Level.FINE)) {
                    insLog.finer("selection owner of " + string2 + " is " + l2);
                }
                if (l2 == 0L) break block8;
                boolean bl = false;
                Object var9_7 = null;
                xSetWindowAttributes.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                xSetWindowAttributes.dispose();
                throw throwable;
            }
        }
        winmgr_running = false;
        xSetWindowAttributes.set_event_mask(0x100000L);
        XToolkit.WITH_XERROR_HANDLER(detectWMHandler);
        XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, xSetWindowAttributes.pData);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (!winmgr_running) {
            xSetWindowAttributes.set_event_mask(0L);
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, xSetWindowAttributes.pData);
            if (insLog.isLoggable(Level.FINE)) {
                insLog.finer("It looks like there is no WM thus NO_WM");
            }
        }
        boolean bl = !winmgr_running;
        Object var9_8 = null;
        xSetWindowAttributes.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getECommsWindowIDProperty(long l) {
        long l6;
        WindowPropertyGetter windowPropertyGetter;
        block14: {
            long l5;
            block13: {
                long l3;
                block12: {
                    if (!XA_ENLIGHTENMENT_COMMS.isInterned()) {
                        return 0L;
                    }
                    windowPropertyGetter = new WindowPropertyGetter(l, XA_ENLIGHTENMENT_COMMS, 0L, 14L, false, 31L);
                    try {
                        int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                        if (n != 0 || windowPropertyGetter.getData() == 0L) {
                            long l2 = 0L;
                            Object var14_6 = null;
                            windowPropertyGetter.dispose();
                            return l2;
                        }
                        if (windowPropertyGetter.getActualType() != 31L || windowPropertyGetter.getActualFormat() != 8 || windowPropertyGetter.getNumberOfItems() != 14 || windowPropertyGetter.getBytesAfter() != 0L) {
                            l3 = 0L;
                            break block12;
                        }
                        byte[] byArray = XlibWrapper.getStringBytes(windowPropertyGetter.getData());
                        String string = new String(byArray);
                        log.finer("ENLIGHTENMENT_COMMS is " + string);
                        Pattern pattern = Pattern.compile("WINID\\s+(\\p{XDigit}{0,8})");
                        try {
                            Matcher matcher = pattern.matcher(string);
                            if (matcher.matches()) {
                                log.finest("Match group count: " + matcher.groupCount());
                                String string2 = matcher.group(1);
                                log.finest("Match group 1 " + string2);
                                long l4 = Long.parseLong(string2, 16);
                                log.finer("Enlightenment communication window " + l4);
                                l5 = l4;
                                break block13;
                            }
                        }
                        catch (Exception exception) {
                            if (log.isLoggable(Level.FINER)) {
                                exception.printStackTrace();
                            }
                            long l7 = 0L;
                            Object var14_10 = null;
                            windowPropertyGetter.dispose();
                            return l7;
                        }
                        {
                            log.finer("ENLIGHTENMENT_COMMS has wrong format");
                            l6 = 0L;
                        }
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        Object var14_11 = null;
                        windowPropertyGetter.dispose();
                        throw throwable2;
                    }
                }
                Object var14_7 = null;
                windowPropertyGetter.dispose();
                return l3;
            }
            Object var14_8 = null;
            windowPropertyGetter.dispose();
            return l5;
        }
        Object var14_9 = null;
        windowPropertyGetter.dispose();
        return l6;
    }

    static boolean isEnlightenment() {
        long l = XWM.getECommsWindowIDProperty(XToolkit.getDefaultRootWindow());
        if (l == 0L) {
            return false;
        }
        long l2 = XWM.getECommsWindowIDProperty(l);
        return l2 == l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isCDE() {
        if (!XA_DT_SM_WINDOW_INFO.isInterned()) {
            if (!log.isLoggable(Level.FINER)) return false;
            log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_DT_SM_WINDOW_INFO)});
            return false;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_DT_SM_WINDOW_INFO, 0L, 2L, false, XA_DT_SM_WINDOW_INFO);
        try {
            WindowPropertyGetter windowPropertyGetter2;
            block13: {
                block12: {
                    boolean bl;
                    int n = windowPropertyGetter.execute();
                    if (n != 0 || windowPropertyGetter.getData() == 0L) {
                        log.finer("Getting of _DT_SM_WINDOW_INFO is not successfull");
                        boolean bl2 = false;
                        Object var9_5 = null;
                        windowPropertyGetter.dispose();
                        return bl2;
                    }
                    if (windowPropertyGetter.getActualType() != XA_DT_SM_WINDOW_INFO.getAtom() || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != 2 || windowPropertyGetter.getBytesAfter() != 0L) {
                        log.finer("Wrong format of _DT_SM_WINDOW_INFO");
                        boolean bl3 = false;
                        Object var9_6 = null;
                        windowPropertyGetter.dispose();
                        return bl3;
                    }
                    long l = Native.getWindow(windowPropertyGetter.getData(), 1);
                    if (l == 0L) {
                        log.fine("WARNING: DT_SM_WINDOW_INFO exists but returns zero windows");
                        boolean bl4 = false;
                        Object var9_7 = null;
                        windowPropertyGetter.dispose();
                        return bl4;
                    }
                    if (!XA_DT_SM_STATE_INFO.isInterned()) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_DT_SM_STATE_INFO)});
                        }
                        boolean bl5 = false;
                        Object var9_8 = null;
                        windowPropertyGetter.dispose();
                        return bl5;
                    }
                    windowPropertyGetter2 = new WindowPropertyGetter(l, XA_DT_SM_STATE_INFO, 0L, 1L, false, XA_DT_SM_STATE_INFO);
                    try {
                        n = windowPropertyGetter2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                        if (n == 0 && windowPropertyGetter2.getData() != 0L) break block12;
                        log.finer("Getting of _DT_SM_STATE_INFO is not successfull");
                        bl = false;
                        Object var7_19 = null;
                        windowPropertyGetter2.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var7_22 = null;
                        windowPropertyGetter2.dispose();
                        throw throwable;
                    }
                    Object var9_9 = null;
                    windowPropertyGetter.dispose();
                    return bl;
                }
                if (windowPropertyGetter2.getActualType() == XA_DT_SM_STATE_INFO.getAtom() && windowPropertyGetter2.getActualFormat() == 32) break block13;
                log.finer("Wrong format of _DT_SM_STATE_INFO");
                boolean bl = false;
                Object var7_20 = null;
                windowPropertyGetter2.dispose();
                Object var9_10 = null;
                windowPropertyGetter.dispose();
                return bl;
            }
            boolean bl = true;
            Object var7_21 = null;
            windowPropertyGetter2.dispose();
            Object var9_11 = null;
            windowPropertyGetter.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isMotif() {
        WindowPropertyGetter windowPropertyGetter;
        block13: {
            boolean bl;
            block16: {
                boolean bl2;
                block15: {
                    boolean bl3;
                    block14: {
                        boolean bl4;
                        block12: {
                            if (!XA_MOTIF_WM_INFO.isInterned()) {
                                return false;
                            }
                            windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_MOTIF_WM_INFO, 0L, 2L, false, XA_MOTIF_WM_INFO);
                            try {
                                int n = windowPropertyGetter.execute();
                                if (n != 0 || windowPropertyGetter.getData() == 0L) {
                                    boolean bl5 = false;
                                    Object var9_5 = null;
                                    windowPropertyGetter.dispose();
                                    return bl5;
                                }
                                if (windowPropertyGetter.getActualType() != XA_MOTIF_WM_INFO.getAtom() || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != 2 || windowPropertyGetter.getBytesAfter() != 0L) {
                                    bl4 = false;
                                    break block12;
                                }
                                long l = Native.getLong(windowPropertyGetter.getData(), 1);
                                if (l == 0L) break block13;
                                if (XA_DT_WORKSPACE_CURRENT.isInterned()) {
                                    XAtom[] xAtomArray = XA_DT_WORKSPACE_CURRENT.getAtomListProperty(l);
                                    if (xAtomArray.length == 0) {
                                        bl3 = false;
                                        break block14;
                                    }
                                    bl2 = true;
                                    break block15;
                                }
                                WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l, XA_WM_STATE, 0L, 1L, false, XA_WM_STATE);
                                try {
                                    if (windowPropertyGetter2.execute() == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == XA_WM_STATE.getAtom()) {
                                        bl = true;
                                        Object var7_17 = null;
                                        windowPropertyGetter2.dispose();
                                        break block16;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var7_19 = null;
                                    windowPropertyGetter2.dispose();
                                    throw throwable;
                                }
                                {
                                    Object var7_18 = null;
                                    windowPropertyGetter2.dispose();
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                windowPropertyGetter.dispose();
                                throw throwable;
                            }
                        }
                        Object var9_6 = null;
                        windowPropertyGetter.dispose();
                        return bl4;
                    }
                    Object var9_7 = null;
                    windowPropertyGetter.dispose();
                    return bl3;
                }
                Object var9_8 = null;
                windowPropertyGetter.dispose();
                return bl2;
            }
            Object var9_9 = null;
            windowPropertyGetter.dispose();
            return bl;
        }
        Object var9_10 = null;
        windowPropertyGetter.dispose();
        return false;
    }

    static boolean isSawfish() {
        return XWM.isNetWMName("Sawfish");
    }

    static boolean isKDE2() {
        return XWM.isNetWMName("KWin");
    }

    static boolean isCompiz() {
        return XWM.isNetWMName("compiz");
    }

    static boolean isLookingGlass() {
        return XWM.isNetWMName("LG3D");
    }

    static boolean isCWM() {
        return XWM.isNetWMName("CWM");
    }

    static boolean isMetacity() {
        return XWM.isNetWMName("Metacity");
    }

    static boolean isNonReparentingWM() {
        return XWM.getWMID() == 12 || XWM.getWMID() == 13 || XWM.getWMID() == 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prepareIsIceWM() {
        block5: {
            boolean bl;
            if (!XA_ICEWM_WINOPTHINT.isInterned()) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_ICEWM_WINOPTHINT)});
                }
                return false;
            }
            XToolkit.awtLock();
            try {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XlibWrapper.XChangePropertyS(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT.getAtom(), XA_ICEWM_WINOPTHINT.getAtom(), 8, 0, new String(opt));
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0) break block5;
                log.finer("Erorr getting XA_ICEWM_WINOPTHINT property");
                bl = false;
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return bl;
        }
        log.finer("Prepared for IceWM detection");
        boolean bl = true;
        Object var2_3 = null;
        XToolkit.awtUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isIceWM() {
        if (!XA_ICEWM_WINOPTHINT.isInterned()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_ICEWM_WINOPTHINT)});
            }
            return false;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT, 0L, 65535L, true, XA_ICEWM_WINOPTHINT);
        try {
            int n = windowPropertyGetter.execute();
            boolean bl = n == 0 && windowPropertyGetter.getActualType() != 0L;
            log.finer("Status getting XA_ICEWM_WINOPTHINT: " + !bl);
            boolean bl2 = !bl || XWM.isNetWMName("IceWM");
            Object var5_4 = null;
            windowPropertyGetter.dispose();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
    }

    static boolean isOpenLook() {
        if (!XA_SUN_WM_PROTOCOLS.isInterned()) {
            return false;
        }
        XAtom[] xAtomArray = XA_SUN_WM_PROTOCOLS.getAtomListProperty(XToolkit.getDefaultRootWindow());
        return xAtomArray.length != 0;
    }

    static XWM getWM() {
        if (wm == null) {
            awt_wmgr = XWM.getWMID();
            wm = new XWM(awt_wmgr);
        }
        return wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWMID() {
        XSetWindowAttributes xSetWindowAttributes;
        block6: {
            int n;
            if (insLog.isLoggable(Level.FINEST)) {
                insLog.finest("awt_wmgr = " + awt_wmgr);
            }
            if (awt_wmgr != 1) {
                return awt_wmgr;
            }
            xSetWindowAttributes = new XSetWindowAttributes();
            XToolkit.awtLock();
            try {
                if (!XWM.isNoWM()) break block6;
                n = awt_wmgr = 2;
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                XToolkit.awtUnlock();
                xSetWindowAttributes.dispose();
                throw throwable;
            }
            XToolkit.awtUnlock();
            xSetWindowAttributes.dispose();
            return n;
        }
        XNETProtocol xNETProtocol = g_net_protocol = new XNETProtocol();
        xNETProtocol.detect();
        if (log.isLoggable(Level.FINE) && xNETProtocol.active()) {
            log.fine("_NET_WM_NAME is " + xNETProtocol.getWMName());
        }
        XWINProtocol xWINProtocol = g_win_protocol = new XWINProtocol();
        xWINProtocol.detect();
        boolean bl = XWM.prepareIsIceWM();
        awt_wmgr = XWM.isEnlightenment() ? 7 : (XWM.isMetacity() ? 11 : (XWM.isSawfish() ? 9 : (XWM.isKDE2() ? 8 : (XWM.isCompiz() ? 12 : (XWM.isLookingGlass() ? 13 : (XWM.isCWM() ? 14 : (bl && XWM.isIceWM() ? 10 : (xNETProtocol.active() ? 3 : (xWINProtocol.active() ? 3 : (XWM.isCDE() ? 6 : (XWM.isMotif() ? 5 : (XWM.isOpenLook() ? 4 : 3))))))))))));
        int n = awt_wmgr;
        Object var6_4 = null;
        XToolkit.awtUnlock();
        xSetWindowAttributes.dispose();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void removeSizeHints(XDecoratedPeer xDecoratedPeer, long l) {
        block5: {
            block4: {
                l &= 0x30L;
                XToolkit.awtLock();
                try {
                    XSizeHints xSizeHints = xDecoratedPeer.getHints();
                    if ((xSizeHints.get_flags() & l) == 0L) {
                        Object var5_3 = null;
                        break block4;
                    }
                    xSizeHints.set_flags(xSizeHints.get_flags() & (l ^ 0xFFFFFFFFFFFFFFFFL));
                    if (insLog.isLoggable(Level.FINER)) {
                        insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(xSizeHints.get_flags()));
                    }
                    XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), xDecoratedPeer.getWindow(), xSizeHints.pData);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var5_4 = null;
        XToolkit.awtUnlock();
    }

    static int normalizeMotifDecor(int n) {
        if ((n & 1) == 0) {
            return n;
        }
        int n2 = 126;
        return n2 &= ~n;
    }

    static int normalizeMotifFunc(int n) {
        if ((n & 1) == 0) {
            return n;
        }
        int n2 = 62;
        return n2 &= ~n;
    }

    static void setOLDecor(XWindow xWindow, boolean bl, int n) {
        if (xWindow == null) {
            return;
        }
        XAtomList xAtomList = new XAtomList();
        n = XWM.normalizeMotifDecor(n);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.finer("Setting OL_DECOR to " + Integer.toBinaryString(n));
        }
        if ((n & 8) == 0) {
            xAtomList.add(XA_OL_DECOR_HEADER);
        }
        if ((n & 0x44) == 0) {
            xAtomList.add(XA_OL_DECOR_RESIZE);
        }
        if ((n & 0x70) == 0) {
            xAtomList.add(XA_OL_DECOR_CLOSE);
        }
        if (xAtomList.size() == 0) {
            insLog.finer("Deleting OL_DECOR");
            XA_OL_DECOR_DEL.DeleteProperty(xWindow);
        } else {
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting OL_DECOR to " + xAtomList);
            }
            XA_OL_DECOR_DEL.setAtomListProperty((XBaseWindow)xWindow, xAtomList);
        }
    }

    static void setMotifDecor(XWindowPeer xWindowPeer, boolean bl, int n, int n2) {
        if ((n & 1) != 0 && n != 1) {
            n = XWM.normalizeMotifDecor(n);
        }
        if ((n2 & 1) != 0 && n2 != 1) {
            n2 = XWM.normalizeMotifFunc(n2);
        }
        PropMwmHints propMwmHints = xWindowPeer.getMWMHints();
        propMwmHints.set_flags(propMwmHints.get_flags() | 1L | 2L);
        propMwmHints.set_functions(n2);
        propMwmHints.set_decorations(n);
        if (stateLog.isLoggable(Level.FINER)) {
            stateLog.finer("Setting MWM_HINTS to " + propMwmHints);
        }
        xWindowPeer.setMWMHints(propMwmHints);
    }

    static boolean needRemap(XDecoratedPeer xDecoratedPeer) {
        return !xDecoratedPeer.isEmbedded();
    }

    static void setShellDecor(XDecoratedPeer xDecoratedPeer) {
        int n = xDecoratedPeer.getDecorations();
        int n2 = xDecoratedPeer.getFunctions();
        boolean bl = xDecoratedPeer.isResizable();
        if (!bl) {
            n = (n & 1) != 0 ? (n |= 0x44) : (n &= 0xFFFFFFBB);
        }
        XWM.setMotifDecor(xDecoratedPeer, bl, n, n2);
        XWM.setOLDecor(xDecoratedPeer, bl, n);
        if (xDecoratedPeer.isShowing() && XWM.needRemap(xDecoratedPeer)) {
            xDecoratedPeer.xSetVisible(false);
            XToolkit.XSync();
            xDecoratedPeer.xSetVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellResizable(XDecoratedPeer xDecoratedPeer) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell resizable " + xDecoratedPeer);
        }
        XToolkit.awtLock();
        try {
            Rectangle rectangle = xDecoratedPeer.getShellBounds();
            rectangle.translate(-xDecoratedPeer.currentInsets.left, -xDecoratedPeer.currentInsets.top);
            xDecoratedPeer.updateSizeHints(xDecoratedPeer.getDimensions());
            XWM.requestWMExtents(xDecoratedPeer.getWindow());
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), xDecoratedPeer.getShell(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XWM.removeSizeHints(xDecoratedPeer, 32L);
            xDecoratedPeer.updateMinimumSize();
            XWM.setShellDecor(xDecoratedPeer);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellNotResizable(XDecoratedPeer xDecoratedPeer, WindowDimensions windowDimensions, Rectangle rectangle, boolean bl) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting non-resizable shell " + xDecoratedPeer + ", dimensions " + windowDimensions + ", shellBounds " + rectangle + ", just change size: " + bl);
        }
        XToolkit.awtLock();
        try {
            if (!rectangle.isEmpty()) {
                xDecoratedPeer.updateSizeHints(windowDimensions);
                XWM.requestWMExtents(xDecoratedPeer.getWindow());
                XToolkit.XSync();
                XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), xDecoratedPeer.getShell(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!bl) {
                XWM.setShellDecor(xDecoratedPeer);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    Collection<XProtocol> getProtocols(Class clazz) {
        Collection<XProtocol> collection = this.protocolsMap.get(clazz);
        if (collection != null) {
            return collection;
        }
        return new LinkedList<XProtocol>();
    }

    void addProtocol(Class clazz, XProtocol xProtocol) {
        Collection<XProtocol> collection = this.getProtocols(clazz);
        collection.add(xProtocol);
        this.protocolsMap.put(clazz, collection);
    }

    boolean supportsDynamicLayout() {
        int n = XWM.getWMID();
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return false;
    }

    boolean supportsExtendedState(int n) {
        switch (n) {
            case 2: 
            case 4: {
                if (XWM.getWMID() == 11) {
                    return false;
                }
            }
            case 6: {
                for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
                    if (!xStateProtocol.supportsState(n)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    int getExtendedState(XWindowPeer xWindowPeer) {
        Iterator<XProtocol> iterator = this.getProtocols(XStateProtocol.class).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            XStateProtocol xStateProtocol = (XStateProtocol)((Object)iterator.next());
            n |= xStateProtocol.getState(xWindowPeer);
        }
        if (n != 0) {
            return n;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    Integer isStateChange(XDecoratedPeer xDecoratedPeer, XPropertyEvent xPropertyEvent) {
        int n;
        if (!xDecoratedPeer.isShowing()) {
            stateLog.finer("Window is not showing");
            return null;
        }
        int n2 = xDecoratedPeer.getWMState();
        if (n2 == 0) {
            stateLog.finer("WithdrawnState");
            return null;
        }
        stateLog.finer("Window WM_STATE is " + n2);
        boolean bl = false;
        if (xPropertyEvent.get_atom() == XA_WM_STATE.getAtom()) {
            bl = true;
        }
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            bl |= xStateProtocol.isStateChange(xPropertyEvent);
        }
        boolean n22 = false;
        if (bl) {
            void var6_10;
            if (n2 == 3) {
                boolean bl2 = true;
            } else {
                boolean bl3 = false;
            }
            n = var6_10 | this.getExtendedState(xDecoratedPeer);
        }
        if (bl) {
            return n;
        }
        return null;
    }

    void setLayer(XWindowPeer xWindowPeer, int n) {
        for (XLayerProtocol xLayerProtocol : this.getProtocols(XLayerProtocol.class)) {
            if (!xLayerProtocol.supportsLayer(n)) continue;
            xLayerProtocol.setLayer(xWindowPeer, n);
        }
        XToolkit.XSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExtendedState(XWindowPeer xWindowPeer, int n) {
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            if (!xStateProtocol.supportsState(n)) continue;
            xStateProtocol.setState(xWindowPeer, n);
            break;
        }
        if (!xWindowPeer.isShowing()) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xWindowPeer.getWindow(), XA_KWM_WIN_ICONIFIED.getAtom());
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xWindowPeer.getWindow(), XA_KWM_WIN_MAXIMIZED.getAtom());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        XToolkit.XSync();
    }

    void unshadeKludge(XDecoratedPeer xDecoratedPeer) {
        assert (xDecoratedPeer.isShowing());
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            xStateProtocol.unshadeKludge(xDecoratedPeer);
        }
        XToolkit.XSync();
    }

    static void init() {
        if (inited) {
            return;
        }
        XWM.initAtoms();
        XWM.getWM();
        inited = true;
    }

    void initializeProtocols() {
        XWINProtocol xWINProtocol;
        XNETProtocol xNETProtocol = g_net_protocol;
        if (xNETProtocol != null) {
            if (!xNETProtocol.active()) {
                xNETProtocol = null;
            } else {
                if (xNETProtocol.doStateProtocol()) {
                    this.addProtocol(XStateProtocol.class, xNETProtocol);
                }
                if (xNETProtocol.doLayerProtocol()) {
                    this.addProtocol(XLayerProtocol.class, xNETProtocol);
                }
            }
        }
        if ((xWINProtocol = g_win_protocol) != null && xWINProtocol.active()) {
            if (xWINProtocol.doStateProtocol()) {
                this.addProtocol(XStateProtocol.class, xWINProtocol);
            }
            if (xWINProtocol.doLayerProtocol()) {
                this.addProtocol(XLayerProtocol.class, xWINProtocol);
            }
        }
    }

    Insets guessInsets(XDecoratedPeer xDecoratedPeer) {
        Insets insets = (Insets)this.storedInsets.get(xDecoratedPeer.getClass());
        if (insets == null) {
            switch (this.WMID) {
                case 7: {
                    insets = new Insets(19, 4, 4, 4);
                    break;
                }
                case 6: {
                    insets = new Insets(28, 6, 6, 6);
                    break;
                }
                case 2: 
                case 13: {
                    insets = zeroInsets;
                    break;
                }
                default: {
                    insets = defaultInsets;
                }
            }
        }
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.finest("WM guessed insets: " + insets);
        }
        return insets;
    }

    static boolean configureGravityBuggy() {
        if (awtWMStaticGravity == -1) {
            int n = awtWMStaticGravity = XToolkit.getEnv("_JAVA_AWT_WM_STATIC_GRAVITY") != null ? 1 : 0;
        }
        if (awtWMStaticGravity == 1) {
            return true;
        }
        switch (XWM.getWMID()) {
            case 10: {
                if (g_net_protocol != null) {
                    String string = g_net_protocol.getWMName();
                    Pattern pattern = Pattern.compile("^IceWM (\\d+)\\.(\\d+)\\.(\\d+).*$");
                    try {
                        Matcher matcher = pattern.matcher(string);
                        if (matcher.matches()) {
                            int n = Integer.parseInt(matcher.group(1));
                            int n2 = Integer.parseInt(matcher.group(2));
                            int n3 = Integer.parseInt(matcher.group(3));
                            return n <= 1 && (n != 1 || n2 <= 2 && (n2 != 2 || n3 < 2));
                        }
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static Insets getInsetsFromExtents(long l) {
        if (l == 0L) {
            return null;
        }
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        if (xNETProtocol != null && xNETProtocol.active()) {
            Insets insets = XWM.getInsetsFromProp(l, XA_NET_FRAME_EXTENTS);
            if (insLog.isLoggable(Level.FINE)) {
                insLog.log(Level.FINE, "_NET_FRAME_EXTENTS: {0}", String.valueOf(insets));
            }
            if (insets != null) {
                return insets;
            }
        }
        switch (XWM.getWMID()) {
            case 8: {
                return XWM.getInsetsFromProp(l, XA_KDE_NET_WM_FRAME_STRUT);
            }
            case 7: {
                return XWM.getInsetsFromProp(l, XA_E_FRAME_SIZE);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getInsetsFromProp(long l, XAtom xAtom) {
        WindowPropertyGetter windowPropertyGetter;
        block4: {
            if (l == 0L) {
                return null;
            }
            windowPropertyGetter = new WindowPropertyGetter(l, xAtom, 0L, 4L, false, 6L);
            try {
                if (windowPropertyGetter.execute() == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 6L && windowPropertyGetter.getActualFormat() == 32) break block4;
                Insets insets = null;
                Object var6_5 = null;
                windowPropertyGetter.dispose();
                return insets;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        Insets insets = new Insets((int)Native.getCard32(windowPropertyGetter.getData(), 2), (int)Native.getCard32(windowPropertyGetter.getData(), 0), (int)Native.getCard32(windowPropertyGetter.getData(), 3), (int)Native.getCard32(windowPropertyGetter.getData(), 1));
        Object var6_6 = null;
        windowPropertyGetter.dispose();
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestWMExtents(long l) {
        if (l == 0L) {
            return;
        }
        log.fine("Requesting FRAME_EXTENTS");
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.zero();
        xClientMessageEvent.set_type(33);
        xClientMessageEvent.set_display(XToolkit.getDisplay());
        xClientMessageEvent.set_window(l);
        xClientMessageEvent.set_format(32);
        XToolkit.awtLock();
        try {
            XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
            if (xNETProtocol != null && xNETProtocol.active()) {
                xClientMessageEvent.set_message_type(XA_NET_REQUEST_FRAME_EXTENTS.getAtom());
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xClientMessageEvent.getPData());
            }
            if (XWM.getWMID() == 8) {
                xClientMessageEvent.set_message_type(XA_KDE_NET_WM_FRAME_STRUT.getAtom());
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xClientMessageEvent.getPData());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            XToolkit.awtUnlock();
            xClientMessageEvent.dispose();
            throw throwable;
        }
        XToolkit.awtUnlock();
        xClientMessageEvent.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean syncTopLevelPos(long l, XWindowAttributes xWindowAttributes) {
        block5: {
            boolean bl;
            block4: {
                int n = 0;
                XToolkit.awtLock();
                try {
                    do {
                        XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                        if (xWindowAttributes.get_x() != 0 || xWindowAttributes.get_y() != 0) {
                            bl = true;
                            Object var7_5 = null;
                            break block4;
                        }
                        XToolkit.XSync();
                    } while (++n < 50);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return bl;
        }
        Object var7_6 = null;
        XToolkit.awtUnlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Insets getInsets(XDecoratedPeer xDecoratedPeer, long l, long l2) {
        Insets insets = XWM.getInsetsFromExtents(l);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.log(Level.FINER, "Got insets from property: {0}", String.valueOf(insets));
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
            insets.top = -1;
            insets.left = -1;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            XWindowAttributes xWindowAttributes2 = new XWindowAttributes();
            try {
                switch (XWM.getWMID()) {
                    case 7: {
                        this.syncTopLevelPos(l2, xWindowAttributes);
                        insets.left = xWindowAttributes.get_x();
                        insets.top = xWindowAttributes.get_y();
                        XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), XlibUtil.getParentWindow(l2), xWindowAttributes2.pData);
                        insets.right = xWindowAttributes2.get_width() - (xWindowAttributes.get_width() + insets.left);
                        insets.bottom = xWindowAttributes2.get_height() - (xWindowAttributes.get_height() + insets.top);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 10: {
                        if (!this.syncTopLevelPos(l2, xWindowAttributes)) {
                            Insets insets2 = null;
                            Object var14_9 = null;
                            xWindowAttributes.dispose();
                            xWindowAttributes2.dispose();
                            return insets2;
                        }
                        insets.top = xWindowAttributes.get_y();
                        insets.right = insets.left = xWindowAttributes.get_x();
                        insets.bottom = insets.left;
                        break;
                    }
                    case 4: 
                    case 9: {
                        this.syncTopLevelPos(l, xWindowAttributes);
                        insets.top = xWindowAttributes.get_y();
                        insets.right = insets.left = xWindowAttributes.get_x();
                        insets.bottom = insets.left;
                        break;
                    }
                    default: {
                        if (insLog.isLoggable(Level.FINEST)) {
                            insLog.log(Level.FINEST, "Getting correct insets for OTHER_WM/default, parent: {0}", String.valueOf(l2));
                        }
                        this.syncTopLevelPos(l2, xWindowAttributes);
                        int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                        n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes2.pData);
                        if (xWindowAttributes.get_root() == l2) {
                            insLog.finest("our parent is root so insets should be zero");
                            insets = new Insets(0, 0, 0, 0);
                            break;
                        }
                        if (xWindowAttributes.get_x() == 0 && xWindowAttributes.get_y() == 0 && xWindowAttributes.get_width() + 2 * xWindowAttributes.get_border_width() == xWindowAttributes2.get_width() && xWindowAttributes.get_height() + 2 * xWindowAttributes.get_border_width() == xWindowAttributes2.get_height()) {
                            if (insLog.isLoggable(Level.FINEST)) {
                                insLog.log(Level.FINEST, "Double reparenting detected, pattr({2})={0}, lwinAttr({3})={1}", new Object[]{String.valueOf(xWindowAttributes), String.valueOf(xWindowAttributes2), String.valueOf(l2), String.valueOf(l)});
                            }
                            xWindowAttributes.set_x(xWindowAttributes2.get_x());
                            xWindowAttributes.set_y(xWindowAttributes2.get_y());
                            xWindowAttributes.set_border_width(xWindowAttributes.get_border_width() + xWindowAttributes2.get_border_width());
                            long l3 = XlibUtil.getParentWindow(l2);
                            if (l3 == xWindowAttributes.get_root()) {
                                Insets insets3 = null;
                                Object var14_10 = null;
                                xWindowAttributes.dispose();
                                xWindowAttributes2.dispose();
                                return insets3;
                            }
                            l2 = l3;
                            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes2.pData);
                        }
                        if (insLog.isLoggable(Level.FINEST)) {
                            insLog.log(Level.FINEST, "Attrs before calculation: pattr({2})={0}, lwinAttr({3})={1}", new Object[]{String.valueOf(xWindowAttributes), String.valueOf(xWindowAttributes2), String.valueOf(l2), String.valueOf(l)});
                        }
                        insets = new Insets(xWindowAttributes.get_y() + xWindowAttributes.get_border_width(), xWindowAttributes.get_x() + xWindowAttributes.get_border_width(), xWindowAttributes2.get_height() - (xWindowAttributes.get_y() + xWindowAttributes.get_height() + 2 * xWindowAttributes.get_border_width()), xWindowAttributes2.get_width() - (xWindowAttributes.get_x() + xWindowAttributes.get_width() + 2 * xWindowAttributes.get_border_width()));
                        break;
                    }
                }
                Object var14_11 = null;
                xWindowAttributes.dispose();
                xWindowAttributes2.dispose();
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                xWindowAttributes.dispose();
                xWindowAttributes2.dispose();
                throw throwable;
            }
        }
        if (this.storedInsets.get(xDecoratedPeer.getClass()) == null) {
            this.storedInsets.put(xDecoratedPeer.getClass(), insets);
        }
        return insets;
    }

    boolean isDesktopWindow(long l) {
        if (g_net_protocol != null) {
            XAtomList xAtomList = XAtom.get("_NET_WM_WINDOW_TYPE").getAtomListPropertyList(l);
            return xAtomList.contains(XAtom.get("_NET_WM_WINDOW_TYPE_DESKTOP"));
        }
        return false;
    }

    public XNETProtocol getNETProtocol() {
        return g_net_protocol;
    }

    public boolean setNetWMIcon(XWindowPeer xWindowPeer, List<XIconInfo> list) {
        if (g_net_protocol != null && g_net_protocol.active()) {
            g_net_protocol.setWMIcons(xWindowPeer, list);
            return XWM.getWMID() != 10;
        }
        return false;
    }

    static {
        inited = false;
        awtWMStaticGravity = -1;
    }
}

