/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;
import sun.swing.DefaultLookup;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    protected void uninstallDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.chooser.getChooserPanels();
        for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
            this.chooser.removeChooserPanel(abstractColorChooserPanelArray[i]);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("ColorChooser.tabPane");
        this.tabbedPane.setInheritsPopupMenu(true);
        this.singlePanel = new JPanel(new CenterLayout());
        this.singlePanel.setName("ColorChooser.panel");
        this.singlePanel.setInheritsPopupMenu(true);
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new CenterLayout());
        this.previewPanelHolder.setName("ColorChooser.previewPanelHolder");
        if (DefaultLookup.getBoolean(this.chooser, this, "ColorChooser.showPreviewPanelText", true)) {
            String string = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
            this.previewPanelHolder.setBorder(new TitledBorder(string));
        }
        this.previewPanelHolder.setInheritsPopupMenu(true);
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallDefaultChoosers();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
        this.handler = null;
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.getHandler());
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        Dimension dimension = new Dimension();
        if (this.previewPanel != null) {
            dimension = new BorderLayout().minimumLayoutSize(this.previewPanel);
            if (this.previewPanelHolder != null && this.chooser != null && dimension.getWidth() + dimension.getHeight() == 0.0) {
                this.chooser.remove(this.previewPanelHolder);
                return;
            }
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.getHandler());
        this.previewPanel.setInheritsPopupMenu(true);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        LookAndFeel.installProperty(this.chooser, "opaque", Boolean.TRUE);
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = this.getHandler();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.getHandler());
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicColorChooserUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    private class Handler
    implements ChangeListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (BasicColorChooserUI.this.previewPanel != null) {
                BasicColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                BasicColorChooserUI.this.previewPanel.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicColorChooserUI.this.chooser.getDragEnabled()) {
                TransferHandler transferHandler = BasicColorChooserUI.this.chooser.getTransferHandler();
                transferHandler.exportAsDrag(BasicColorChooserUI.this.chooser, mouseEvent, 1);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            String string = propertyChangeEvent.getPropertyName();
            if (string == "chooserPanels") {
                Container container;
                Container container2;
                int n;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                for (n = 0; n < ((AbstractColorChooserPanel[])object2).length; ++n) {
                    container2 = object2[n].getParent();
                    if (container2 == null) continue;
                    container = container2.getParent();
                    if (container != null) {
                        container.remove(container2);
                    }
                    object2[n].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                }
                n = ((AbstractColorChooserPanel[])object).length;
                if (n == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    container2 = new JPanel(new CenterLayout());
                    ((JComponent)container2).setInheritsPopupMenu(true);
                    container2.add((Component)object[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)container2, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        container = new JPanel(new CenterLayout());
                        ((JComponent)container).setInheritsPopupMenu(true);
                        String string2 = ((AbstractColorChooserPanel)object[i]).getDisplayName();
                        int n2 = ((AbstractColorChooserPanel)object[i]).getMnemonic();
                        container.add((Component)object[i]);
                        BasicColorChooserUI.this.tabbedPane.addTab(string2, container);
                        if (n2 <= 0) continue;
                        BasicColorChooserUI.this.tabbedPane.setMnemonicAt(i, n2);
                        BasicColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i, ((AbstractColorChooserPanel)object[i]).getDisplayedMnemonicIndex());
                    }
                }
                BasicColorChooserUI.this.chooser.applyComponentOrientation(BasicColorChooserUI.this.chooser.getComponentOrientation());
                for (int i = 0; i < ((Object)object).length; ++i) {
                    ((AbstractColorChooserPanel)object[i]).installChooserPanel(BasicColorChooserUI.this.chooser);
                }
            }
            if (string == "previewPanel" && propertyChangeEvent.getNewValue() != BasicColorChooserUI.this.previewPanel) {
                BasicColorChooserUI.this.installPreviewPanel();
            }
            if (string == "componentOrientation") {
                object2 = (ComponentOrientation)propertyChangeEvent.getNewValue();
                object = (JColorChooser)propertyChangeEvent.getSource();
                if (object2 != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    ((Container)object).applyComponentOrientation((ComponentOrientation)object2);
                    ((JColorChooser)object).updateUI();
                }
            }
        }
    }
}

