/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

class ColorChooserDialog
extends JDialog {
    private Color initialColor;
    private JColorChooser chooserPane;
    private JButton cancelButton;

    public ColorChooserDialog(Dialog dialog, String string, boolean bl, Component component, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) throws HeadlessException {
        super(dialog, string, bl);
        this.initColorChooserDialog(component, jColorChooser, actionListener, actionListener2);
    }

    public ColorChooserDialog(Frame frame, String string, boolean bl, Component component, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) throws HeadlessException {
        super(frame, string, bl);
        this.initColorChooserDialog(component, jColorChooser, actionListener, actionListener2);
    }

    protected void initColorChooserDialog(Component component, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) {
        boolean bl;
        this.chooserPane = jColorChooser;
        String string = UIManager.getString("ColorChooser.okText");
        String string2 = UIManager.getString("ColorChooser.cancelText");
        String string3 = UIManager.getString("ColorChooser.resetText");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jColorChooser, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(string);
        this.getRootPane().setDefaultButton(jButton);
        jButton.setActionCommand("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.hide();
            }
        });
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        jPanel.add(jButton);
        this.cancelButton = new JButton(string2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((AbstractButton)actionEvent.getSource()).fireActionPerformed(actionEvent);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this.cancelButton.getInputMap(2);
        ActionMap actionMap = this.cancelButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.hide();
            }
        });
        if (actionListener2 != null) {
            this.cancelButton.addActionListener(actionListener2);
        }
        jPanel.add(this.cancelButton);
        JButton jButton2 = new JButton(string3);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.reset();
            }
        });
        int n = SwingUtilities2.getUIDefaultsInt((Object)"ColorChooser.resetMnemonic", -1);
        if (n != -1) {
            jButton2.setMnemonic(n);
        }
        jPanel.add(jButton2);
        container.add((Component)jPanel, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(5);
        }
        this.applyComponentOrientation((component == null ? this.getRootPane() : component).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(component);
        this.addWindowListener(new Closer());
    }

    @Override
    public void show() {
        this.initialColor = this.chooserPane.getColor();
        super.show();
    }

    public void reset() {
        this.chooserPane.setColor(this.initialColor);
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }

    class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ColorChooserDialog.this.cancelButton.doClick(0);
            Window window = windowEvent.getWindow();
            window.hide();
        }
    }
}

