/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRU;
import java.nio.FloatBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferU
extends FloatBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.viewedBuffer = directBuffer;
    }

    public FloatBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        assert (n4 >= 0);
        return new DirectFloatBufferU(this, -1, 0, n3, n3, n4);
    }

    public FloatBuffer duplicate() {
        return new DirectFloatBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + (long)(n << 2);
    }

    public float get() {
        return unsafe.getFloat(this.ix(this.nextGetIndex()));
    }

    public float get(int n) {
        return unsafe.getFloat(this.ix(this.checkIndex(n)));
    }

    public FloatBuffer get(float[] fArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectFloatBufferU.checkBounds(n, n2, fArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n4), fArray, n << 2, n2 << 2);
            } else {
                Bits.copyToByteArray(this.ix(n4), fArray, n << 2, n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.get(fArray, n, n2);
        }
        return this;
    }

    public FloatBuffer put(float f) {
        unsafe.putFloat(this.ix(this.nextPutIndex()), f);
        return this;
    }

    public FloatBuffer put(int n, float f) {
        unsafe.putFloat(this.ix(this.checkIndex(n)), f);
        return this;
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof DirectFloatBufferU) {
            int n;
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferU directFloatBufferU = (DirectFloatBufferU)floatBuffer;
            int n2 = directFloatBufferU.position();
            int n3 = directFloatBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directFloatBufferU.ix(n2), this.ix(n5), n4 << 2);
            directFloatBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (floatBuffer.hb != null) {
            int n = floatBuffer.position();
            int n8 = floatBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(floatBuffer.hb, floatBuffer.offset + n, n9);
            floatBuffer.position(n + n9);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectFloatBufferU.checkBounds(n, n2, fArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(fArray, n << 2, this.ix(n4), n2 << 2);
            } else {
                Bits.copyFromByteArray(fArray, n << 2, this.ix(n4), n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.put(fArray, n, n2);
        }
        return this;
    }

    public FloatBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

