/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class UsageModelTracker
implements Disposable {
    private final List<UsageModelTrackerListener> myListeners = ContainerUtil.createEmptyCOWList();

    public UsageModelTracker(Project project) {
        PsiTreeChangeAdapter myPsiListener = new PsiTreeChangeAdapter(){

            @Override
            public void childAdded(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childRemoved(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childReplaced(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childrenChanged(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childMoved(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void propertyChanged(PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, true);
            }
        };
        PsiManager.getInstance(project).addPsiTreeChangeListener(myPsiListener, this);
    }

    private void doFire(PsiTreeChangeEvent event, boolean propertyChange) {
        if (!(event.getFile() instanceof PsiCodeFragment)) {
            for (UsageModelTrackerListener listener : this.myListeners) {
                listener.modelChanged(propertyChange);
            }
        }
    }

    public void dispose() {
    }

    public void addListener(UsageModelTrackerListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(UsageModelTrackerListener listener) {
        this.myListeners.remove(listener);
    }

    public static interface UsageModelTrackerListener {
        public void modelChanged(boolean var1);
    }
}

