/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableTree
extends Tree {
    private Border myBorder;
    private final TreeTable myTreeTable;
    private int myVisibleRow;
    private boolean myCellFocused;

    public TreeTableTree(TreeModel model, TreeTable treeTable) {
        super(model);
        this.myTreeTable = treeTable;
        this.setCellRenderer(this.getCellRenderer());
    }

    public TreeTable getTreeTable() {
        return this.myTreeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer tcr = super.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            dtcr.setTextSelectionColor(UIUtil.getTableSelectionForeground());
            dtcr.setBackgroundSelectionColor(UIUtil.getTableSelectionBackground());
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.myTreeTable != null && this.myTreeTable.getRowHeight() != rowHeight) {
                this.myTreeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.myTreeTable.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics g1 = g.create();
        g1.translate(0, -this.myVisibleRow * this.getRowHeight());
        super.paint(g1);
        g1.dispose();
        if (this.myBorder != null) {
            this.myBorder.paintBorder(this, g, 0, 0, this.myTreeTable.getWidth(), this.getRowHeight());
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.myBorder = border;
    }

    public void setTreeTableTreeBorder(Border border) {
        this.myBorder = border;
    }

    public void setVisibleRow(int row) {
        this.myVisibleRow = row;
        this.setPreferredSize(new Dimension(this.getPreferredSize().height, this.getRowBounds((int)this.myVisibleRow).width));
    }

    public void _processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public void setCellFocused(boolean focused) {
        this.myCellFocused = focused;
    }

    @Override
    public void setCellRenderer(final TreeCellRenderer x) {
        super.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return x.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, TreeTableTree.this.myCellFocused);
            }
        });
    }
}

