/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TodoAttributes
implements JDOMExternalizable,
Cloneable {
    public static final Icon DEFAULT_ICON = IconLoader.getIcon((String)"/general/todoDefault.png");
    public static final Icon QUESTION_ICON = IconLoader.getIcon((String)"/general/todoQuestion.png");
    public static final Icon IMPORTANT_ICON = IconLoader.getIcon((String)"/general/todoImportant.png");
    private Icon myIcon;
    private TextAttributes myTextAttributes = new TextAttributes();
    private boolean myShouldUseCustomColors;
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ICON_DEFAULT = "default";
    @NonNls
    private static final String ICON_QUESTION = "question";
    @NonNls
    private static final String ICON_IMPORTANT = "important";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String USE_CUSTOM_COLORS_ATT = "useCustomColors";

    public TodoAttributes() {
    }

    private TodoAttributes(Icon icon, TextAttributes textAttributes) {
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public TextAttributes getTextAttributes() {
        return this.shouldUseCustomTodoColor() ? this.getCustomizedTextAttributes() : TodoAttributes.getDefaultColorSchemeTextAttributes();
    }

    public TextAttributes getCustomizedTextAttributes() {
        return this.myTextAttributes;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public static TodoAttributes createDefault() {
        TextAttributes textAttributes = TodoAttributes.getDefaultColorSchemeTextAttributes();
        return new TodoAttributes(DEFAULT_ICON, textAttributes);
    }

    private static TextAttributes getDefaultColorSchemeTextAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
    }

    public void readExternal(Element element) throws InvalidDataException {
        String useCustomColors;
        String icon = element.getAttributeValue(ATTRIBUTE_ICON, ICON_DEFAULT);
        if (ICON_DEFAULT.equals(icon)) {
            this.myIcon = DEFAULT_ICON;
        } else if (ICON_QUESTION.equals(icon)) {
            this.myIcon = QUESTION_ICON;
        } else if (ICON_IMPORTANT.equals(icon)) {
            this.myIcon = IMPORTANT_ICON;
        } else {
            throw new InvalidDataException(icon);
        }
        this.myTextAttributes.readExternal(element);
        if (element.getChild(ELEMENT_OPTION) == null) {
            this.myTextAttributes = TodoAttributes.getDefaultColorSchemeTextAttributes();
        }
        this.myShouldUseCustomColors = (useCustomColors = element.getAttributeValue(USE_CUSTOM_COLORS_ATT)) == null ? false : Boolean.valueOf(useCustomColors);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String icon;
        if (this.myIcon == DEFAULT_ICON) {
            icon = ICON_DEFAULT;
        } else if (this.myIcon == QUESTION_ICON) {
            icon = ICON_QUESTION;
        } else if (this.myIcon == IMPORTANT_ICON) {
            icon = ICON_IMPORTANT;
        } else {
            throw new WriteExternalException("");
        }
        element.setAttribute(ATTRIBUTE_ICON, icon);
        this.myTextAttributes.writeExternal(element);
        element.setAttribute(USE_CUSTOM_COLORS_ATT, Boolean.toString(this.shouldUseCustomTodoColor()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        if (this.myIcon != attributes.myIcon) {
            return false;
        }
        if (this.myTextAttributes != null ? !this.myTextAttributes.equals(attributes.myTextAttributes) : attributes.myTextAttributes != null) {
            return false;
        }
        return this.myShouldUseCustomColors == attributes.myShouldUseCustomColors;
    }

    public int hashCode() {
        int result = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result = 29 * result + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        result = 29 * result + Boolean.valueOf(this.myShouldUseCustomColors).hashCode();
        return result;
    }

    public boolean shouldUseCustomTodoColor() {
        return this.myShouldUseCustomColors;
    }

    public void setUseCustomTodoColor(boolean useCustomColors) {
        this.myShouldUseCustomColors = useCustomColors;
    }

    public TodoAttributes clone() {
        try {
            TextAttributes textAttributes = this.myTextAttributes.clone();
            TodoAttributes attributes = (TodoAttributes)super.clone();
            attributes.myTextAttributes = textAttributes;
            attributes.myShouldUseCustomColors = this.myShouldUseCustomColors;
            return attributes;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

