/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions = new THashMap();
    private final Map<String, List<T>> myCache = new HashMap<String, List<T>>();
    private final JBReentrantReadWriteLock mutex = LockFactory.createReadWriteLock();
    private final JBLock r = this.mutex.readLock();
    private final JBLock w = this.mutex.writeLock();
    private ExtensionPoint<KeyedLazyInstance<T>> myPoint;
    private final String myEpName;
    private ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;
    private final List<ExtensionPointListener<T>> myListeners = ContainerUtil.createEmptyCOWList();

    public KeyedExtensionCollector(@NonNls String epName) {
        this.myEpName = epName;
        this.resetAreaListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAreaListener() {
        this.w.lock();
        try {
            this.myCache.clear();
            if (this.myPoint != null) {
                this.myPoint.removeExtensionPointListener(this.myListener);
                this.myPoint = null;
                this.myListener = null;
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(KeyT key, T t) {
        this.w.lock();
        try {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list == null) {
                list = new ArrayList<T>();
                this.myExplicitExtensions.put(skey, list);
            }
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(KeyT key, T t) {
        this.w.lock();
        try {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                this.myCache.remove(skey);
            }
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    protected abstract String keyToString(KeyT var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<T> forKey(KeyT key) {
        List<T> list;
        List<T> cache;
        String stringKey;
        block10: {
            stringKey = this.keyToString(key);
            this.r.lock();
            cache = this.myCache.get(stringKey);
            if (cache == null) break block10;
            List<T> list2 = cache;
            list = list2;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/KeyedExtensionCollector.forKey must not return null");
            return list;
            finally {
                this.r.unlock();
            }
        }
        this.w.lock();
        cache = this.buildExtensions(stringKey, key);
        this.myCache.put(stringKey, cache);
        List<T> list3 = cache;
        list = list3;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/KeyedExtensionCollector.forKey must not return null");
        finally {
            this.w.unlock();
        }
    }

    protected List<T> buildExtensions(String stringKey, KeyT key) {
        return this.buildExtensions(Collections.singleton(stringKey));
    }

    protected final List<T> buildExtensions(Set<String> keys) {
        ArrayList result = null;
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!keys.contains(key)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            List<T> list = entry.getValue();
            result.addAll(list);
        }
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            KeyedLazyInstance[] beans;
            for (KeyedLazyInstance bean : beans = (KeyedLazyInstance[])point.getExtensions()) {
                Object instance;
                if (!keys.contains(bean.getKey())) continue;
                try {
                    instance = bean.getInstance();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(instance);
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        if (this.myPoint == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName)) {
            ExtensionPointName typesafe = ExtensionPointName.create((String)this.myEpName);
            this.myPoint = Extensions.getRootArea().getExtensionPoint(typesafe);
            this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionAdded(KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    KeyedExtensionCollector.this.w.lock();
                    try {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionAdded(bean.getInstance(), null);
                        }
                    }
                    finally {
                        KeyedExtensionCollector.this.w.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionRemoved(KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    KeyedExtensionCollector.this.w.lock();
                    try {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionRemoved(bean.getInstance(), null);
                        }
                    }
                    finally {
                        KeyedExtensionCollector.this.w.unlock();
                    }
                }

                public void areaReplaced(ExtensionsArea area) {
                    KeyedExtensionCollector.this.resetAreaListener();
                }
            };
            this.myPoint.addExtensionPointListener(this.myListener);
        }
        return this.myPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        this.w.lock();
        try {
            if (!this.myExplicitExtensions.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            boolean bl = point != null && point.hasAnyExtensions();
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public void addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector.addListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector.removeListener must not be null");
        }
        this.myListeners.remove(listener);
    }
}

