/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.ClassloaderUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorComparator;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.idea.Main;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.PluginsFacade;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.reflect.Reflection;

public class PluginManager {
    @NonNls
    public static final String AREA_IDEA_PROJECT = "IDEA_PROJECT";
    @NonNls
    public static final String AREA_IDEA_MODULE = "IDEA_MODULE";
    @NonNls
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    private static final Object PLUGIN_CLASSES_LOCK = new Object();
    private static String myPluginError = null;
    @NonNls
    public static final String CORE_PLUGIN_ID = "com.intellij";
    @NonNls
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    private static List<String> ourDisabledPlugins = null;
    static final Object lock = new Object();
    private static BuildNumber ourBuildNumber;
    @NonNls
    public static final String PLUGIN_XML = "plugin.xml";
    @NonNls
    public static final String META_INF = "META-INF";
    private static final Map<PluginId, Integer> ourId2Index;
    @NonNls
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final List<String> ourAvailableModules;
    public static long startupStart;
    private static IdeaPluginDescriptorImpl[] ourPlugins;
    private static Map<String, PluginId> ourPluginClasses;

    public static synchronized IdeaPluginDescriptor[] getPlugins() {
        if (ourPlugins == null) {
            PluginManager.initializePlugins();
            PluginManager.getLogger().info("Loaded plugins:" + StringUtil.join((Object[])ourPlugins, (Function)new Function<IdeaPluginDescriptorImpl, String>(){

                public String fun(IdeaPluginDescriptorImpl descriptor) {
                    String version = descriptor.getVersion();
                    return descriptor.getName() + (version != null ? " (" + version + ")" : "");
                }
            }, (String)", "));
            ClassloaderUtil.clearJarURLCache();
        }
        return ourPlugins;
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    protected static void start(final String mainClass, final String methodName, final String[] args) {
        startupStart = System.nanoTime();
        try {
            ThreadGroup threadGroup = new ThreadGroup("Idea Thread Group"){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof ProcessCanceledException)) {
                        PluginManager.getLogger().error(e);
                    }
                }
            };
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassloaderUtil.clearJarURLCache();
                        PluginsFacade.INSTANCE = new Facade();
                        Class<?> aClass = Class.forName(mainClass);
                        Method method = aClass.getDeclaredMethod(methodName, ArrayUtil.EMPTY_STRING_ARRAY.getClass());
                        method.setAccessible(true);
                        method.invoke(null, new Object[]{args});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PluginManager.getLogger().error("Error while accessing " + mainClass + "." + methodName + " with arguments: " + Arrays.asList(args), (Throwable)e);
                    }
                }
            };
            new Thread(threadGroup, runnable, "Idea Main Thread").start();
        }
        catch (Exception e) {
            PluginManager.getLogger().error((Throwable)e);
        }
    }

    private static void initializePlugins() {
        PluginManager.configureExtensions();
        IdeaPluginDescriptor[] pluginDescriptors = PluginManager.loadDescriptors();
        Class callerClass = Reflection.getCallerClass((int)1);
        ClassLoader parentLoader = callerClass.getClassLoader();
        ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : pluginDescriptors) {
            List<String> modules;
            if (ideaPluginDescriptorImpl.getPluginId().getIdString().equals(CORE_PLUGIN_ID) && (modules = ideaPluginDescriptorImpl.getModules()) != null) {
                ourAvailableModules.addAll(modules);
            }
            if (!PluginManager.shouldSkipPlugin(ideaPluginDescriptorImpl, pluginDescriptors)) {
                result.add(ideaPluginDescriptorImpl);
                continue;
            }
            ideaPluginDescriptorImpl.setEnabled(false);
            PluginManager.initClassLoader(parentLoader, ideaPluginDescriptorImpl);
        }
        PluginManager.prepareLoadingPluginsErrorMessage(PluginManager.filterBadPlugins(result));
        HashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl descriptor : result) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        IdeaPluginDescriptor corePluginDescriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(PluginId.getId((String)CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null);
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result) {
            if (ideaPluginDescriptorImpl == corePluginDescriptor) continue;
            ideaPluginDescriptorImpl.insertDependency(corePluginDescriptor);
        }
        PluginManager.mergeOptionalConfigs(idToDescriptorMap);
        Collections.sort(result, PluginManager.getPluginDescriptorComparator(idToDescriptorMap));
        for (int i = 0; i < result.size(); ++i) {
            ourId2Index.put(((IdeaPluginDescriptorImpl)result.get(i)).getPluginId(), i);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result) {
            if (ideaPluginDescriptorImpl.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || ideaPluginDescriptorImpl.isUseCoreClassLoader()) {
                ideaPluginDescriptorImpl.setLoader(parentLoader, true);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = ideaPluginDescriptorImpl.getClassPath();
                PluginId[] dependentPluginIds = ideaPluginDescriptorImpl.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManager.getParentLoaders(idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManager.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, ideaPluginDescriptorImpl);
                ideaPluginDescriptorImpl.setLoader(pluginClassLoader, true);
            }
            ideaPluginDescriptorImpl.registerExtensions();
        }
        ourPlugins = pluginDescriptors;
    }

    public static void initClassLoader(ClassLoader parentLoader, IdeaPluginDescriptorImpl descriptor) {
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManager.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader, false);
    }

    public static int getPluginLoadingOrder(PluginId id) {
        return ourId2Index.get(id);
    }

    private static void mergeOptionalConfigs(Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        HashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsWithModules = new HashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors);
        PluginManager.addModulesAsDependents(descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    private static void prepareLoadingPluginsErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            if (!Main.isHeadless() && !ApplicationManager.getApplication().isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManager.getLogger().error(errorMessage);
            }
        }
    }

    private static void configureExtensions() {
        Extensions.setLogProvider((LogProvider)new IdeaLogProvider());
        Extensions.registerAreaClass((String)AREA_IDEA_PROJECT, null);
        Extensions.registerAreaClass((String)AREA_IDEA_MODULE, (String)AREA_IDEA_PROJECT);
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static boolean shouldSkipPlugin(IdeaPluginDescriptor descriptor) {
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result = PluginManager.shouldSkipPlugin(descriptor, ourPlugins);
            descriptorImpl.setSkipped(result);
            return result;
        }
        return PluginManager.shouldSkipPlugin(descriptor, ourPlugins);
    }

    private static boolean shouldSkipPlugin(IdeaPluginDescriptor descriptor, IdeaPluginDescriptor[] loaded) {
        boolean shouldLoad;
        boolean checkModuleDependencies;
        String idString = descriptor.getPluginId().getIdString();
        if (idString.equals(CORE_PLUGIN_ID)) {
            return false;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !((IdeaPluginDescriptorImpl)descriptor).isEnabled()) {
                return true;
            }
            if (!PluginManager.shouldLoadPlugins()) {
                return true;
            }
        }
        List pluginIds = pluginId == null ? null : StringUtil.split((String)pluginId, (String)",");
        boolean bl = checkModuleDependencies = !ourAvailableModules.isEmpty() && !ourAvailableModules.contains("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManager.hasModuleDependencies(descriptor)) {
            return true;
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            shouldLoad = loadPluginCategory.equals(descriptor.getCategory());
        } else {
            if (pluginIds != null) {
                shouldLoad = pluginIds.contains(idString);
                if (!shouldLoad) {
                    HashMap<PluginId, IdeaPluginDescriptor> map = new HashMap<PluginId, IdeaPluginDescriptor>();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManager.addModulesAsDependents(map);
                    IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId((String)pluginId));
                    shouldLoad = descriptorFromProperty != null && PluginManager.isDependent(descriptorFromProperty, descriptor.getPluginId(), map, checkModuleDependencies);
                }
            } else {
                boolean bl2 = shouldLoad = !PluginManager.getDisabledPlugins().contains(idString);
            }
            if (shouldLoad && descriptor instanceof IdeaPluginDescriptorImpl && PluginManager.isIncompatible(descriptor)) {
                return true;
            }
        }
        return !shouldLoad;
    }

    private static <T extends IdeaPluginDescriptor> void addModulesAsDependents(Map<PluginId, T> map) {
        for (String module : ourAvailableModules) {
            map.put(PluginId.getId((String)module), new IdeaPluginDescriptorImpl(null));
        }
    }

    private static boolean hasModuleDependencies(IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManager.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModuleDependency(PluginId dependentPluginId) {
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    private static boolean isDependent(IdeaPluginDescriptor descriptor, PluginId on, Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (!checkModuleDependencies && PluginManager.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManager.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIncompatible(IdeaPluginDescriptor descriptor) {
        BuildNumber untilBuild;
        BuildNumber sinceBuild;
        BuildNumber buildNumber = null;
        try {
            buildNumber = PluginManager.getBuildNumber();
        }
        catch (RuntimeException e) {
            return false;
        }
        if (!StringUtil.isEmpty((String)descriptor.getSinceBuild()) && (sinceBuild = BuildNumber.fromString((String)descriptor.getSinceBuild())).compareTo(buildNumber) > 0) {
            return true;
        }
        return !StringUtil.isEmpty((String)descriptor.getUntilBuild()) && !buildNumber.isSnapshot() && (untilBuild = BuildNumber.fromString((String)descriptor.getUntilBuild())).compareTo(buildNumber) < 0;
    }

    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        Graph<PluginId> graph = PluginManager.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder builder = new DFSTBuilder(graph);
        final Comparator idComparator = builder.comparator();
        return new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return idComparator.compare(o1.getPluginId(), o2.getPluginId());
            }
        };
    }

    private static Graph<PluginId> createPluginIdGraph(final Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        final PluginId[] ids = idToDescriptorMap.keySet().toArray(new PluginId[idToDescriptorMap.size()]);
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<PluginId>(){

            public Collection<PluginId> getNodes() {
                return Arrays.asList(ids);
            }

            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    if (!idToDescriptorMap.containsKey(dependentPluginId)) continue;
                    plugins.add(dependentPluginId);
                }
                return plugins.iterator();
            }
        }));
    }

    private static ClassLoader[] getParentLoaders(Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, PluginId[] pluginIds) {
        if (PluginManager.isUnitTestMode()) {
            return new ClassLoader[0];
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManager.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        return classLoaders.toArray(new ClassLoader[classLoaders.size()]);
    }

    public static IdeaPluginDescriptorImpl[] loadDescriptors() {
        if (ClassloaderUtil.isLoadingOfExternalPluginsDisabled()) {
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        PluginManager.loadDescriptors(PathManager.getPluginsPath(), result);
        Application application = ApplicationManager.getApplication();
        if (application == null || !application.isUnitTestMode()) {
            PluginManager.loadDescriptors(PathManager.getPreinstalledPluginsPath(), result);
        }
        PluginManager.loadDescriptorsFromProperty(result);
        PluginManager.loadDescriptorsFromClassPath(result);
        IdeaPluginDescriptor[] pluginDescriptors = result.toArray(new IdeaPluginDescriptorImpl[result.size()]);
        try {
            Arrays.sort(pluginDescriptors, new PluginDescriptorComparator(pluginDescriptors));
        }
        catch (Exception e) {
            PluginManager.prepareLoadingPluginsErrorMessage(IdeBundle.message("error.plugins.were.not.loaded", e.getMessage()));
            PluginManager.getLogger().info((Throwable)e);
            pluginDescriptors = IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        return pluginDescriptors;
    }

    public static void reportPluginError() {
        if (myPluginError != null) {
            JOptionPane.showMessageDialog(null, myPluginError, IdeBundle.message("title.plugin.error", new Object[0]), 0);
            myPluginError = null;
        }
    }

    private static void loadDescriptorsFromProperty(List<IdeaPluginDescriptorImpl> result) {
        String pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH);
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManager.loadDescriptor(new File(s), PLUGIN_XML);
            if (ideaPluginDescriptor == null) continue;
            result.add(ideaPluginDescriptor);
        }
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result) {
        try {
            Collection<URL> urls = PluginManager.getClassLoaderUrls();
            for (URL url : urls) {
                String protocol = url.getProtocol();
                if (!"file".equals(protocol)) continue;
                File file = new File(URLDecoder.decode(url.getFile()));
                String platformPrefix = System.getProperty("idea.platform.prefix");
                IdeaPluginDescriptorImpl platformPluginDescriptor = null;
                if (platformPrefix != null && (platformPluginDescriptor = PluginManager.loadDescriptor(file, platformPrefix + "Plugin.xml")) != null && !result.contains(platformPluginDescriptor)) {
                    platformPluginDescriptor.setUseCoreClassLoader(true);
                    result.add(platformPluginDescriptor);
                }
                IdeaPluginDescriptorImpl pluginDescriptor = PluginManager.loadDescriptor(file, PLUGIN_XML);
                if (platformPrefix != null && pluginDescriptor != null && pluginDescriptor.getName().equals("IDEA CORE") || pluginDescriptor == null || result.contains(pluginDescriptor)) continue;
                if (platformPluginDescriptor != null) {
                    pluginDescriptor.setUseCoreClassLoader(true);
                }
                result.add(pluginDescriptor);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading plugins from classpath:");
            e.printStackTrace();
        }
    }

    private static Collection<URL> getClassLoaderUrls() {
        ClassLoader classLoader = PluginManager.class.getClassLoader();
        Class<?> aClass = classLoader.getClass();
        if (aClass.getName().equals(UrlClassLoader.class.getName())) {
            try {
                return (List)aClass.getDeclaredMethod("getUrls", new Class[0]).invoke((Object)classLoader, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (classLoader instanceof URLClassLoader) {
            return Arrays.asList(((URLClassLoader)classLoader).getURLs());
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String filterBadPlugins(List<IdeaPluginDescriptorImpl> result) {
        final HashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        final StringBuffer message = new StringBuffer();
        boolean pluginsWithoutIdFound = false;
        Iterator<IdeaPluginDescriptorImpl> it = result.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptorImpl descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
            }
            if (idToDescriptorMap.containsKey(id)) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(IdeBundle.message("message.duplicate.plugin.id", new Object[0]));
                message.append(id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManager.addModulesAsDependents(idToDescriptorMap);
        final ArrayList<String> disabledPluginIds = new ArrayList<String>();
        final Iterator<IdeaPluginDescriptorImpl> it2 = result.iterator();
        while (it2.hasNext()) {
            final IdeaPluginDescriptorImpl pluginDescriptor = it2.next();
            PluginManager.checkDependants(pluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>(){

                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                }
            }, new Condition<PluginId>(){

                public boolean value(PluginId pluginId) {
                    if (!idToDescriptorMap.containsKey(pluginId)) {
                        if (message.length() > 0) {
                            message.append("\n");
                        }
                        pluginDescriptor.setEnabled(false);
                        disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                        message.append(PluginManager.getDisabledPlugins().contains(pluginId.getIdString()) ? IdeBundle.message("error.required.plugin.disabled", pluginDescriptor.getPluginId(), pluginId) : IdeBundle.message("error.required.plugin.not.installed", pluginDescriptor.getPluginId(), pluginId));
                        it2.remove();
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            try {
                PluginManager.saveDisabledPlugins(disabledPluginIds, true);
            }
            catch (IOException e) {
                PluginManager.getLogger().error((Throwable)e);
            }
        }
        if (pluginsWithoutIdFound) {
            if (message.length() > 0) {
                message.append("\n");
            }
            message.append(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
        if (message.length() > 0) {
            message.insert(0, IdeBundle.message("error.problems.found.loading.plugins", new Object[0]));
            return message.toString();
        }
        return null;
    }

    public static void checkDependants(IdeaPluginDescriptor pluginDescriptor, Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, Condition<PluginId> check) {
        PluginManager.checkDependants(pluginDescriptor, pluginId2Descriptor, check, new HashSet<PluginId>());
    }

    private static boolean checkDependants(IdeaPluginDescriptor pluginDescriptor, Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, Condition<PluginId> check, Set<PluginId> processed) {
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        HashSet<PluginId> optionalDependencies = new HashSet<PluginId>(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManager.isModuleDependency(dependentPluginId) && (ourAvailableModules.isEmpty() || ourAvailableModules.contains(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value((Object)dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = (IdeaPluginDescriptor)pluginId2Descriptor.fun((Object)dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManager.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed)) continue;
            return false;
        }
        return true;
    }

    static BuildNumber getBuildNumber() {
        if (ourBuildNumber == null && (ourBuildNumber = BuildNumber.fromString((String)System.getProperty("idea.plugins.compatible.build"))) == null) {
            try {
                File buildTxtFile = FileUtil.findFirstThatExist((String[])new String[]{PathManager.getHomePath() + "/build.txt", PathManager.getHomePath() + "/community/build.txt"});
                ourBuildNumber = buildTxtFile != null ? BuildNumber.fromString((String)new String(FileUtil.loadFileText((File)buildTxtFile)).trim()) : BuildNumber.fromString((String)"95.SNAPSHOT");
            }
            catch (IOException e) {
                ourBuildNumber = BuildNumber.fromString((String)"95.SNAPSHOT");
            }
        }
        return ourBuildNumber;
    }

    private static void loadDescriptors(String pluginsPath, List<IdeaPluginDescriptorImpl> result) {
        File pluginsHome = new File(pluginsPath);
        File[] files = pluginsHome.listFiles();
        if (files != null) {
            for (File file : files) {
                IdeaPluginDescriptorImpl descriptor = PluginManager.loadDescriptor(file, PLUGIN_XML);
                if (descriptor == null) continue;
                int oldIndex = result.indexOf(descriptor);
                if (oldIndex >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result.get(oldIndex);
                    if (StringUtil.compareVersionNumbers((String)oldDescriptor.getVersion(), (String)descriptor.getVersion()) >= 0) continue;
                    result.set(oldIndex, descriptor);
                    continue;
                }
                result.add(descriptor);
            }
        }
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(File file, @NonNls String fileName) {
        IdeaPluginDescriptorImpl descriptor = null;
        if (file.isDirectory()) {
            descriptor = PluginManager.loadDescriptorFromDir(file, fileName);
            if (descriptor == null) {
                File libDir = new File(file, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (ClassloaderUtil.isJarOrZip((File)f)) {
                        descriptor1 = PluginManager.loadDescriptorFromJar(f, fileName);
                        if (descriptor1 == null) continue;
                        if (descriptor != null) {
                            PluginManager.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                            return null;
                        }
                        descriptor = descriptor1;
                        descriptor.setPath(file);
                        continue;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManager.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor != null) {
                        PluginManager.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                    descriptor.setPath(file);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".jar") && file.exists()) {
            descriptor = PluginManager.loadDescriptorFromJar(file, fileName);
        }
        if (descriptor != null && !descriptor.getOptionalConfigs().isEmpty()) {
            HashMap<PluginId, IdeaPluginDescriptorImpl> descriptors = new HashMap<PluginId, IdeaPluginDescriptorImpl>(descriptor.getOptionalConfigs().size());
            for (Map.Entry<PluginId, String> entry : descriptor.getOptionalConfigs().entrySet()) {
                IdeaPluginDescriptorImpl optionalDescriptor = PluginManager.loadDescriptor(file, entry.getValue());
                if (optionalDescriptor == null) continue;
                descriptors.put(entry.getKey(), optionalDescriptor);
            }
            descriptor.setOptionalDescriptors(descriptors);
        }
        return descriptor;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(File file, @NonNls String fileName) {
        IdeaPluginDescriptorImpl descriptor = null;
        File descriptorFile = new File(file, META_INF + File.separator + fileName);
        if (descriptorFile.exists()) {
            descriptor = new IdeaPluginDescriptorImpl(file);
            try {
                descriptor.readExternal(descriptorFile.toURL());
            }
            catch (Exception e) {
                System.err.println("Cannot load: " + descriptorFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
        return descriptor;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromJar(File file) {
        return PluginManager.loadDescriptorFromJar(file, PLUGIN_XML);
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(File file, @NonNls String fileName) {
        try {
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file);
            URI fileURL = file.toURI();
            URL jarURL = new URL("jar:" + StringUtil.replace((String)fileURL.toASCIIString(), (String)"!", (String)"%21") + "!/META-INF/" + fileName);
            descriptor.readExternal(jarURL);
            return descriptor;
        }
        catch (XmlSerializationException e) {
            PluginManager.getLogger().info("Cannot load " + file, (Throwable)e);
            PluginManager.prepareLoadingPluginsErrorMessage("Plugin file " + file.getName() + " contains invalid plugin descriptor file.");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            PluginManager.getLogger().info("Cannot load " + file, (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(File[] classPath, ClassLoader[] parentLoaders, IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManager.class.getClassLoader();
                Method addUrlMethod = PluginManager.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file.toURL());
                }
                return loader;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManager.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file = aClassPath.getCanonicalFile();
                urls.add(file.toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginRoot);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Method getAddUrlMethod(ClassLoader loader) throws NoSuchMethodException {
        if (loader instanceof URLClassLoader) {
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
            return addUrlMethod;
        }
        return loader.getClass().getDeclaredMethod("addURL", URL.class);
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManager.getPlugin(id) != null;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(PluginId id) {
        IdeaPluginDescriptor[] plugins;
        for (IdeaPluginDescriptor plugin : plugins = PluginManager.getPlugins()) {
            if (!Comparing.equal((Object)id, (Object)plugin.getPluginId())) continue;
            return plugin;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPluginClass(String className, PluginId pluginId) {
        Object object = PLUGIN_CLASSES_LOCK;
        synchronized (object) {
            if (ourPluginClasses == null) {
                ourPluginClasses = new THashMap();
            }
            ourPluginClasses.put(className, pluginId);
        }
    }

    public static boolean isPluginClass(String className) {
        return PluginManager.getPluginByClassName(className) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PluginId getPluginByClassName(String className) {
        Object object = PLUGIN_CLASSES_LOCK;
        synchronized (object) {
            return ourPluginClasses != null ? ourPluginClasses.get(className) : null;
        }
    }

    public static boolean disablePlugin(String id) {
        if (PluginManager.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManager.getDisabledPlugins().add(id);
        try {
            PluginManager.saveDisabledPlugins(PluginManager.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDisabledPlugins(Collection<String> ids, boolean append) throws IOException {
        File plugins = new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(plugins, append)));
            for (String id : ids) {
                printWriter.println(id);
            }
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManager.isUnitTestMode()) {
                PluginManager.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        return ourDisabledPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(String configPath, Collection<String> disabledPlugins) {
        File file = new File(configPath, DISABLED_PLUGINS_FILENAME);
        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                String id;
                reader = new BufferedReader(new FileReader(file));
                while ((id = reader.readLine()) != null) {
                    disabledPlugins.add(id.trim());
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public static void disableIncompatiblePlugin(Object cause, Throwable ex) {
        final PluginId pluginId = PluginManager.getPluginByClassName(cause.getClass().getName());
        if (pluginId == null || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(ex);
        }
        final boolean success = PluginManager.disablePlugin(pluginId.getIdString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Incompatible plugin detected: " + pluginId.getIdString() + (success ? "\nThe plugin has been disabled" : ""), "Plugin Manager", 0);
            }
        });
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpPluginClassStatistics() {
        if (!Boolean.valueOf(System.getProperty("idea.is.internal")).booleanValue()) {
            return;
        }
        HashMap<String, ClassCounter> pluginToClassMap = new HashMap<String, ClassCounter>();
        Object object = PLUGIN_CLASSES_LOCK;
        synchronized (object) {
            for (Map.Entry<String, PluginId> entry : ourPluginClasses.entrySet()) {
                String id = entry.getValue().toString();
                ClassCounter counter = (ClassCounter)pluginToClassMap.get(id);
                if (counter != null) {
                    counter.increment();
                    continue;
                }
                pluginToClassMap.put(id, new ClassCounter(id));
            }
        }
        ArrayList counters = new ArrayList(pluginToClassMap.values());
        Collections.sort(counters, new Comparator<ClassCounter>(){

            @Override
            public int compare(ClassCounter o1, ClassCounter o2) {
                return o2.myCount - o1.myCount;
            }
        });
        for (ClassCounter counter : counters) {
            PluginManager.getLogger().info(counter.toString());
        }
    }

    static {
        ourId2Index = new THashMap();
        ourAvailableModules = new ArrayList<String>();
    }

    private static class ClassCounter {
        private String myPluginId;
        private int myCount;

        private ClassCounter(String pluginId) {
            this.myPluginId = pluginId;
            this.myCount = 1;
        }

        private void increment() {
            ++this.myCount;
        }

        public String toString() {
            return this.myPluginId + ": " + this.myCount;
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        public void error(String message) {
            PluginManager.getLogger().error(message);
        }

        public void error(String message, Throwable t) {
            PluginManager.getLogger().error(message, t);
        }

        public void error(Throwable t) {
            PluginManager.getLogger().error(t);
        }

        public void warn(String message) {
            PluginManager.getLogger().info(message);
        }

        public void warn(String message, Throwable t) {
            PluginManager.getLogger().info(message, t);
        }

        public void warn(Throwable t) {
            PluginManager.getLogger().info(t);
        }
    }

    public static class Facade
    extends PluginsFacade {
        @Override
        public IdeaPluginDescriptor getPlugin(PluginId id) {
            return PluginManager.getPlugin(id);
        }

        @Override
        public IdeaPluginDescriptor[] getPlugins() {
            return PluginManager.getPlugins();
        }
    }
}

