/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.HashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;

public class PluginDescriptorComparator
implements Comparator<IdeaPluginDescriptor> {
    private final TObjectIntHashMap<PluginId> myIdToNumberMap = new TObjectIntHashMap();
    private int myAvailableNumber = 1;

    public PluginDescriptorComparator(IdeaPluginDescriptor[] descriptors) throws Exception {
        HashMap idToDescriptorMap = new HashMap();
        for (IdeaPluginDescriptor descriptor : descriptors) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        this.myIdToNumberMap.put((Object)PluginId.getId((String)"com.intellij"), 0);
        Stack<PluginId> visited = new Stack<PluginId>();
        for (int idx = 0; idx < descriptors.length && this.myIdToNumberMap.size() != descriptors.length; ++idx) {
            this.assignNumbers(descriptors[idx].getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)idToDescriptorMap, visited);
            visited.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignNumbers(PluginId id, Map<PluginId, IdeaPluginDescriptor> idToDescriptorMap, Stack<PluginId> visited) throws Exception {
        visited.push(id);
        try {
            PluginId[] parentIds;
            IdeaPluginDescriptor ideaPluginDescriptor = idToDescriptorMap.get(id);
            if (ideaPluginDescriptor == null) {
                return;
            }
            for (PluginId parentId : parentIds = ideaPluginDescriptor.getDependentPluginIds()) {
                if (!visited.contains(parentId)) continue;
                throw new Exception(IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + id + "->" + parentId + "->...->" + id);
            }
            for (PluginId parentId1 : parentIds) {
                this.assignNumbers(parentId1, idToDescriptorMap, visited);
            }
            if (!this.myIdToNumberMap.contains((Object)id)) {
                this.myIdToNumberMap.put((Object)id, this.myAvailableNumber++);
            }
        }
        finally {
            visited.pop();
        }
    }

    @Override
    public int compare(IdeaPluginDescriptor d1, IdeaPluginDescriptor d2) {
        return this.myIdToNumberMap.get((Object)d1.getPluginId()) - this.myIdToNumberMap.get((Object)d2.getPluginId());
    }
}

