/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.BlameCallback2;
import org.tigris.subversion.javahl.ChangelistCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.JavaHLObjectFactory;
import org.tigris.subversion.javahl.ListCallback;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.Notify;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.ProplistCallback;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientLogLevel;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnectorFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHSession;
import org.tmatesoft.svn.core.internal.util.DefaultSVNDebugFormatter;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.javahl.JavaHLAuthenticationProvider;
import org.tmatesoft.svn.core.javahl.JavaHLAuthenticationStorage;
import org.tmatesoft.svn.core.javahl.JavaHLCompositeLog;
import org.tmatesoft.svn.core.javahl.JavaHLDebugLog;
import org.tmatesoft.svn.core.javahl.JavaHLProgressLog;
import org.tmatesoft.svn.core.javahl.JavaHLPropertyHandler;
import org.tmatesoft.svn.core.javahl.SVNClientImplTracker;
import org.tmatesoft.svn.core.javahl.SVNClientImplVersion;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

public class SVNClientImpl
implements SVNClientInterface {
    private static int ourInstanceCount;
    private String myConfigDir;
    private PromptUserPassword myPrompt;
    private String myUserName;
    private String myPassword;
    private ISVNEventHandler mySVNEventListener;
    private ISVNConflictHandler mySVNConflictHandler;
    private Notify myNotify;
    private Notify2 myNotify2;
    private ConflictResolverCallback myConflictResolverCallback;
    private CommitMessage myMessageHandler;
    private DefaultSVNOptions myOptions;
    private boolean myCancelOperation = false;
    private SVNClientManager myClientManager;
    private SVNClientInterface myOwner;
    private JavaHLCompositeLog myDebugLog;
    private JavaHLProgressLog myProgressListener;
    private ISVNAuthenticationManager myAuthenticationManager;
    private ISVNAuthenticationStorage myAuthStorage;
    private static ISVNAuthenticationStorage ourAuthStorage;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$javahl$SVNClientImpl;

    public static SVNClientImpl newInstance() {
        return SVNClientImpl.newInstance(null);
    }

    public static SVNClientImpl newInstance(SVNClient owner) {
        return SVNClientImpl.newInstance(owner, null, null);
    }

    public static SVNClientImpl newInstance(SVNClient owner, IHTTPConnectionFactory httpConnectionFactory, ISVNConnectorFactory svnConnectorFactory) {
        return SVNClientImpl.newInstance(owner, httpConnectionFactory, svnConnectorFactory, true);
    }

    public static SVNClientImpl newInstance(SVNClient owner, IHTTPConnectionFactory httpConnectionFactory, ISVNConnectorFactory svnConnectorFactory, boolean trackClient) {
        SVNClientImpl client = new SVNClientImpl(owner, httpConnectionFactory, svnConnectorFactory);
        if (trackClient) {
            SVNClientImplTracker.registerClient(client);
        }
        return client;
    }

    protected SVNClientImpl(SVNClient owner) {
        this(owner, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNClientImpl(SVNClient owner, IHTTPConnectionFactory httpConnectionFactory, ISVNConnectorFactory svnConnectorFactory) {
        DAVRepositoryFactory.setup(httpConnectionFactory);
        SVNRepositoryFactoryImpl.setup(svnConnectorFactory);
        FSRepositoryFactory.setup();
        this.myConfigDir = SVNWCUtil.getDefaultConfigurationDirectory().getAbsolutePath();
        this.myOwner = owner == null ? this : owner;
        Class clazz = class$org$tmatesoft$svn$core$javahl$SVNClientImpl == null ? (class$org$tmatesoft$svn$core$javahl$SVNClientImpl = SVNClientImpl.class$("org.tmatesoft.svn.core.javahl.SVNClientImpl")) : class$org$tmatesoft$svn$core$javahl$SVNClientImpl;
        synchronized (clazz) {
            ++ourInstanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISVNAuthenticationStorage getRuntimeCredentialsStorage() {
        Class clazz = class$org$tmatesoft$svn$core$javahl$SVNClientImpl == null ? (class$org$tmatesoft$svn$core$javahl$SVNClientImpl = SVNClientImpl.class$("org.tmatesoft.svn.core.javahl.SVNClientImpl")) : class$org$tmatesoft$svn$core$javahl$SVNClientImpl;
        synchronized (clazz) {
            if (ourAuthStorage == null) {
                ourAuthStorage = new JavaHLAuthenticationStorage();
            }
            return ourAuthStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRuntimeCredentialsStorage(ISVNAuthenticationStorage storage) {
        Class clazz = class$org$tmatesoft$svn$core$javahl$SVNClientImpl == null ? (class$org$tmatesoft$svn$core$javahl$SVNClientImpl = SVNClientImpl.class$("org.tmatesoft.svn.core.javahl.SVNClientImpl")) : class$org$tmatesoft$svn$core$javahl$SVNClientImpl;
        synchronized (clazz) {
            ourAuthStorage = storage == null ? new JavaHLAuthenticationStorage() : storage;
        }
    }

    public ISVNAuthenticationStorage getClientCredentialsStorage() {
        if (this.myAuthStorage != null) {
            return this.myAuthStorage;
        }
        return SVNClientImpl.getRuntimeCredentialsStorage();
    }

    public void setClientCredentialsStorage(ISVNAuthenticationStorage storage) {
        this.myAuthStorage = storage;
        this.updateClientManager();
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            this.myDebugLog = new JavaHLCompositeLog();
            this.myDebugLog.addLogger(SVNDebugLog.getDefaultLog());
            this.myDebugLog.addLogger(JavaHLDebugLog.getInstance());
        }
        return this.myDebugLog;
    }

    public String getLastPath() {
        return null;
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll) throws ClientException {
        return this.status(path, descend, onServer, getAll, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore) throws ClientException {
        return this.status(path, descend, onServer, getAll, noIgnore, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals) throws ClientException {
        if (path == null) {
            return null;
        }
        final ArrayList statuses = new ArrayList();
        this.status(path, JavaHLObjectFactory.unknownOrImmediates(descend), onServer, getAll, noIgnore, ignoreExternals, null, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                statuses.add(JavaHLObjectFactory.createStatus(status.getFile().getPath(), status));
            }
        });
        return statuses.toArray(new Status[statuses.size()]);
    }

    public void status(String path, int depth, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals, String[] changelists, StatusCallback callback) throws ClientException {
        final StatusCallback statusCallback = callback;
        this.status(path, depth, onServer, getAll, noIgnore, ignoreExternals, changelists, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (statusCallback != null) {
                    statusCallback.doStatus(JavaHLObjectFactory.createStatus(status.getFile().getPath(), status));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(String path, int depth, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals, String[] changelists, ISVNStatusHandler handler) throws ClientException {
        if (path == null) {
            return;
        }
        SVNStatusClient stClient = this.getSVNStatusClient();
        boolean oldIgnoreExternals = stClient.isIgnoreExternals();
        stClient.setIgnoreExternals(ignoreExternals);
        try {
            stClient.doStatus(new File(path).getAbsoluteFile(), SVNRevision.HEAD, JavaHLObjectFactory.getSVNDepth(depth), onServer, getAll, noIgnore, !ignoreExternals, handler, JavaHLObjectFactory.getChangeListsCollection(changelists));
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            stClient.setIgnoreExternals(oldIgnoreExternals);
            this.resetLog();
        }
    }

    public Status singleStatus(String path, boolean onServer) throws ClientException {
        Status[] result = this.status(path, false, onServer, true, false, false);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    public DirEntry[] list(String url, Revision revision, boolean recurse) throws ClientException {
        return this.list(url, revision, revision, recurse);
    }

    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        final ArrayList allEntries = new ArrayList();
        this.list(url, revision, pegRevision, JavaHLObjectFactory.infinityOrImmediates(recurse), -1, false, new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) {
                if (dirEntry.getRelativePath().length() != 0) {
                    allEntries.add(JavaHLObjectFactory.createDirEntry(dirEntry));
                }
            }
        });
        return allEntries.toArray(new DirEntry[allEntries.size()]);
    }

    public void list(String url, Revision revision, Revision pegRevision, int depth, int direntFields, boolean fetchLocks, ListCallback callback) throws ClientException {
        final ListCallback listCallback = callback;
        this.list(url, revision, pegRevision, depth, direntFields, fetchLocks, new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) {
                if (listCallback != null) {
                    listCallback.doEntry(JavaHLObjectFactory.createDirEntry(dirEntry), JavaHLObjectFactory.createLock(dirEntry.getLock()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(String url, Revision revision, Revision pegRevision, int depth, int direntFields, boolean fetchLocks, ISVNDirEntryHandler handler) throws ClientException {
        SVNLogClient client = this.getSVNLogClient();
        try {
            if (SVNClientImpl.isURL(url)) {
                client.doList(SVNURL.parseURIEncoded(url), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), fetchLocks, JavaHLObjectFactory.getSVNDepth(depth), direntFields, handler);
            } else {
                client.doList(new File(url).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), fetchLocks, JavaHLObjectFactory.getSVNDepth(depth), direntFields, handler);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void username(String username) {
        this.myUserName = username;
        this.updateClientManager();
    }

    public void password(String password) {
        this.myPassword = password;
        this.updateClientManager();
    }

    public void setPrompt(PromptUserPassword prompt) {
        this.myPrompt = prompt;
        this.updateClientManager();
    }

    private void updateClientManager() {
        File configDir = this.myConfigDir == null ? null : new File(this.myConfigDir);
        this.myOptions = SVNWCUtil.createDefaultOptions(configDir, true);
        this.myOptions.setConflictHandler(this.getConflictHandler());
        this.myAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager(configDir, this.myUserName, this.myPassword, this.myOptions.isAuthStorageEnabled());
        if (this.myPrompt != null) {
            this.myAuthenticationManager.setAuthenticationProvider(new JavaHLAuthenticationProvider(this.myPrompt));
        } else {
            this.myAuthenticationManager.setAuthenticationProvider(null);
        }
        if (this.myAuthenticationManager instanceof DefaultSVNAuthenticationManager) {
            ((DefaultSVNAuthenticationManager)this.myAuthenticationManager).setRuntimeStorage(this.getClientCredentialsStorage());
        }
        if (this.myClientManager != null) {
            this.myClientManager.dispose();
            this.myClientManager.setAuthenticationManager(this.myAuthenticationManager);
            this.myClientManager.setOptions(this.myOptions);
        }
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, true, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, discoverPath, 0L);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, long limit) throws ClientException {
        final ArrayList entries = new ArrayList();
        String[] revisionProperties = new String[]{"svn:log", "svn:date", "svn:author"};
        this.logMessages(path, revisionEnd, revisionStart, revisionEnd, stopOnCopy, discoverPath, false, revisionProperties, limit, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                entries.add(JavaHLObjectFactory.createLogMessage(logEntry));
            }
        });
        return entries.toArray(new LogMessage[entries.size()]);
    }

    public void logMessages(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, String[] revProps, long limit, LogMessageCallback callback) throws ClientException {
        final LogMessageCallback logMessageCallback = callback;
        this.logMessages(path, pegRevision, revisionStart, revisionEnd, stopOnCopy, discoverPath, includeMergedRevisions, revProps, limit, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                JavaHLObjectFactory.handleLogMessage(logEntry, logMessageCallback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, boolean includeMergeInfo, String[] revisionProperties, long limit, ISVNLogEntryHandler logEntryHandler) throws ClientException {
        SVNLogClient client = this.getSVNLogClient();
        try {
            if (revisionEnd == null || revisionEnd.getKind() == 0) {
                revisionEnd = Revision.HEAD;
            }
            if (revisionStart != null && revisionStart.getKind() == 0) {
                revisionStart = Revision.getInstance((long)1L);
            }
            if (SVNClientImpl.isURL(path)) {
                if (revisionStart == null) {
                    revisionStart = Revision.HEAD;
                }
                client.doLog(SVNURL.parseURIEncoded(path), new String[]{""}, JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revisionStart), JavaHLObjectFactory.getSVNRevision(revisionEnd), stopOnCopy, discoverPath, includeMergeInfo, limit, revisionProperties, logEntryHandler);
            } else {
                if (revisionStart == null) {
                    revisionStart = Revision.BASE;
                }
                client.doLog(new File[]{new File(path).getAbsoluteFile()}, JavaHLObjectFactory.getSVNRevision(revisionStart), JavaHLObjectFactory.getSVNRevision(revisionEnd), JavaHLObjectFactory.getSVNRevision(pegRevision), stopOnCopy, discoverPath, includeMergeInfo, limit, revisionProperties, logEntryHandler);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void notification(Notify notify) {
        this.myNotify = notify;
    }

    public void notification2(Notify2 notify) {
        this.myNotify2 = notify;
    }

    public void setProgressListener(ProgressListener listener) {
        this.getDebugLog();
        if (listener != null) {
            this.myProgressListener = new JavaHLProgressLog(listener);
            this.myDebugLog.addLogger(this.myProgressListener);
        } else if (this.myProgressListener != null) {
            this.myDebugLog.removeLogger(this.myProgressListener);
            this.myProgressListener = null;
        }
    }

    private void resetLog() {
        if (this.myProgressListener != null) {
            this.myProgressListener.reset();
        }
    }

    public void commitMessageHandler(CommitMessage messageHandler) {
        this.myMessageHandler = messageHandler;
    }

    public void setConflictResolver(ConflictResolverCallback listener) {
        this.myConflictResolverCallback = listener;
        this.mySVNConflictHandler = null;
        this.updateClientManager();
    }

    public void remove(String[] path, String message, boolean force) throws ClientException {
        this.remove(path, message, force, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String[] path, String message, boolean force, boolean keepLocal, Map revprops) throws ClientException {
        boolean areURLs = false;
        for (int i = 0; i < path.length; ++i) {
            areURLs = areURLs || SVNClientImpl.isURL(path[i]);
        }
        if (areURLs) {
            SVNCommitClient client = this.getSVNCommitClient();
            SVNURL[] urls = new SVNURL[path.length];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    urls[i] = SVNURL.parseURIEncoded(path[i]);
                    continue;
                }
                catch (SVNException e) {
                    this.throwException(e);
                }
            }
            try {
                try {
                    SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
                    client.setCommitHandler(this.createCommitMessageHandler(true));
                    client.doDelete(urls, message, revisionProperties);
                }
                catch (SVNException e) {
                    this.throwException(e);
                    Object var12_18 = null;
                    if (client != null) {
                        client.setCommitHandler(null);
                    }
                    this.resetLog();
                }
                Object var12_17 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
                throw throwable;
            }
        } else {
            SVNWCClient client = this.getSVNWCClient();
            for (int i = 0; i < path.length; ++i) {
                try {
                    client.doDelete(new File(path[i]).getAbsoluteFile(), force, !keepLocal, false);
                    continue;
                }
                catch (SVNException e) {
                    this.throwException(e);
                    continue;
                }
                finally {
                    this.resetLog();
                }
            }
        }
    }

    public void revert(String path, boolean recurse) throws ClientException {
        this.revert(path, JavaHLObjectFactory.infinityOrEmpty(recurse), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(String path, int depth, String[] changelists) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            client.doRevert(new File[]{new File(path).getAbsoluteFile()}, JavaHLObjectFactory.getSVNDepth(depth), JavaHLObjectFactory.getChangeListsCollection(changelists));
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void add(String path, boolean recurse) throws ClientException {
        this.add(path, recurse, false);
    }

    public void add(String path, boolean recurse, boolean force) throws ClientException {
        this.add(path, JavaHLObjectFactory.infinityOrEmpty(recurse), force, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String path, int depth, boolean force, boolean noIgnores, boolean addParents) throws ClientException {
        SVNWCClient wcClient = this.getSVNWCClient();
        try {
            wcClient.doAdd(new File(path).getAbsoluteFile(), force, false, false, JavaHLObjectFactory.getSVNDepth(depth), noIgnores, addParents);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public long update(String path, Revision revision, boolean recurse) throws ClientException {
        long[] updated = this.update(new String[]{path}, revision, recurse, false);
        if (updated != null && updated.length > 0) {
            return updated[0];
        }
        return -1L;
    }

    public long[] update(String[] path, Revision revision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.update(path, revision, JavaHLObjectFactory.unknownOrFiles(recurse), false, ignoreExternals, false);
    }

    public long update(String path, Revision revision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        long[] updated = this.update(new String[]{path}, revision, depth, depthIsSticky, ignoreExternals, allowUnverObstructions);
        if (updated != null && updated.length > 0) {
            return updated[0];
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] update(String[] path, Revision revision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        if (path == null) return new long[0];
        if (path.length == 0) {
            return new long[0];
        }
        long[] updated = new long[path.length];
        SVNUpdateClient updater = this.getSVNUpdateClient();
        boolean oldIgnore = updater.isIgnoreExternals();
        updater.setIgnoreExternals(ignoreExternals);
        updater.setEventPathPrefix("");
        SVNDepth svnDepth = JavaHLObjectFactory.getSVNDepth(depth);
        SVNRevision rev = JavaHLObjectFactory.getSVNRevision(revision);
        try {
            try {
                for (int i = 0; i < updated.length; ++i) {
                    updated[i] = updater.doUpdate(new File(path[i]).getAbsoluteFile(), rev, svnDepth, allowUnverObstructions, depthIsSticky);
                }
                Object var14_14 = null;
            }
            catch (SVNException e) {
                this.throwException(e);
                Object var14_15 = null;
                updater.setIgnoreExternals(oldIgnore);
                updater.setEventPathPrefix(null);
                this.resetLog();
                SVNFileUtil.sleepForTimestamp();
                return updated;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            updater.setIgnoreExternals(oldIgnore);
            updater.setEventPathPrefix(null);
            this.resetLog();
            SVNFileUtil.sleepForTimestamp();
            throw throwable;
        }
        updater.setIgnoreExternals(oldIgnore);
        updater.setEventPathPrefix(null);
        this.resetLog();
        SVNFileUtil.sleepForTimestamp();
        return updated;
    }

    public long commit(String[] path, String message, boolean recurse) throws ClientException {
        return this.commit(path, message, recurse, false);
    }

    public long commit(String[] path, String message, boolean recurse, boolean noUnlock) throws ClientException {
        return this.commit(path, message, JavaHLObjectFactory.infinityOrEmpty(recurse), noUnlock, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(String[] path, String message, int depth, boolean noUnlock, boolean keepChangelist, String[] changelists, Map revprops) throws ClientException {
        if (path == null || path.length == 0) {
            return 0L;
        }
        SVNCommitClient client = this.getSVNCommitClient();
        File[] files = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            files[i] = new File(path[i]).getAbsoluteFile();
        }
        try {
            client.setCommitHandler(this.createCommitMessageHandler(false, false));
            SVNDepth svnDepth = SVNDepth.fromID(depth);
            boolean recurse = SVNDepth.recurseFromDepth(svnDepth);
            SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
            long l = client.doCommit(files, noUnlock, message, revisionProperties, changelists, keepChangelist, !recurse, svnDepth).getNewRevision();
            Object var16_16 = null;
            if (client != null) {
                client.setCommitHandler(null);
            }
            this.resetLog();
            return l;
        }
        catch (SVNException e) {
            try {
                this.throwException(e);
                Object var16_17 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
                throw throwable;
            }
        }
        return -1L;
    }

    public long[] commit(String[] path, String message, boolean recurse, boolean noUnlock, boolean atomicCommit) throws ClientException {
        return this.commit(path, message, JavaHLObjectFactory.infinityOrEmpty(recurse), noUnlock, false, null, null, atomicCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] commit(String[] path, String message, int depth, boolean noUnlock, boolean keepChangelist, String[] changlelists, Map revprops, boolean atomicCommit) throws ClientException {
        if (path == null || path.length == 0) {
            return new long[0];
        }
        SVNCommitClient client = this.getSVNCommitClient();
        File[] files = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            files[i] = new File(path[i]).getAbsoluteFile();
        }
        SVNCommitPacket[] packets = null;
        SVNCommitInfo[] commitResults = null;
        try {
            Object var16_17;
            try {
                client.setCommitHandler(this.createCommitMessageHandler(false));
                SVNDepth svnDepth = SVNDepth.fromID(depth);
                boolean recurse = SVNDepth.recurseFromDepth(svnDepth);
                packets = client.doCollectCommitItems(files, noUnlock, !recurse, svnDepth, atomicCommit, changlelists);
                commitResults = client.doCommit(packets, noUnlock, keepChangelist, message, revprops != null ? SVNProperties.wrap(revprops) : null);
            }
            catch (SVNException e) {
                this.throwException(e);
                var16_17 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
            }
            var16_17 = null;
            if (client != null) {
                client.setCommitHandler(null);
            }
            this.resetLog();
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (client != null) {
                client.setCommitHandler(null);
            }
            this.resetLog();
            throw throwable;
        }
        if (commitResults != null && commitResults.length > 0) {
            long[] revisions = new long[commitResults.length];
            for (int i = 0; i < commitResults.length; ++i) {
                SVNCommitInfo result = commitResults[i];
                revisions[i] = result.getNewRevision();
            }
            return revisions;
        }
        return new long[0];
    }

    public void copy(String srcPath, String destPath, String message, Revision revision) throws ClientException {
        this.copy(new CopySource[]{new CopySource(srcPath, revision, null)}, destPath, message, true, false, null);
    }

    public void copy(CopySource[] sources, String destPath, String message, boolean copyAsChild, boolean makeParents, Map revprops) throws ClientException {
        SVNCopySource[] copySources = this.getCopySources(sources, copyAsChild);
        this.copyOrMove(copySources, destPath, false, message, copyAsChild, makeParents, revprops);
    }

    public void move(String srcPath, String destPath, String message, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public void move(String srcPath, String destPath, String message, Revision revision, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public void move(String[] srcPaths, String destPath, String message, boolean force, boolean moveAsChild, boolean makeParents, Map revprops) throws ClientException {
        SVNCopySource[] copySources = this.getCopySources(srcPaths, moveAsChild);
        this.copyOrMove(copySources, destPath, true, message, moveAsChild, makeParents, revprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCopySource[] getCopySources(CopySource[] srcs, boolean copyAsChild) throws ClientException {
        if (srcs.length > 1 && !copyAsChild) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNException ex = new SVNException(err);
            this.throwException(ex);
        }
        SVNCopySource[] sources = new SVNCopySource[srcs.length];
        try {
            for (int i = 0; i < srcs.length; ++i) {
                sources[i] = SVNClientImpl.isURL(srcs[i].getPath()) ? new SVNCopySource(JavaHLObjectFactory.getSVNRevision(srcs[i].getPegRevision()), JavaHLObjectFactory.getSVNRevision(srcs[i].getRevision()), SVNURL.parseURIEncoded(srcs[i].getPath())) : new SVNCopySource(JavaHLObjectFactory.getSVNRevision(srcs[i].getPegRevision()), JavaHLObjectFactory.getSVNRevision(srcs[i].getRevision()), new File(srcs[i].getPath()).getAbsoluteFile());
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCopySource[] getCopySources(String[] srcPaths, boolean copyAsChild) throws ClientException {
        if (srcPaths.length > 1 && !copyAsChild) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNException ex = new SVNException(err);
            this.throwException(ex);
        }
        SVNCopySource[] sources = new SVNCopySource[srcPaths.length];
        try {
            for (int i = 0; i < srcPaths.length; ++i) {
                sources[i] = SVNClientImpl.isURL(srcPaths[i]) ? new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.HEAD, SVNURL.parseURIEncoded(srcPaths[i])) : new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.HEAD, new File(srcPaths[i]).getAbsoluteFile());
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOrMove(SVNCopySource[] sources, String destPath, boolean isMove, String message, boolean copyAsChild, boolean makeParents, Map revprops) throws ClientException {
        SVNCopyClient client = this.getSVNCopyClient();
        try {
            block8: {
                try {
                    if (SVNClientImpl.isURL(destPath)) {
                        SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
                        boolean isURLs = sources.length > 0 && sources[0].isURL();
                        client.setCommitHandler(this.createCommitMessageHandler(isURLs));
                        client.doCopy(sources, SVNURL.parseURIEncoded(destPath), isMove, makeParents, !copyAsChild, message, revisionProperties);
                        break block8;
                    }
                    client.doCopy(sources, new File(destPath).getAbsoluteFile(), isMove, makeParents, !copyAsChild);
                }
                catch (SVNException e) {
                    this.throwException(e);
                    Object var12_13 = null;
                    if (client != null) {
                        client.setCommitHandler(null);
                    }
                    this.resetLog();
                }
            }
            Object var12_12 = null;
            if (client != null) {
                client.setCommitHandler(null);
            }
            this.resetLog();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (client != null) {
                client.setCommitHandler(null);
            }
            this.resetLog();
            throw throwable;
        }
    }

    public void mkdir(String[] path, String message) throws ClientException {
        this.mkdir(path, message, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(String[] path, String message, boolean makeParents, Map revprops) throws ClientException {
        SVNCommitClient client = this.getSVNCommitClient();
        ArrayList<SVNURL> urls = new ArrayList<SVNURL>();
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < path.length; ++i) {
            if (SVNClientImpl.isURL(path[i])) {
                try {
                    urls.add(SVNURL.parseURIEncoded(path[i]));
                }
                catch (SVNException e) {
                    this.throwException(e);
                }
                continue;
            }
            paths.add(new File(path[i]));
        }
        SVNURL[] svnURLs = urls.toArray(new SVNURL[urls.size()]);
        File[] files = paths.toArray(new File[paths.size()]);
        if (svnURLs.length > 0) {
            try {
                Object var12_15;
                try {
                    SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
                    client.setCommitHandler(this.createCommitMessageHandler(true, true));
                    client.doMkDir(svnURLs, message, revisionProperties, makeParents);
                }
                catch (SVNException e) {
                    this.throwException(e);
                    var12_15 = null;
                    if (client != null) {
                        client.setCommitHandler(null);
                    }
                }
                var12_15 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                throw throwable;
            }
        }
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                try {
                    this.getSVNWCClient().doAdd(file, false, true, false, SVNDepth.EMPTY, false, false);
                    continue;
                }
                catch (SVNException e) {
                    this.throwException(e);
                    continue;
                }
                finally {
                    this.resetLog();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(String path) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            client.doCleanup(new File(path).getAbsoluteFile());
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void resolved(String path, boolean recurse) throws ClientException {
        this.resolve(path, JavaHLObjectFactory.infinityOrEmpty(recurse), 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(String path, int depth, int conflictResult) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            client.doResolve(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), JavaHLObjectFactory.getSVNConflictChoice(conflictResult));
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public long doExport(String srcPath, String destPath, Revision revision, boolean force) throws ClientException {
        return this.doExport(srcPath, destPath, revision, revision, force, false, true, null);
    }

    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL) throws ClientException {
        return this.doExport(srcPath, destPath, revision, pegRevision, force, ignoreExternals, JavaHLObjectFactory.infinityOrFiles(recurse), nativeEOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, int depth, String nativeEOL) throws ClientException {
        SVNUpdateClient updater = this.getSVNUpdateClient();
        boolean oldIgnore = updater.isIgnoreExternals();
        updater.setIgnoreExternals(ignoreExternals);
        try {
            if (SVNClientImpl.isURL(srcPath)) {
                long l = updater.doExport(SVNURL.parseURIEncoded(srcPath), new File(destPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), nativeEOL, force, JavaHLObjectFactory.getSVNDepth(depth));
                return l;
            }
            long l = updater.doExport(new File(srcPath).getAbsoluteFile(), new File(destPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), nativeEOL, force, JavaHLObjectFactory.getSVNDepth(depth));
            return l;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            updater.setIgnoreExternals(oldIgnore);
            this.resetLog();
        }
        return -1L;
    }

    public void doImport(String path, String url, String message, boolean recurse) throws ClientException {
        this.doImport(path, url, message, JavaHLObjectFactory.infinityOrFiles(recurse), false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(String path, String url, String message, int depth, boolean noIgnore, boolean ignoreUnknownNodeTypes, Map revprops) throws ClientException {
        SVNCommitClient commitClient = this.getSVNCommitClient();
        try {
            try {
                commitClient.setCommitHandler(this.createCommitMessageHandler(false, true));
                SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
                commitClient.doImport(new File(path), SVNURL.parseURIEncoded(url), message, revisionProperties, !noIgnore, ignoreUnknownNodeTypes, JavaHLObjectFactory.getSVNDepth(depth));
            }
            catch (SVNException e) {
                this.throwException(e);
                Object var11_12 = null;
                if (commitClient != null) {
                    commitClient.setCommitHandler(null);
                }
                this.resetLog();
            }
            Object var11_11 = null;
            if (commitClient != null) {
                commitClient.setCommitHandler(null);
            }
            this.resetLog();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (commitClient != null) {
                commitClient.setCommitHandler(null);
            }
            this.resetLog();
            throw throwable;
        }
    }

    public void merge(String path, Revision pegRevision, RevisionRange[] revisions, String localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        ArrayList<SVNRevisionRange> rangesToMerge = new ArrayList<SVNRevisionRange>(revisions.length);
        for (int i = 0; i < revisions.length; ++i) {
            if (revisions[i].getFromRevision().getKind() == 0 && revisions[i].getToRevision().getKind() == 0) {
                SVNRevisionRange range = new SVNRevisionRange(SVNRevision.create(1L), SVNRevision.HEAD);
                rangesToMerge.add(range);
                continue;
            }
            rangesToMerge.add(JavaHLObjectFactory.getSVNRevisionRange(revisions[i]));
        }
        this.merge(path, pegRevision, rangesToMerge, localPath, force, depth, ignoreAncestry, dryRun, recordOnly);
    }

    public void merge(String path, Revision pegRevision, Revision revision1, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        LinkedList<SVNRevisionRange> rangesToMerge = new LinkedList<SVNRevisionRange>();
        rangesToMerge.add(new SVNRevisionRange(JavaHLObjectFactory.getSVNRevision(revision1), JavaHLObjectFactory.getSVNRevision(revision2)));
        this.merge(path, pegRevision, rangesToMerge, localPath, force, JavaHLObjectFactory.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(String path, Revision pegRevision, List rangesToMerge, String localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        try {
            if (SVNClientImpl.isURL(path)) {
                SVNURL url = SVNURL.parseURIEncoded(path);
                differ.doMerge(url, JavaHLObjectFactory.getSVNRevision(pegRevision), (Collection)rangesToMerge, new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            } else {
                differ.doMerge(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), (Collection)rangesToMerge, new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, JavaHLObjectFactory.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        try {
            if (SVNClientImpl.isURL(path1) && SVNClientImpl.isURL(path2)) {
                SVNURL url1 = SVNURL.parseURIEncoded(path1);
                SVNURL url2 = SVNURL.parseURIEncoded(path2);
                differ.doMerge(url1, JavaHLObjectFactory.getSVNRevision(revision1), url2, JavaHLObjectFactory.getSVNRevision(revision2), new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            } else if (SVNClientImpl.isURL(path1)) {
                SVNURL url1 = SVNURL.parseURIEncoded(path1);
                File file2 = new File(path2).getAbsoluteFile();
                differ.doMerge(url1, JavaHLObjectFactory.getSVNRevision(revision1), file2, JavaHLObjectFactory.getSVNRevision(revision2), new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            } else if (SVNClientImpl.isURL(path2)) {
                SVNURL url2 = SVNURL.parseURIEncoded(path2);
                File file1 = new File(path1).getAbsoluteFile();
                differ.doMerge(file1, JavaHLObjectFactory.getSVNRevision(revision1), url2, JavaHLObjectFactory.getSVNRevision(revision2), new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            } else {
                File file1 = new File(path1).getAbsoluteFile();
                File file2 = new File(path2).getAbsoluteFile();
                differ.doMerge(file1, JavaHLObjectFactory.getSVNRevision(revision1), file2, JavaHLObjectFactory.getSVNRevision(revision2), new File(localPath).getAbsoluteFile(), JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, force, dryRun, recordOnly);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeReintegrate(String path, Revision pegRevision, String localPath, boolean dryRun) throws ClientException {
        SVNDiffClient diffClient = this.getSVNDiffClient();
        File dstPath = new File(localPath);
        try {
            if (SVNClientImpl.isURL(path)) {
                SVNURL url = SVNURL.parseURIEncoded(path);
                diffClient.doMergeReIntegrate(url, JavaHLObjectFactory.getSVNRevision(pegRevision), dstPath, dryRun);
            } else {
                File file = new File(path);
                diffClient.doMergeReIntegrate(file, JavaHLObjectFactory.getSVNRevision(pegRevision), dstPath, dryRun);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] suggestMergeSources(String path, Revision pegRevision) throws SubversionException {
        SVNDiffClient client = this.getSVNDiffClient();
        Collection mergeSrcURLs = null;
        try {
            String[] stringURLs;
            if (SVNClientImpl.isURL(path)) {
                SVNURL url = SVNURL.parseURIEncoded(path);
                mergeSrcURLs = client.doSuggestMergeSources(url, JavaHLObjectFactory.getSVNRevision(pegRevision));
            } else {
                mergeSrcURLs = client.doSuggestMergeSources(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision));
            }
            if (mergeSrcURLs != null) {
                stringURLs = new String[mergeSrcURLs.size()];
                int i = 0;
                Iterator urls = mergeSrcURLs.iterator();
                while (urls.hasNext()) {
                    SVNURL mergeSrcURL = (SVNURL)urls.next();
                    stringURLs[i++] = mergeSrcURL.toString();
                }
                String[] stringArray = stringURLs;
                return stringArray;
            }
            stringURLs = null;
            return stringURLs;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mergeinfo getMergeinfo(String path, Revision revision) throws SubversionException {
        SVNDiffClient client = this.getSVNDiffClient();
        Map mergeInfo = null;
        try {
            mergeInfo = SVNClientImpl.isURL(path) ? client.doGetMergedMergeInfo(SVNURL.parseURIEncoded(path), JavaHLObjectFactory.getSVNRevision(revision)) : client.doGetMergedMergeInfo(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(revision));
            Mergeinfo mergeinfo = JavaHLObjectFactory.createMergeInfo(mergeInfo);
            return mergeinfo;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMergeinfoLog(int kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, String[] revprops, final LogMessageCallback callback) throws ClientException {
        SVNDiffClient client = this.getSVNDiffClient();
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                JavaHLObjectFactory.handleLogMessage(logEntry, callback);
            }
        };
        SVNRevision pegRev = JavaHLObjectFactory.getSVNRevision(pegRevision);
        SVNRevision srcPegRev = JavaHLObjectFactory.getSVNRevision(srcPegRevision);
        try {
            SVNURL mergeSrcURL = SVNURL.parseURIEncoded(mergeSourceUrl);
            if (SVNClientImpl.isURL(pathOrUrl)) {
                SVNURL url = SVNURL.parseURIEncoded(pathOrUrl);
                if (kind == 0) {
                    client.doGetLogEligibleMergeInfo(url, pegRev, mergeSrcURL, srcPegRev, discoverChangedPaths, revprops, handler);
                } else if (kind == 1) {
                    client.doGetLogMergedMergeInfo(url, pegRev, mergeSrcURL, srcPegRev, discoverChangedPaths, revprops, handler);
                }
            } else {
                File path = new File(pathOrUrl).getAbsoluteFile();
                if (kind == 0) {
                    client.doGetLogEligibleMergeInfo(path, pegRev, mergeSrcURL, srcPegRev, discoverChangedPaths, revprops, handler);
                } else if (kind == 1) {
                    client.doGetLogMergedMergeInfo(path, pegRev, mergeSrcURL, srcPegRev, discoverChangedPaths, revprops, handler);
                }
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public PropertyData[] properties(String path) throws ClientException {
        return this.properties(path, null);
    }

    public PropertyData[] properties(String path, Revision revision) throws ClientException {
        return this.properties(path, revision, revision);
    }

    public PropertyData[] properties(String path, Revision revision, Revision pegRevision) throws ClientException {
        return this.properties(path, revision, pegRevision, SVNDepth.EMPTY, null);
    }

    public void properties(String path, Revision revision, Revision pegRevision, int depth, String[] changelists, ProplistCallback callback) throws ClientException {
        if (path == null || callback == null) {
            return;
        }
        PropertyData[] properties = this.properties(path, revision, pegRevision, JavaHLObjectFactory.getSVNDepth(depth), changelists);
        SVNHashMap propsMap = new SVNHashMap();
        for (int i = 0; i < properties.length; ++i) {
            propsMap.put(properties[i].getName(), properties[i].getValue());
        }
        callback.singlePath(path, (Map)propsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyData[] properties(String path, Revision revision, Revision pegRevision, SVNDepth depth, String[] changelists) throws ClientException {
        if (path == null) {
            return null;
        }
        SVNWCClient client = this.getSVNWCClient();
        SVNRevision svnRevision = JavaHLObjectFactory.getSVNRevision(revision);
        SVNRevision svnPegRevision = JavaHLObjectFactory.getSVNRevision(pegRevision);
        JavaHLPropertyHandler propHandler = new JavaHLPropertyHandler(this.myOwner);
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doGetProperty(SVNURL.parseURIEncoded(path), null, svnPegRevision, svnRevision, depth, (ISVNPropertyHandler)propHandler);
            } else {
                client.doGetProperty(new File(path).getAbsoluteFile(), null, svnPegRevision, svnRevision, depth, propHandler, JavaHLObjectFactory.getChangeListsCollection(changelists));
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return propHandler.getAllPropertyData();
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, SVNPropertyValue.create(name, value), JavaHLObjectFactory.infinityOrEmpty(recurse), force, null, null);
    }

    public void propertySet(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, JavaHLObjectFactory.infinityOrEmpty(recurse), null, force, null);
    }

    public void propertySet(String path, String name, String value, int depth, String[] changelists, boolean force, Map revprops) throws ClientException {
        this.propertySet(path, name, SVNPropertyValue.create(value), depth, force, changelists, revprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertySet(String path, String name, SVNPropertyValue value, int depth, boolean force, String[] changelists, Map revprops) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        if (SVNClientImpl.isURL(path)) {
            try {
                try {
                    SVNProperties revisionProperties = revprops == null ? null : SVNProperties.wrap(revprops);
                    client.setCommitHandler(this.createCommitMessageHandler(true));
                    client.doSetProperty(SVNURL.parseURIEncoded(path), name, value, SVNRevision.HEAD, "", revisionProperties, force, ISVNPropertyHandler.NULL);
                }
                catch (SVNException e) {
                    this.throwException(e);
                    Object var11_13 = null;
                    if (client != null) {
                        client.setCommitHandler(null);
                    }
                    this.resetLog();
                }
                Object var11_12 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (client != null) {
                    client.setCommitHandler(null);
                }
                this.resetLog();
                throw throwable;
            }
        } else {
            try {
                client.doSetProperty(new File(path).getAbsoluteFile(), name, value, force, JavaHLObjectFactory.getSVNDepth(depth), ISVNPropertyHandler.NULL, JavaHLObjectFactory.getChangeListsCollection(changelists));
            }
            catch (SVNException e) {
                this.throwException(e);
            }
            finally {
                this.resetLog();
            }
        }
    }

    public void propertyRemove(String path, String name, boolean recurse) throws ClientException {
        this.propertyRemove(path, name, JavaHLObjectFactory.infinityOrEmpty(recurse), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyRemove(String path, String name, int depth, String[] changelists) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            client.doSetProperty(new File(path).getAbsoluteFile(), name, null, false, JavaHLObjectFactory.getSVNDepth(depth), ISVNPropertyHandler.NULL, JavaHLObjectFactory.getChangeListsCollection(changelists));
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public PropertyData propertyGet(String path, String name) throws ClientException {
        return this.propertyGet(path, name, null);
    }

    public PropertyData propertyGet(String path, String name, Revision revision) throws ClientException {
        return this.propertyGet(path, name, revision, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyData propertyGet(String path, String name, Revision revision, Revision pegRevision) throws ClientException {
        if (name == null || name.equals("")) {
            return null;
        }
        SVNWCClient client = this.getSVNWCClient();
        SVNRevision svnRevision = JavaHLObjectFactory.getSVNRevision(revision);
        SVNRevision svnPegRevision = JavaHLObjectFactory.getSVNRevision(pegRevision);
        JavaHLPropertyHandler retriever = new JavaHLPropertyHandler(this.myOwner);
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doGetProperty(SVNURL.parseURIEncoded(path), name, svnPegRevision, svnRevision, SVNDepth.EMPTY, (ISVNPropertyHandler)retriever);
            } else {
                client.doGetProperty(new File(path).getAbsoluteFile(), name, svnPegRevision, svnRevision, SVNDepth.EMPTY, retriever, null);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return retriever.getPropertyData();
    }

    public void propertyCreate(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertyCreate(path, name, SVNPropertyValue.create(name, value), JavaHLObjectFactory.infinityOrEmpty(recurse), null, force);
    }

    public void propertyCreate(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, recurse, force);
    }

    public void propertyCreate(String path, String name, String value, int depth, String[] changelists, boolean force) throws ClientException {
        this.propertyCreate(path, name, SVNPropertyValue.create(value), depth, changelists, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertyCreate(String path, String name, SVNPropertyValue value, int depth, String[] changelists, boolean force) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            client.doSetProperty(new File(path).getAbsoluteFile(), name, value, force, JavaHLObjectFactory.getSVNDepth(depth), ISVNPropertyHandler.NULL, JavaHLObjectFactory.getChangeListsCollection(changelists));
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyData revProperty(String path, String name, Revision rev) throws ClientException {
        if (name == null || name.equals("")) {
            return null;
        }
        SVNWCClient client = this.getSVNWCClient();
        SVNRevision svnRevision = JavaHLObjectFactory.getSVNRevision(rev);
        JavaHLPropertyHandler retriever = new JavaHLPropertyHandler(this.myOwner);
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doGetRevisionProperty(SVNURL.parseURIEncoded(path), name, svnRevision, (ISVNPropertyHandler)retriever);
            } else {
                client.doGetRevisionProperty(new File(path).getAbsoluteFile(), name, svnRevision, (ISVNPropertyHandler)retriever);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return retriever.getPropertyData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyData[] revProperties(String path, Revision rev) throws ClientException {
        if (path == null) {
            return null;
        }
        SVNWCClient client = this.getSVNWCClient();
        SVNRevision svnRevision = JavaHLObjectFactory.getSVNRevision(rev);
        JavaHLPropertyHandler propHandler = new JavaHLPropertyHandler(this.myOwner);
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doGetRevisionProperty(SVNURL.parseURIEncoded(path), null, svnRevision, (ISVNPropertyHandler)propHandler);
            } else {
                client.doGetRevisionProperty(new File(path).getAbsoluteFile(), null, svnRevision, (ISVNPropertyHandler)propHandler);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return propHandler.getAllPropertyData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevProperty(String path, String name, Revision rev, String value, boolean force) throws ClientException {
        if (name == null || name.equals("")) {
            return;
        }
        SVNWCClient client = this.getSVNWCClient();
        SVNRevision svnRevision = JavaHLObjectFactory.getSVNRevision(rev);
        SVNPropertyValue propertyValue = SVNPropertyValue.create(value);
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doSetRevisionProperty(SVNURL.parseURIEncoded(path), svnRevision, name, propertyValue, force, ISVNPropertyHandler.NULL);
            } else {
                client.doSetRevisionProperty(new File(path).getAbsoluteFile(), svnRevision, name, propertyValue, force, ISVNPropertyHandler.NULL);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public byte[] fileContent(String path, Revision revision) throws ClientException {
        return this.fileContent(path, revision, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fileContent(String path, Revision revision, Revision pegRevision) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (SVNClientImpl.isURL(path)) {
                client.doGetFileContents(SVNURL.parseURIEncoded(path), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), true, (OutputStream)baos);
            } else {
                client.doGetFileContents(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), true, (OutputStream)baos);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFileContent(String path, Revision revision, Revision pegRevision, int bufferSize, OutputStream stream) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doGetFileContents(SVNURL.parseURIEncoded(path), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), true, stream);
            } else {
                client.doGetFileContents(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), true, stream);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relocate(String from, String to, String path, boolean recurse) throws ClientException {
        SVNUpdateClient client = this.getSVNUpdateClient();
        try {
            client.doRelocate(new File(path).getAbsoluteFile(), SVNURL.parseURIEncoded(from), SVNURL.parseURIEncoded(to), recurse);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public void blame(String path, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
    }

    public byte[] blame(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ISVNAnnotateHandler handler = new ISVNAnnotateHandler(){

            public void handleLine(Date date, long revision, String author, String line) {
                StringBuffer result = new StringBuffer();
                String revStr = revision >= 0L ? SVNFormatUtil.formatString(Long.toString(revision), 6, false) : "     -";
                String authorStr = author != null ? SVNFormatUtil.formatString(author, 10, false) : "         -";
                result.append(revStr);
                result.append(' ');
                result.append(authorStr);
                result.append(' ');
                result.append(line);
                try {
                    baos.write(result.toString().getBytes());
                    baos.write(10);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }

            public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                this.handleLine(mergedDate == null ? date : mergedDate, mergedRevision < 0L ? revision : mergedRevision, mergedAuthor == null ? author : mergedAuthor, line);
            }

            public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
                return false;
            }

            public void handleEOF() {
            }
        };
        this.blame(path, revisionEnd, revisionStart, revisionEnd, false, false, handler);
        return baos.toByteArray();
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        final BlameCallback blameCallback = callback;
        ISVNAnnotateHandler handler = new ISVNAnnotateHandler(){

            public void handleLine(Date date, long revision, String author, String line) {
                if (blameCallback != null) {
                    blameCallback.singleLine(date, revision, author, line);
                }
            }

            public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                this.handleLine(date, revision, author, line);
            }

            public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
                return false;
            }

            public void handleEOF() {
            }
        };
        this.blame(path, pegRevision, revisionStart, revisionEnd, false, false, handler);
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, BlameCallback2 callback) throws ClientException {
        final BlameCallback2 blameCallback = callback;
        ISVNAnnotateHandler handler = new ISVNAnnotateHandler(){

            public void handleLine(Date date, long revision, String author, String line) {
            }

            public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                if (blameCallback != null) {
                    blameCallback.singleLine(date, revision, author, mergedDate, mergedRevision, mergedAuthor, mergedPath, line);
                }
            }

            public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
                return false;
            }

            public void handleEOF() {
            }
        };
        this.blame(path, pegRevision, revisionStart, revisionEnd, ignoreMimeType, includeMergedRevisions, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, ISVNAnnotateHandler handler) throws ClientException {
        SVNLogClient client = this.getSVNLogClient();
        try {
            if (SVNClientImpl.isURL(path)) {
                client.doAnnotate(SVNURL.parseURIEncoded(path), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revisionStart), JavaHLObjectFactory.getSVNRevision(revisionEnd), ignoreMimeType, includeMergedRevisions, handler, null);
            } else {
                client.doAnnotate(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revisionStart), JavaHLObjectFactory.getSVNRevision(revisionEnd), ignoreMimeType, includeMergedRevisions, handler, null);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.myClientManager != null) {
            this.myClientManager.dispose();
            this.myClientManager = null;
        }
        Class clazz = class$org$tmatesoft$svn$core$javahl$SVNClientImpl == null ? (class$org$tmatesoft$svn$core$javahl$SVNClientImpl = SVNClientImpl.class$("org.tmatesoft.svn.core.javahl.SVNClientImpl")) : class$org$tmatesoft$svn$core$javahl$SVNClientImpl;
        synchronized (clazz) {
            if (--ourInstanceCount <= 0) {
                ourInstanceCount = 0;
                SVNSSHSession.shutdown();
            }
        }
    }

    public void setConfigDirectory(String configDir) throws ClientException {
        this.myConfigDir = configDir;
        this.updateClientManager();
    }

    public String getConfigDirectory() throws ClientException {
        return this.myConfigDir;
    }

    public void cancelOperation() throws ClientException {
        this.myCancelOperation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info info(String path) throws ClientException {
        SVNWCClient client = this.getSVNWCClient();
        try {
            if (SVNClientImpl.isURL(path)) {
                Info info = JavaHLObjectFactory.createInfo(client.doInfo(SVNURL.parseURIEncoded(path), SVNRevision.UNDEFINED, SVNRevision.UNDEFINED));
                return info;
            }
            Info info = JavaHLObjectFactory.createInfo(client.doInfo(new File(path).getAbsoluteFile(), SVNRevision.UNDEFINED));
            return info;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE) {
                Info info = null;
                return info;
            }
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String[] path, String comment, boolean force) throws ClientException {
        boolean allFiles = true;
        for (int i = 0; i < path.length; ++i) {
            allFiles = allFiles && !SVNClientImpl.isURL(path[i]);
        }
        try {
            if (allFiles) {
                File[] files = new File[path.length];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = new File(path[i]).getAbsoluteFile();
                }
                this.getSVNWCClient().doLock(files, force, comment);
            } else {
                SVNURL[] urls = new SVNURL[path.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = SVNURL.parseURIEncoded(path[i]);
                }
                this.getSVNWCClient().doLock(urls, force, comment);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String[] path, boolean force) throws ClientException {
        boolean allFiles = true;
        for (int i = 0; i < path.length; ++i) {
            allFiles = allFiles && !SVNClientImpl.isURL(path[i]);
        }
        try {
            if (allFiles) {
                File[] files = new File[path.length];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = new File(path[i]).getAbsoluteFile();
                }
                this.getSVNWCClient().doUnlock(files, force);
            } else {
                SVNURL[] urls = new SVNURL[path.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = SVNURL.parseURIEncoded(path[i]);
                }
                this.getSVNWCClient().doUnlock(urls, force);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersionInfo(String path, String trailUrl, boolean lastChanged) throws ClientException {
        try {
            String string = this.getSVNWCClient().doGetWorkingCopyID(new File(path).getAbsoluteFile(), trailUrl);
            return string;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    public static String version() {
        return Version.getVersionString();
    }

    public static int versionMajor() {
        return Version.getMajorVersion();
    }

    public static int versionMinor() {
        return Version.getMinorVersion();
    }

    public static int versionMicro() {
        return Version.getMicroVersion();
    }

    public static long versionRevisionNumber() {
        return Version.getRevisionNumber();
    }

    public static void enableLogging(int logLevel, String logFilePath) {
        try {
            JavaHLDebugLog.getInstance().enableLogging(logLevel, new File(logFilePath), new DefaultSVNDebugFormatter());
        }
        catch (SVNException e) {
            JavaHLDebugLog.getInstance().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    protected Notify getNotify() {
        return this.myNotify;
    }

    protected Notify2 getNotify2() {
        return this.myNotify2;
    }

    protected ISVNEventHandler getEventListener() {
        if (this.mySVNEventListener == null) {
            this.mySVNEventListener = new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double progress) {
                    if (event.getAction() == SVNEventAction.UPGRADE) {
                        return;
                    }
                    String path = null;
                    if (event.getFile() != null && (path = event.getFile().getAbsolutePath()) != null) {
                        path = path.replace(File.separatorChar, '/');
                    }
                    if (path == null) {
                        path = "";
                    }
                    if (SVNClientImpl.this.myNotify != null && event.getErrorMessage() == null) {
                        SVNClientImpl.this.myNotify.onNotify(path, JavaHLObjectFactory.getNotifyActionValue(event.getAction()), JavaHLObjectFactory.getNodeKind(event.getNodeKind()), event.getMimeType(), JavaHLObjectFactory.getStatusValue(event.getContentsStatus()), JavaHLObjectFactory.getStatusValue(event.getPropertiesStatus()), event.getRevision());
                    }
                    if (SVNClientImpl.this.myNotify2 != null) {
                        NotifyInformation info = JavaHLObjectFactory.createNotifyInformation(event, path);
                        SVNClientImpl.this.myNotify2.onNotify(info);
                    }
                }

                public void checkCancelled() throws SVNCancelException {
                    if (SVNClientImpl.this.myCancelOperation) {
                        SVNClientImpl.this.myCancelOperation = false;
                        SVNErrorManager.cancel("operation cancelled", SVNLogType.DEFAULT);
                    }
                }
            };
        }
        return this.mySVNEventListener;
    }

    protected ISVNConflictHandler getConflictHandler() {
        if (this.mySVNConflictHandler == null && this.myConflictResolverCallback != null) {
            this.mySVNConflictHandler = new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
                    SVNConflictResult result = null;
                    if (SVNClientImpl.this.myConflictResolverCallback != null) {
                        ConflictDescriptor descriptor = JavaHLObjectFactory.createConflictDescription(conflictDescription);
                        try {
                            result = JavaHLObjectFactory.getSVNConflictResult(SVNClientImpl.this.myConflictResolverCallback.resolve(descriptor));
                        }
                        catch (SubversionException e) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.UNKNOWN, e), e, SVNLogType.DEFAULT);
                        }
                    }
                    return result;
                }
            };
        }
        return this.mySVNConflictHandler;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            File configDir = this.myConfigDir == null ? null : new File(this.myConfigDir);
            this.myOptions = SVNWCUtil.createDefaultOptions(configDir, true);
            this.myOptions.setConflictHandler(this.getConflictHandler());
        }
        return this.myOptions;
    }

    protected SVNClientManager getClientManager() {
        if (this.myClientManager == null) {
            this.updateClientManager();
            this.myClientManager = SVNClientManager.newInstance((ISVNOptions)this.myOptions, new DefaultSVNRepositoryPool(this.myAuthenticationManager, this.myOptions));
            this.myClientManager.setDebugLog(this.getDebugLog());
            this.myClientManager.setEventHandler(this.getEventListener());
        }
        return this.myClientManager;
    }

    protected SVNCommitClient getSVNCommitClient() {
        return this.getClientManager().getCommitClient();
    }

    protected SVNUpdateClient getSVNUpdateClient() {
        return this.getClientManager().getUpdateClient();
    }

    protected SVNStatusClient getSVNStatusClient() {
        return this.getClientManager().getStatusClient();
    }

    protected SVNWCClient getSVNWCClient() {
        return this.getClientManager().getWCClient();
    }

    protected SVNDiffClient getSVNDiffClient() {
        return this.getClientManager().getDiffClient();
    }

    protected SVNCopyClient getSVNCopyClient() {
        return this.getClientManager().getCopyClient();
    }

    protected SVNLogClient getSVNLogClient() {
        return this.getClientManager().getLogClient();
    }

    protected SVNChangelistClient getChangelistClient() {
        return this.getClientManager().getChangelistClient();
    }

    protected CommitMessage getCommitMessage() {
        return this.myMessageHandler;
    }

    protected ISVNCommitHandler createCommitMessageHandler(boolean isURLsOnly) {
        return this.createCommitMessageHandler(isURLsOnly, false);
    }

    protected ISVNCommitHandler createCommitMessageHandler(final boolean isURLsOnly, final boolean isImport) {
        if (this.myMessageHandler != null) {
            return new ISVNCommitHandler(){

                public String getCommitMessage(String cmessage, SVNCommitItem[] commitables) {
                    CommitItem[] items = JavaHLObjectFactory.getCommitItems(commitables, isImport, isURLsOnly);
                    return SVNClientImpl.this.myMessageHandler.getLogMessage(items);
                }

                public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
                    return revisionProperties == null ? new SVNProperties() : revisionProperties;
                }
            };
        }
        return null;
    }

    protected void throwException(SVNException e) throws ClientException {
        JavaHLObjectFactory.throwException(e, this);
    }

    protected static boolean isURL(String pathOrUrl) {
        return SVNPathUtil.isURL(pathOrUrl);
    }

    public String getAdminDirectoryName() {
        return SVNFileUtil.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String name) {
        return name != null && SVNFileUtil.isWindows ? SVNFileUtil.getAdminDirectoryName().equalsIgnoreCase(name) : SVNFileUtil.getAdminDirectoryName().equals(name);
    }

    public org.tigris.subversion.javahl.Version getVersion() {
        return SVNClientImplVersion.getInstance();
    }

    public long doSwitch(String path, String url, Revision revision, boolean recurse) throws ClientException {
        return this.doSwitch(path, url, revision, Revision.HEAD, JavaHLObjectFactory.unknownOrFiles(recurse), false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doSwitch(String path, String url, Revision revision, Revision pegRevision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        SVNUpdateClient updater = this.getSVNUpdateClient();
        try {
            long l = updater.doSwitch(new File(path).getAbsoluteFile(), SVNURL.parseURIEncoded(url), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), JavaHLObjectFactory.getSVNDepth(depth), allowUnverObstructions, depthIsSticky);
            return l;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToChangelist(String[] paths, String changelist, int depth, String[] changelists) throws ClientException {
        if (paths == null || paths.length == 0 || changelist == null || "".equals(changelist)) {
            return;
        }
        SVNChangelistClient changelistClient = this.getChangelistClient();
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]).getAbsoluteFile();
        }
        try {
            changelistClient.doAddToChangelist(files, JavaHLObjectFactory.getSVNDepth(depth), changelist, changelists);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromChangelists(String[] paths, int depth, String[] changelists) throws ClientException {
        if (paths == null || paths.length == 0 || changelists == null) {
            return;
        }
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]).getAbsoluteFile();
        }
        SVNChangelistClient changelistClient = this.getChangelistClient();
        try {
            changelistClient.doRemoveFromChangelist(files, JavaHLObjectFactory.getSVNDepth(depth), changelists);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChangelists(String rootPath, String[] changelists, int depth, final ChangelistCallback callback) throws ClientException {
        if (changelists == null) {
            return;
        }
        ISVNChangelistHandler handler = new ISVNChangelistHandler(){

            public void handle(File path, String changelistName) {
                if (callback != null) {
                    String filePath = path.getAbsolutePath().replace(File.separatorChar, '/');
                    callback.doChangelist(filePath, changelistName);
                }
            }
        };
        SVNChangelistClient changelistClient = this.getChangelistClient();
        try {
            changelistClient.doGetChangeLists(new File(rootPath).getAbsoluteFile(), JavaHLObjectFactory.getChangeListsCollection(changelists), JavaHLObjectFactory.getSVNDepth(depth), handler);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    public long checkout(String moduleName, String destPath, Revision revision, boolean recurse) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, recurse, false);
    }

    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.checkout(moduleName, destPath, revision, pegRevision, JavaHLObjectFactory.infinityOrFiles(recurse), ignoreExternals, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, int depth, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        SVNUpdateClient updater = this.getSVNUpdateClient();
        boolean oldIgnoreExternals = updater.isIgnoreExternals();
        updater.setIgnoreExternals(ignoreExternals);
        try {
            File path = new File(destPath).getAbsoluteFile();
            long l = updater.doCheckout(SVNURL.parseURIEncoded(moduleName), path, JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), JavaHLObjectFactory.getSVNDepth(depth), allowUnverObstructions);
            return l;
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            updater.setIgnoreExternals(oldIgnoreExternals);
            this.resetLog();
        }
        return -1L;
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse) throws ClientException {
        this.diff(target1, revision1, target2, revision2, outFileName, recurse, true, false, false);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target1, revision1, target2, revision2, null, outFileName, JavaHLObjectFactory.infinityOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, null, outFileName, JavaHLObjectFactory.unknownOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        differ.getDiffGenerator().setDiffDeleted(!noDiffDeleted);
        differ.getDiffGenerator().setForcedBinaryDiff(force);
        differ.setOptions(this.getOptions());
        SVNRevision rev1 = JavaHLObjectFactory.getSVNRevision(revision1);
        SVNRevision rev2 = JavaHLObjectFactory.getSVNRevision(revision2);
        try {
            differ.getDiffGenerator().setBasePath(SVNClientImpl.getDiffBasePath(relativeToDir));
            OutputStream out = SVNFileUtil.openFileForWriting(new File(outFileName));
            if (!SVNClientImpl.isURL(target1) && !SVNClientImpl.isURL(target2)) {
                differ.doDiff(new File(target1).getAbsoluteFile(), rev1, new File(target2).getAbsoluteFile(), rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out, JavaHLObjectFactory.getChangeListsCollection(changelists));
            } else if (SVNClientImpl.isURL(target1) && SVNClientImpl.isURL(target2)) {
                SVNURL url1 = SVNURL.parseURIEncoded(target1);
                SVNURL url2 = SVNURL.parseURIEncoded(target2);
                differ.doDiff(url1, rev1, url2, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out);
            } else if (!SVNClientImpl.isURL(target1) && SVNClientImpl.isURL(target2)) {
                SVNURL url2 = SVNURL.parseURIEncoded(target2);
                differ.doDiff(new File(target1).getAbsoluteFile(), rev1, url2, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out, JavaHLObjectFactory.getChangeListsCollection(changelists));
            } else if (SVNClientImpl.isURL(target1) && !SVNClientImpl.isURL(target2)) {
                SVNURL url1 = SVNURL.parseURIEncoded(target1);
                differ.doDiff(url1, rev1, new File(target2).getAbsoluteFile(), rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out, JavaHLObjectFactory.getChangeListsCollection(changelists));
            }
            SVNFileUtil.closeFile(out);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        differ.getDiffGenerator().setDiffDeleted(!noDiffDeleted);
        differ.getDiffGenerator().setForcedBinaryDiff(force);
        differ.setOptions(this.getOptions());
        SVNRevision peg = JavaHLObjectFactory.getSVNRevision(pegRevision);
        SVNRevision rev1 = JavaHLObjectFactory.getSVNRevision(startRevision);
        SVNRevision rev2 = JavaHLObjectFactory.getSVNRevision(endRevision);
        try {
            differ.getDiffGenerator().setBasePath(SVNClientImpl.getDiffBasePath(relativeToDir));
            OutputStream out = SVNFileUtil.openFileForWriting(new File(outFileName));
            if (SVNClientImpl.isURL(target)) {
                SVNURL url = SVNURL.parseURIEncoded(target);
                differ.doDiff(url, peg, rev1, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out);
            } else {
                differ.doDiff(new File(target).getAbsoluteFile(), peg, rev1, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, out, JavaHLObjectFactory.getChangeListsCollection(changelists));
            }
            SVNFileUtil.closeFile(out);
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    private static File getDiffBasePath(String relativePath) throws SVNException {
        File file = null;
        if (relativePath != null) {
            if (SVNClientImpl.isURL(relativePath)) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_RELATIVE_PATH, "Relative path ''{0}'' should not be URL", relativePath), SVNLogType.DEFAULT);
            }
            file = new File(relativePath).getAbsoluteFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffSummarize(String target1, Revision revision1, String target2, Revision revision2, int depth, String[] changelists, boolean ignoreAncestry, final DiffSummaryReceiver receiver) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        SVNRevision rev1 = JavaHLObjectFactory.getSVNRevision(revision1);
        SVNRevision rev2 = JavaHLObjectFactory.getSVNRevision(revision2);
        ISVNDiffStatusHandler handler = new ISVNDiffStatusHandler(){

            public void handleDiffStatus(SVNDiffStatus diffStatus) throws SVNException {
                if (receiver != null && diffStatus != null && (diffStatus.isPropertiesModified() || diffStatus.getModificationType() != SVNStatusType.STATUS_NORMAL && diffStatus.getModificationType() != SVNStatusType.STATUS_NONE)) {
                    receiver.onSummary(JavaHLObjectFactory.createDiffSummary(diffStatus));
                }
            }
        };
        try {
            if (!SVNClientImpl.isURL(target1) && !SVNClientImpl.isURL(target2)) {
                differ.doDiffStatus(new File(target1).getAbsoluteFile(), rev1, new File(target2).getAbsoluteFile(), rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            } else if (SVNClientImpl.isURL(target1) && SVNClientImpl.isURL(target2)) {
                SVNURL url1 = SVNURL.parseURIEncoded(target1);
                SVNURL url2 = SVNURL.parseURIEncoded(target2);
                differ.doDiffStatus(url1, rev1, url2, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            } else if (!SVNClientImpl.isURL(target1) && SVNClientImpl.isURL(target2)) {
                SVNURL url2 = SVNURL.parseURIEncoded(target2);
                differ.doDiffStatus(new File(target1).getAbsoluteFile(), rev1, url2, rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            } else if (SVNClientImpl.isURL(target1) && !SVNClientImpl.isURL(target2)) {
                SVNURL url1 = SVNURL.parseURIEncoded(target1);
                differ.doDiffStatus(url1, rev1, new File(target2).getAbsoluteFile(), rev2, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffSummarize(String target, Revision pegRevision, Revision startRevision, Revision endRevision, int depth, String[] changelists, boolean ignoreAncestry, final DiffSummaryReceiver receiver) throws ClientException {
        SVNDiffClient differ = this.getSVNDiffClient();
        SVNRevision rev1 = JavaHLObjectFactory.getSVNRevision(startRevision);
        SVNRevision rev2 = JavaHLObjectFactory.getSVNRevision(endRevision);
        SVNRevision pegRev = JavaHLObjectFactory.getSVNRevision(pegRevision);
        ISVNDiffStatusHandler handler = new ISVNDiffStatusHandler(){

            public void handleDiffStatus(SVNDiffStatus diffStatus) throws SVNException {
                if (diffStatus != null && receiver != null && (diffStatus.isPropertiesModified() || diffStatus.getModificationType() != SVNStatusType.STATUS_NORMAL && diffStatus.getModificationType() != SVNStatusType.STATUS_NONE)) {
                    receiver.onSummary(JavaHLObjectFactory.createDiffSummary(diffStatus));
                }
            }
        };
        try {
            if (!SVNClientImpl.isURL(target)) {
                differ.doDiffStatus(new File(target).getAbsoluteFile(), rev1, rev2, pegRev, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            } else {
                SVNURL url = SVNURL.parseURIEncoded(target);
                differ.doDiffStatus(url, rev1, rev2, pegRev, JavaHLObjectFactory.getSVNDepth(depth), !ignoreAncestry, handler);
            }
        }
        catch (SVNException e) {
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info2[] info2(String pathOrUrl, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        final ArrayList infos = new ArrayList();
        try {
            this.info2(pathOrUrl, revision, pegRevision, JavaHLObjectFactory.infinityOrEmpty(recurse), null, new ISVNInfoHandler(){

                public void handleInfo(SVNInfo info) {
                    infos.add(JavaHLObjectFactory.createInfo2(info));
                }
            });
            Info2[] info2Array = infos.toArray(new Info2[infos.size()]);
            return info2Array;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE) {
                Info2[] info2Array = new Info2[]{};
                return info2Array;
            }
            this.throwException(e);
        }
        finally {
            this.resetLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info2(String pathOrUrl, Revision revision, Revision pegRevision, int depth, String[] changelists, InfoCallback callback) throws ClientException {
        final InfoCallback infoCallback = callback;
        try {
            this.info2(pathOrUrl, revision, pegRevision, depth, changelists, new ISVNInfoHandler(){

                public void handleInfo(SVNInfo info) {
                    if (infoCallback != null) {
                        infoCallback.singleInfo(JavaHLObjectFactory.createInfo2(info));
                    }
                }
            });
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.UNVERSIONED_RESOURCE) {
                this.throwException(e);
            }
        }
        finally {
            this.resetLog();
        }
    }

    private void info2(String pathOrUrl, Revision revision, Revision pegRevision, int depth, String[] changelists, ISVNInfoHandler handler) throws SVNException {
        SVNWCClient client = this.getSVNWCClient();
        if (SVNClientImpl.isURL(pathOrUrl)) {
            client.doInfo(SVNURL.parseURIEncoded(pathOrUrl), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), JavaHLObjectFactory.getSVNDepth(depth), handler);
        } else {
            List<String> changeListsCollection = null;
            if (changelists != null && changelists.length > 0) {
                changeListsCollection = Arrays.asList(changelists);
            }
            client.doInfo(new File(pathOrUrl).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(pegRevision), JavaHLObjectFactory.getSVNRevision(revision), JavaHLObjectFactory.getSVNDepth(depth), changeListsCollection, handler);
        }
    }

    public void logMessages(String path, Revision pegRevision, RevisionRange[] ranges, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, String[] revProps, long limit, LogMessageCallback callback) throws ClientException {
        final LogMessageCallback logMessageCallback = callback;
        for (int i = 0; i < ranges.length; ++i) {
            RevisionRange range = ranges[i];
            this.logMessages(path, pegRevision, range.getFromRevision(), range.getToRevision(), stopOnCopy, discoverPath, includeMergedRevisions, revProps, limit, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) {
                    JavaHLObjectFactory.handleLogMessage(logEntry, logMessageCallback);
                }
            });
        }
    }

    public void setRevProperty(String path, String name, Revision rev, String value, String originalValue, boolean force) throws ClientException {
        this.setRevProperty(path, name, rev, value, force);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class LogLevel
    implements SVNClientLogLevel {
    }
}

