/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.svn.history.MergeSourceDetailsAction;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnMergeSourceDetails;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnHistoryProvider
implements VcsHistoryProvider {
    private final SvnVcs myVcs;
    private SVNURL myURL;
    private SVNRevision myRevision;
    private boolean myDirectory;
    private static final Object MERGE_SOURCE_DETAILS_TAG = new Object();

    public SvnHistoryProvider(SvnVcs vcs) {
        this(vcs, null, null, false);
    }

    public SvnHistoryProvider(@NotNull SvnVcs vcs, SVNURL url, SVNRevision revision, boolean isDirectory) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/history/SvnHistoryProvider.<init> must not be null");
        }
        this.myVcs = vcs;
        this.myURL = url;
        this.myRevision = revision;
        this.myDirectory = isDirectory;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        JPanel addComp;
        Consumer<VcsFileRevision> listener;
        ColumnInfo[] columns;
        if (((MyHistorySession)session).isSupports15()) {
            final MergeSourceColumnInfo mergeSourceColumn = new MergeSourceColumnInfo((MyHistorySession)session);
            columns = new ColumnInfo[]{new CopyFromColumnInfo(), mergeSourceColumn};
            final JTextArea field = new JTextArea();
            field.setEditable(false);
            field.setBackground(UIUtil.getComboBoxDisabledBackground());
            field.setWrapStyleWord(true);
            listener = new Consumer<VcsFileRevision>(){

                public void consume(VcsFileRevision vcsFileRevision) {
                    field.setText(mergeSourceColumn.getText(vcsFileRevision));
                }
            };
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            JLabel mergeLabel = new JLabel("Merge Sources:");
            MergeSourceDetailsAction sourceAction = new MergeSourceDetailsAction();
            sourceAction.registerSelf(forShortcutRegistration);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)sourceAction);
            JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
            panel.add((Component)mergeLabel, gb);
            ++gb.gridx;
            gb.insets.left = 10;
            gb.anchor = 18;
            panel.add((Component)toolbar, gb);
            ++gb.gridy;
            gb.insets.left = 0;
            gb.gridx = 0;
            gb.gridwidth = 2;
            gb.weighty = 1.0;
            gb.weightx = 1.0;
            gb.fill = 1;
            panel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)field), gb);
            addComp = panel;
        } else {
            columns = new ColumnInfo[]{new CopyFromColumnInfo()};
            addComp = null;
            listener = null;
        }
        return new VcsDependentHistoryComponents(columns, listener, addComp);
    }

    @Nullable
    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        FilePath committedPath = ChangesUtil.getCommittedPath((Project)this.myVcs.getProject(), (FilePath)filePath);
        Ref supports15Ref = new Ref();
        ArrayList revisions = new ArrayList();
        this.getRevisionsList(committedPath, (Ref<Boolean>)supports15Ref, (Consumer<VcsFileRevision>)new CollectConsumer(revisions));
        return new MyHistorySession(revisions, committedPath, Boolean.TRUE.equals(supports15Ref.get()));
    }

    public void reportAppendableHistory(FilePath path, final VcsAppendableHistorySessionPartner partner) throws VcsException {
        FilePath committedPath = ChangesUtil.getCommittedPath((Project)this.myVcs.getProject(), (FilePath)path);
        Ref supports15Ref = new Ref();
        final MyHistorySession historySession = new MyHistorySession(Collections.emptyList(), committedPath, Boolean.TRUE.equals(supports15Ref.get()));
        final Ref sessionReported = new Ref();
        this.getRevisionsList(committedPath, (Ref<Boolean>)supports15Ref, new Consumer<VcsFileRevision>(){

            public void consume(VcsFileRevision vcsFileRevision) {
                if (!Boolean.TRUE.equals(sessionReported.get())) {
                    partner.reportCreatedEmptySession((VcsAbstractHistorySession)historySession);
                    sessionReported.set((Object)true);
                }
                partner.acceptRevision(vcsFileRevision);
            }
        });
    }

    @Nullable
    private void getRevisionsList(final FilePath file, final Ref<Boolean> supports15Ref, final Consumer<VcsFileRevision> consumer) throws VcsException {
        final SVNException[] exception = new SVNException[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setText(SvnBundle.message("progress.text2.collecting.history", file.getName()));
                }
                try {
                    if (SvnHistoryProvider.this.myURL == null) {
                        SvnHistoryProvider.this.collectLogEntries(indicator, file, exception, (Consumer<VcsFileRevision>)consumer, (Ref<Boolean>)supports15Ref);
                    } else {
                        SvnHistoryProvider.this.collectLogEntriesForRepository(indicator, (Consumer<VcsFileRevision>)consumer, (Ref<Boolean>)supports15Ref);
                    }
                }
                catch (SVNCancelException ex) {
                    throw new ProcessCanceledException((Throwable)ex);
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
            }
        };
        command.run();
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    private void collectLogEntries(final ProgressIndicator indicator, FilePath file, SVNException[] exception, Consumer<VcsFileRevision> result, Ref<Boolean> supports15Ref) throws SVNException {
        String url;
        SVNWCClient wcClient = this.myVcs.createWCClient();
        SVNInfo info = wcClient.doInfo(new File(file.getIOFile().getAbsolutePath()), SVNRevision.WORKING);
        wcClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                indicator.checkCanceled();
            }
        });
        if (info == null || info.getRepositoryRootURL() == null) {
            exception[0] = new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"File ''{0}'' is not under version control", (Object)file.getIOFile()));
            return;
        }
        String relativeUrl = url = info.getURL() == null ? null : info.getURL().toString();
        SVNURL repoRootURL = info.getRepositoryRootURL();
        String root = repoRootURL.toString();
        if (url != null && url.startsWith(root)) {
            relativeUrl = url.substring(root.length());
        }
        if (indicator != null) {
            indicator.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", url));
        }
        SVNRevision pegRevision = info.getRevision();
        SVNLogClient client = this.myVcs.createLogClient();
        boolean supports15 = SvnUtil.checkRepositoryVersion15(this.myVcs, url);
        supports15Ref.set((Object)supports15);
        client.doLog(new File[]{new File(file.getIOFile().getAbsolutePath())}, SVNRevision.HEAD, SVNRevision.create((long)1L), SVNRevision.UNDEFINED, false, true, supports15, 0L, null, (ISVNLogEntryHandler)new MyLogEntryHandler(url, pegRevision, relativeUrl, result));
    }

    private void collectLogEntriesForRepository(ProgressIndicator indicator, Consumer<VcsFileRevision> result, Ref<Boolean> supports15Ref) throws SVNException {
        String url;
        if (indicator != null) {
            indicator.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", this.myURL.toString()));
        }
        SVNWCClient wcClient = this.myVcs.createWCClient();
        SVNInfo info = wcClient.doInfo(this.myURL, SVNRevision.UNDEFINED, SVNRevision.HEAD);
        String root = info.getRepositoryRootURL().toString();
        String relativeUrl = url = this.myURL.toString();
        if (url.startsWith(root)) {
            relativeUrl = url.substring(root.length());
        }
        SVNLogClient client = this.myVcs.createLogClient();
        boolean supports15 = SvnUtil.checkRepositoryVersion15(this.myVcs, root);
        supports15Ref.set((Object)supports15);
        client.doLog(this.myURL, new String[0], SVNRevision.UNDEFINED, SVNRevision.HEAD, SVNRevision.create((long)1L), false, true, supports15, 0L, null, (ISVNLogEntryHandler)new RepositoryLogEntryHandler(url, SVNRevision.UNDEFINED, relativeUrl, result));
    }

    public String getHelpId() {
        return null;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(FilePath file) {
        if (this.myRevision != null) {
            return new SvnRevisionNumber(this.myRevision);
        }
        try {
            SVNWCClient wcClient = this.myVcs.createWCClient();
            SVNInfo info = wcClient.doInfo(new File(file.getPath()).getAbsoluteFile(), SVNRevision.WORKING);
            if (info != null) {
                return new SvnRevisionNumber(info.getCommittedRevision());
            }
            return null;
        }
        catch (SVNException e) {
            return null;
        }
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{new ShowAllSubmittedFilesAction(), new MergeSourceDetailsAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    private static class CopyFromColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final Icon myIcon = IconLoader.getIcon((String)"/actions/menu-copy.png");
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof String && ((String)value).length() > 0) {
                    this.setIcon(CopyFromColumnInfo.this.myIcon);
                    this.setToolTipText(SvnBundle.message("copy.column.tooltip", value));
                } else {
                    this.setToolTipText("");
                }
            }
        };

        public CopyFromColumnInfo() {
            super(SvnBundle.message("copy.column.title", new Object[0]));
        }

        public String valueOf(VcsFileRevision o) {
            return o instanceof SvnFileRevision ? ((SvnFileRevision)o).getCopyFromPath() : "";
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public String getMaxStringValue() {
            return SvnBundle.message("copy.column.title", new Object[0]);
        }

        public int getAdditionalWidth() {
            return 6;
        }
    }

    private class MergeSourceRenderer
    extends ColoredTableCellRenderer {
        private MergeSourceDetailsLinkListener myListener;
        private final VirtualFile myFile;

        private MergeSourceRenderer(MyHistorySession session) {
            this.myFile = session.getCommittedPath().getVirtualFile();
        }

        public String getText(VcsFileRevision value) {
            if (!(value instanceof SvnFileRevision)) {
                return "";
            }
            SvnFileRevision revision = (SvnFileRevision)value;
            List<SvnFileRevision> mergeSources = revision.getMergeSources();
            if (mergeSources.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (SvnFileRevision source : mergeSources) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(source.getRevisionNumber().asString());
                if (source.getMergeSources().isEmpty()) continue;
                sb.append("*");
            }
            return sb.toString();
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (this.myListener == null) {
                this.myListener = new MergeSourceDetailsLinkListener(MERGE_SOURCE_DETAILS_TAG, this.myFile);
                this.myListener.install(table);
            }
            if (!(value instanceof SvnFileRevision)) {
                this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                return;
            }
            SvnFileRevision revision = (SvnFileRevision)value;
            String text = this.getText(revision);
            if (text.length() == 0) {
                this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                return;
            }
            this.append(this.cutString(text, table.getCellRect(row, column, false).getWidth()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private String cutString(String text, double value) {
            Graphics g;
            FontMetrics m = this.getFontMetrics(this.getFont());
            if (m.getStringBounds(text, g = this.getGraphics()).getWidth() < value) {
                return text;
            }
            String dots = "...";
            double dotsWidth = m.getStringBounds("...", g).getWidth();
            if (dotsWidth >= value) {
                return "...";
            }
            for (int i = 1; i < text.length(); ++i) {
                if (!(m.getStringBounds(text, 0, i, g).getWidth() + dotsWidth >= value)) continue;
                if (i < 2) {
                    return "...";
                }
                return text.substring(0, i - 1) + "...";
            }
            return text;
        }
    }

    private class MergeSourceDetailsLinkListener
    extends TableLinkMouseListener {
        private final VirtualFile myFile;
        private final Object myTag;

        private MergeSourceDetailsLinkListener(Object tag, VirtualFile file) {
            this.myTag = tag;
            this.myFile = file;
        }

        public void mouseClicked(MouseEvent e) {
            SvnFileRevision revision;
            Object tag;
            if (e.getButton() == 1 && !e.isPopupTrigger() && (tag = this.getTagAt(e)) == this.myTag && (revision = this.getSelectedRevision(e)) != null) {
                SvnMergeSourceDetails.showMe(SvnHistoryProvider.this.myVcs.getProject(), revision, this.myFile);
            }
        }

        @Nullable
        private SvnFileRevision getSelectedRevision(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            Object value = table.getModel().getValueAt(row, column);
            if (value instanceof SvnFileRevision) {
                return (SvnFileRevision)value;
            }
            return null;
        }

        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Object tag = this.getTagAt(e);
            if (tag == this.myTag) {
                table.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                table.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class MergeSourceColumnInfo
    extends ColumnInfo<VcsFileRevision, VcsFileRevision> {
        private final MergeSourceRenderer myRenderer;

        private MergeSourceColumnInfo(MyHistorySession session) {
            super("Merge Sources");
            this.myRenderer = new MergeSourceRenderer(session);
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public VcsFileRevision valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision;
        }

        public String getText(VcsFileRevision vcsFileRevision) {
            return this.myRenderer.getText(vcsFileRevision);
        }

        public int getAdditionalWidth() {
            return 20;
        }

        public String getPreferredStringValue() {
            return "1234567, 1234567, 1234567";
        }
    }

    private class RepositoryLogEntryHandler
    extends MyLogEntryHandler {
        public RepositoryLogEntryHandler(String url, SVNRevision pegRevision, String lastPath, Consumer<VcsFileRevision> result) {
            super(url, pegRevision, lastPath, result);
        }

        @Override
        protected SvnFileRevision createRevision(SVNLogEntry logEntry, String copyPath) {
            return new SvnFileRevision(SvnHistoryProvider.this.myVcs, SVNRevision.UNDEFINED, logEntry, SvnHistoryProvider.this.myURL.toString(), copyPath);
        }
    }

    private class MyLogEntryHandler
    implements ISVNLogEntryHandler {
        private final ProgressIndicator myIndicator;
        private String myLastPath;
        protected final Consumer<VcsFileRevision> myResult;
        private VcsFileRevision myPrevious;
        private final SVNRevision myPegRevision;
        private final String myUrl;
        private final SvnMergeSourceTracker myTracker;

        public MyLogEntryHandler(String url, SVNRevision pegRevision, String lastPath, Consumer<VcsFileRevision> result) {
            this.myLastPath = lastPath;
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myResult = result;
            this.myPegRevision = pegRevision;
            this.myUrl = url;
            this.myTracker = new SvnMergeSourceTracker(new ThrowableConsumer<Pair<SVNLogEntry, Integer>, SVNException>(){

                public void consume(Pair<SVNLogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
                    SVNLogEntry logEntry = (SVNLogEntry)svnLogEntryIntegerPair.getFirst();
                    if (MyLogEntryHandler.this.myIndicator != null) {
                        if (MyLogEntryHandler.this.myIndicator.isCanceled()) {
                            SVNErrorManager.cancel((String)SvnBundle.message("exception.text.update.operation.cancelled", new Object[0]), (SVNLogType)SVNLogType.DEFAULT);
                        }
                        MyLogEntryHandler.this.myIndicator.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                    }
                    String copyPath = null;
                    SVNLogEntryPath entryPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(MyLogEntryHandler.this.myLastPath);
                    if (entryPath != null) {
                        copyPath = entryPath.getCopyPath();
                    } else {
                        String path = SVNPathUtil.removeTail((String)MyLogEntryHandler.this.myLastPath);
                        while (path.length() > 0) {
                            entryPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(path);
                            if (entryPath != null) {
                                String relativePath = MyLogEntryHandler.this.myLastPath.substring(entryPath.getPath().length());
                                copyPath = entryPath.getCopyPath() + relativePath;
                                break;
                            }
                            path = SVNPathUtil.removeTail((String)path);
                        }
                    }
                    if (copyPath != null) {
                        MyLogEntryHandler.this.myLastPath = copyPath;
                    }
                    int mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
                    SvnFileRevision revision = MyLogEntryHandler.this.createRevision(logEntry, copyPath);
                    if (mergeLevel >= 0) {
                        MyLogEntryHandler.this.addToListByLevel((SvnFileRevision)MyLogEntryHandler.this.myPrevious, revision, mergeLevel);
                    } else {
                        MyLogEntryHandler.this.myResult.consume((Object)revision);
                        MyLogEntryHandler.this.myPrevious = revision;
                    }
                }
            });
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            this.myTracker.consume(logEntry);
        }

        private void addToListByLevel(SvnFileRevision revision, SvnFileRevision revisionToAdd, int level) {
            if (level < 0) {
                return;
            }
            if (level == 0) {
                revision.addMergeSource(revisionToAdd);
                return;
            }
            List<SvnFileRevision> sources = revision.getMergeSources();
            if (!sources.isEmpty()) {
                this.addToListByLevel(sources.get(sources.size() - 1), revisionToAdd, level - 1);
            }
        }

        protected SvnFileRevision createRevision(SVNLogEntry logEntry, String copyPath) {
            Date date = logEntry.getDate();
            String author = logEntry.getAuthor();
            String message = logEntry.getMessage();
            SVNRevision rev = SVNRevision.create((long)logEntry.getRevision());
            return new SvnFileRevision(SvnHistoryProvider.this.myVcs, this.myPegRevision, rev, this.myUrl, author, date, message, copyPath);
        }
    }

    private class MyHistorySession
    extends VcsAbstractHistorySession {
        private final FilePath myCommittedPath;
        private final Map<Long, SvnChangeList> myListsMap;
        private final boolean mySupports15;

        private MyHistorySession(List<VcsFileRevision> revisions, FilePath committedPath, boolean supports15) {
            super(revisions);
            this.myCommittedPath = committedPath;
            this.mySupports15 = supports15;
            this.myListsMap = new HashMap<Long, SvnChangeList>();
            this.shouldBeRefreshed();
        }

        public Map<Long, SvnChangeList> getListsMap() {
            return this.myListsMap;
        }

        public HistoryAsTreeProvider getHistoryAsTreeProvider() {
            return null;
        }

        @Nullable
        public VcsRevisionNumber calcCurrentRevisionNumber() {
            if (this.myCommittedPath == null) {
                return null;
            }
            return SvnHistoryProvider.this.getCurrentRevision(this.myCommittedPath);
        }

        public FilePath getCommittedPath() {
            return this.myCommittedPath;
        }

        public boolean isContentAvailable(VcsFileRevision revision) {
            return !SvnHistoryProvider.this.myDirectory;
        }

        public boolean isSupports15() {
            return this.mySupports15;
        }
    }
}

