/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class MavenJDOMUtil {
    @Nullable
    public static Element read(final VirtualFile file, final @Nullable ErrorHandler handler) {
        String text = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!file.isValid()) {
                    return null;
                }
                try {
                    return VfsUtil.loadText((VirtualFile)file);
                }
                catch (IOException e) {
                    if (handler != null) {
                        handler.onReadError(e);
                    }
                    return null;
                }
            }
        });
        if (text == null) {
            return null;
        }
        return MavenJDOMUtil.doRead(text, handler);
    }

    @Nullable
    public static Element read(byte[] bytes, @Nullable ErrorHandler handler) {
        return MavenJDOMUtil.doRead(CharsetToolkit.bytesToString((byte[])bytes), handler);
    }

    @Nullable
    private static Element doRead(String text, final ErrorHandler handler) {
        final LinkedList stack = new LinkedList();
        final Element[] result = new Element[]{null};
        XmlBuilderDriver driver = new XmlBuilderDriver((CharSequence)text);
        XmlBuilder builder = new XmlBuilder(){

            public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
            }

            public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                Element parent;
                String name = ((Object)localName).toString();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                Element newElement = new Element(name);
                Element element = parent = stack.isEmpty() ? null : (Element)stack.getLast();
                if (parent == null) {
                    result[0] = newElement;
                } else {
                    parent.addContent(newElement);
                }
                stack.addLast(newElement);
                return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
            }

            public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                String name = ((Object)localName).toString();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                int index = -1;
                for (int i = stack.size() - 1; i >= 0; --i) {
                    if (!((Element)stack.get(i)).getName().equals(name)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return;
                }
                while (stack.size() > index) {
                    stack.removeLast();
                }
            }

            public void textElement(CharSequence text, CharSequence physical, int startoffset, int endoffset) {
                ((Element)stack.getLast()).addContent(JDOMUtil.legalizeText((String)((Object)text).toString()));
            }

            public void attribute(CharSequence name, CharSequence value, int startoffset, int endoffset) {
            }

            public void entityRef(CharSequence ref, int startOffset, int endOffset) {
            }

            public void error(String message, int startOffset, int endOffset) {
                if (handler != null) {
                    handler.onSyntaxError();
                }
            }
        };
        driver.build(builder);
        return result[0];
    }

    public static Element findChildByPath(@Nullable Element element, String path) {
        String each;
        if (element == null) {
            return null;
        }
        List parts = StringUtil.split((String)path, (String)".");
        Element current = element;
        Iterator i$ = parts.iterator();
        while (i$.hasNext() && (current = current.getChild(each = (String)i$.next())) != null) {
        }
        return current;
    }

    public static String findChildValueByPath(@Nullable Element element, String path, String defaultValue) {
        Element child = MavenJDOMUtil.findChildByPath(element, path);
        String childValue = child == null ? null : child.getText();
        return StringUtil.isEmptyOrSpaces((String)childValue) ? defaultValue : childValue;
    }

    public static String findChildValueByPath(@Nullable Element element, String path) {
        return MavenJDOMUtil.findChildValueByPath(element, path, null);
    }

    public static boolean hasChildByPath(@Nullable Element element, String path) {
        return MavenJDOMUtil.findChildByPath(element, path) != null;
    }

    public static List<Element> findChildrenByPath(@Nullable Element element, String path, String subPath) {
        return MavenJDOMUtil.collectChildren(MavenJDOMUtil.findChildByPath(element, path), subPath);
    }

    public static List<String> findChildrenValuesByPath(@Nullable Element element, String path, String childrenName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element each : MavenJDOMUtil.findChildrenByPath(element, path, childrenName)) {
            String value = each.getValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            result.add(value);
        }
        return result;
    }

    private static List<Element> collectChildren(@Nullable Element container, String subPath) {
        if (container == null) {
            return Collections.emptyList();
        }
        List subParts = StringUtil.split((String)subPath, (String)".");
        String childName = (String)subParts.get(0);
        String pathInChild = subParts.size() > 1 ? StringUtil.join(subParts.subList(1, subParts.size()), (String)".") : null;
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element each : container.getChildren(childName)) {
            Element child = pathInChild == null ? each : MavenJDOMUtil.findChildByPath(each, pathInChild);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public static interface ErrorHandler {
        public void onReadError(IOException var1);

        public void onSyntaxError();
    }
}

