/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class AddFileAsMavenProjectAction
extends MavenAction {
    public void actionPerformed(AnActionEvent e) {
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(e);
        manager.addManagedFiles(Collections.singletonList(this.getSelectedFile(e)));
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        VirtualFile file = this.getSelectedFile(e);
        return super.isAvailable(e) && MavenActionUtil.isMavenProjectFile(file) && !this.isExistingProjectFile(e, file);
    }

    @Override
    protected boolean isVisible(AnActionEvent e) {
        return super.isVisible(e) && this.isAvailable(e);
    }

    private boolean isExistingProjectFile(AnActionEvent e, VirtualFile file) {
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(e);
        return manager.findProject(file) != null;
    }

    private VirtualFile getSelectedFile(AnActionEvent e) {
        return (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
    }
}

