/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenUIUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenIgnoredFilesConfigurable
implements SearchableConfigurable {
    private static final char SEPARATOR = ',';
    private final MavenProjectsManager myManager;
    private Collection<String> myOriginallyIgnoredFilesPaths;
    private String myOriginallyIgnoredFilesPatterns;
    private JPanel myMainPanel;
    private ElementsChooser<String> myIgnoredFilesPathsChooser;
    private JTextArea myIgnoredFilesPattersEditor;

    public MavenIgnoredFilesConfigurable(MavenProjectsManager manager) {
        this.myManager = manager;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myIgnoredFilesPathsChooser = new ElementsChooser(true);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        return !MavenUtil.equalAsSets(this.myOriginallyIgnoredFilesPaths, this.myIgnoredFilesPathsChooser.getMarkedElements()) || !this.myOriginallyIgnoredFilesPatterns.equals(this.myIgnoredFilesPattersEditor.getText());
    }

    public void apply() throws ConfigurationException {
        this.myManager.setIgnoredFilesPaths(this.myIgnoredFilesPathsChooser.getMarkedElements());
        this.myManager.setIgnoredFilesPatterns(Strings.tokenize(this.myIgnoredFilesPattersEditor.getText(), " \t\n\r\f,"));
    }

    public void reset() {
        this.myOriginallyIgnoredFilesPaths = this.myManager.getIgnoredFilesPaths();
        this.myOriginallyIgnoredFilesPatterns = Strings.detokenize(this.myManager.getIgnoredFilesPatterns(), ',');
        MavenUIUtil.setElements(this.myIgnoredFilesPathsChooser, MavenUtil.collectPaths(this.myManager.getProjectsFiles()), this.myOriginallyIgnoredFilesPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return FileUtil.comparePaths((String)o1, (String)o2);
            }
        });
        this.myIgnoredFilesPattersEditor.setText(this.myOriginallyIgnoredFilesPatterns);
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message("maven.tab.ignored.files", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.maven.ignored.files";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Path patterns (comma-separated, '*' and '?' wildcards allowed)", 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 40), null));
        this.myIgnoredFilesPattersEditor = jTextArea = new JTextArea();
        jScrollPane.setViewportView(jTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Ignored files", 0, 0, null, null));
        ElementsChooser<String> elementsChooser = this.myIgnoredFilesPathsChooser;
        jPanel3.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

