/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.util.Function;
import com.intellij.util.containers.SoftValueHashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenEmbeddersManager {
    private final MavenGeneralSettings myGeneralSettings;
    private final Map<EmbedderKind, MavenEmbedderWrapper> myPool = new SoftValueHashMap();
    private final Set<MavenEmbedderWrapper> myEmbeddersInUse = new THashSet();
    private final Set<MavenEmbedderWrapper> myEmbeddersToClear = new THashSet();

    public MavenEmbeddersManager(MavenGeneralSettings generalSettings) {
        this.myGeneralSettings = generalSettings;
    }

    public synchronized void reset() {
        this.releasePooledEmbedders(false);
    }

    public synchronized void clearCaches() {
        this.forEachPooled(false, new Function<MavenEmbedderWrapper, Object>(){

            public Object fun(MavenEmbedderWrapper each) {
                each.clearCaches();
                return null;
            }
        });
        this.myEmbeddersToClear.addAll(this.myEmbeddersInUse);
    }

    public synchronized MavenEmbedderWrapper getEmbedder(EmbedderKind kind) {
        MavenEmbedderWrapper result = this.myPool.get((Object)kind);
        if (result == null) {
            result = MavenEmbedderFactory.createEmbedder(this.myGeneralSettings);
            this.myPool.put(kind, result);
        }
        if (this.myEmbeddersInUse.contains(result)) {
            MavenLog.LOG.warn("embedder " + (Object)((Object)kind) + " is already used");
            return MavenEmbedderFactory.createEmbedder(this.myGeneralSettings);
        }
        this.myEmbeddersInUse.add(result);
        return result;
    }

    public synchronized void release(MavenEmbedderWrapper embedder) {
        if (!this.myEmbeddersInUse.contains(embedder)) {
            embedder.release();
            this.myEmbeddersToClear.remove(embedder);
            return;
        }
        this.myEmbeddersInUse.remove(embedder);
        if (this.myEmbeddersToClear.contains(embedder)) {
            embedder.clearCaches();
            this.myEmbeddersToClear.remove(embedder);
        }
    }

    public synchronized void release() {
        if (!this.myEmbeddersInUse.isEmpty()) {
            MavenLog.LOG.warn("embedders should be release first");
        }
        this.releasePooledEmbedders(false);
    }

    public synchronized void releaseForcefullyInTests() {
        this.releasePooledEmbedders(true);
    }

    private synchronized void releasePooledEmbedders(boolean force) {
        this.forEachPooled(force, new Function<MavenEmbedderWrapper, Object>(){

            public Object fun(MavenEmbedderWrapper each) {
                each.release();
                return null;
            }
        });
        this.myPool.clear();
        this.myEmbeddersInUse.clear();
        this.myEmbeddersToClear.clear();
    }

    private void forEachPooled(boolean includeInUse, Function<MavenEmbedderWrapper, ?> func) {
        for (EmbedderKind each : this.myPool.keySet()) {
            MavenEmbedderWrapper embedder = this.myPool.get((Object)each);
            if (embedder == null || !includeInUse && this.myEmbeddersInUse.contains(embedder)) continue;
            func.fun((Object)embedder);
        }
    }

    public static enum EmbedderKind {
        FOR_DEPENDENCIES_RESOLVE,
        FOR_PLUGINS_RESOLVE,
        FOR_FOLDERS_RESOLVE,
        FOR_DOWNLOAD,
        FOR_POST_PROCESSING;

    }
}

