/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.Location;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleTree;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;

public class MavenProjectsNavigatorPanel
extends SimpleToolWindowPanel
implements DataProvider {
    private final Project myProject;
    private final SimpleTree myTree;
    private Map<String, Integer> standardGoalOrder;
    private final Comparator<String> myGoalOrderComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return MavenProjectsNavigatorPanel.this.getStandardGoalOrder(o1) - MavenProjectsNavigatorPanel.this.getStandardGoalOrder(o2);
        }
    };

    public MavenProjectsNavigatorPanel(Project project, SimpleTree tree) {
        super(true, true);
        this.myProject = project;
        this.myTree = tree;
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Maven Navigator Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("Maven.NavigatorActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)tree);
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(new JScrollPane((Component)this.myTree));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = this.getMenuId(MavenProjectsNavigatorPanel.this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class));
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu("", actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private String getMenuId(Collection<? extends MavenProjectsStructure.MavenSimpleNode> nodes) {
                String id = null;
                for (MavenProjectsStructure.MavenSimpleNode mavenSimpleNode : nodes) {
                    String menuId = mavenSimpleNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.mavenProjects";
        }
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.extractVirtualFile();
        }
        if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.extractVirtualFiles();
        }
        if (Location.DATA_KEY.is(dataId)) {
            return this.extractLocation();
        }
        if (PlatformDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        if (MavenDataKeys.MAVEN_GOALS.is(dataId)) {
            return this.extractGoals();
        }
        if (MavenDataKeys.MAVEN_PROFILES.is(dataId)) {
            return this.extractProfiles();
        }
        if (MavenDataKeys.MAVEN_DEPENDENCIES.is(dataId)) {
            return this.extractDependencies();
        }
        return null;
    }

    private VirtualFile extractVirtualFile() {
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            return file;
        }
        MavenProjectsStructure.ProjectNode projectNode = this.getContextProjectNode();
        if (projectNode == null) {
            return null;
        }
        VirtualFile file = projectNode.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    private Object extractVirtualFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return files.isEmpty() ? null : VfsUtil.toVirtualFileArray(files);
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            Navigatable navigatable = each.getNavigatable();
            if (navigatable == null) continue;
            navigatables.add(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[navigatables.size()]);
    }

    private Object extractLocation() {
        VirtualFile file = this.extractVirtualFile();
        List<String> goals = this.extractGoals();
        if (file == null || goals == null) {
            return null;
        }
        return new MavenGoalLocation(this.myProject, file, this.extractGoals());
    }

    private List<String> extractGoals() {
        MavenProjectsStructure.ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode != null) {
            MavenProject project = projectNode.getMavenProject();
            String goal = project.getDefaultGoal();
            if (!StringUtil.isEmptyOrSpaces((String)goal)) {
                return Collections.singletonList(goal);
            }
        } else {
            List<MavenProjectsStructure.GoalNode> nodes = this.getSelectedNodes(MavenProjectsStructure.GoalNode.class);
            if (MavenProjectsStructure.getCommonProjectNode(nodes) == null) {
                return null;
            }
            ArrayList<String> goals = new ArrayList<String>();
            for (MavenProjectsStructure.GoalNode node : nodes) {
                goals.add(node.getGoal());
            }
            Collections.sort(goals, this.myGoalOrderComparator);
            return goals;
        }
        return null;
    }

    private Object extractProfiles() {
        List<MavenProjectsStructure.ProfileNode> nodes = this.getSelectedNodes(MavenProjectsStructure.ProfileNode.class);
        ArrayList<String> profiles = new ArrayList<String>();
        for (MavenProjectsStructure.ProfileNode node : nodes) {
            profiles.add(node.getProfileName());
        }
        return profiles;
    }

    private Set<MavenArtifact> extractDependencies() {
        THashSet result = new THashSet();
        List<MavenProjectsStructure.ProjectNode> projectNodes = this.getSelectedProjectNodes();
        if (!projectNodes.isEmpty()) {
            for (MavenProjectsStructure.ProjectNode each : projectNodes) {
                result.addAll(each.getMavenProject().getDependencies());
            }
            return result;
        }
        List<MavenProjectsStructure.BaseDependenciesNode> nodes = this.getSelectedNodes(MavenProjectsStructure.BaseDependenciesNode.class);
        for (MavenProjectsStructure.BaseDependenciesNode each : nodes) {
            if (each instanceof MavenProjectsStructure.DependenciesNode) {
                result.addAll(each.getMavenProject().getDependencies());
                continue;
            }
            result.add(((MavenProjectsStructure.DependencyNode)each).getArtifact());
        }
        return result;
    }

    private <T extends MavenProjectsStructure.MavenSimpleNode> List<T> getSelectedNodes(Class<T> aClass) {
        return MavenProjectsStructure.getSelectedNodes(this.myTree, aClass);
    }

    private List<MavenProjectsStructure.ProjectNode> getSelectedProjectNodes() {
        return this.getSelectedNodes(MavenProjectsStructure.ProjectNode.class);
    }

    @Nullable
    private MavenProjectsStructure.ProjectNode getSelectedProjectNode() {
        List<MavenProjectsStructure.ProjectNode> projectNodes = this.getSelectedProjectNodes();
        return projectNodes.size() == 1 ? projectNodes.get(0) : null;
    }

    @Nullable
    private MavenProjectsStructure.ProjectNode getContextProjectNode() {
        MavenProjectsStructure.ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode != null) {
            return projectNode;
        }
        return MavenProjectsStructure.getCommonProjectNode(this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class));
    }

    private int getStandardGoalOrder(String goal) {
        Integer order;
        if (this.standardGoalOrder == null) {
            this.standardGoalOrder = new THashMap();
            int i = 0;
            for (String aGoal : MavenEmbedderFactory.getPhasesList()) {
                this.standardGoalOrder.put(aGoal, i++);
            }
        }
        return (order = this.standardGoalOrder.get(goal)) != null ? order.intValue() : this.standardGoalOrder.size();
    }
}

