/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.impl.OptionsConfigurabe;

public final class EditExternalyAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        VirtualFile[] files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        Options options = OptionsManager.getInstance().getOptions();
        String executablePath = options.getExternalEditorOptions().getExecutablePath();
        if (StringUtil.isEmpty((String)executablePath)) {
            Messages.showErrorDialog((Project)project, (String)ImagesBundle.message("error.empty.external.editor.path", new Object[0]), (String)ImagesBundle.message("error.title.empty.external.editor.path", new Object[0]));
            OptionsConfigurabe.show(project);
        } else if (files != null) {
            Map env = EnvironmentUtil.getEnviromentProperties();
            Set varNames = env.keySet();
            for (String varName : varNames) {
                if (SystemInfo.isWindows) {
                    executablePath = StringUtil.replace((String)executablePath, (String)("%" + varName + "%"), (String)((String)env.get(varName)), (boolean)true);
                    continue;
                }
                executablePath = StringUtil.replace((String)executablePath, (String)("${" + varName + "}"), (String)((String)env.get(varName)), (boolean)false);
            }
            File executable = new File(executablePath = FileUtil.toSystemDependentName((String)executablePath));
            StringBuffer commandLine = new StringBuffer(executable.exists() ? executable.getAbsolutePath() : executablePath);
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            for (VirtualFile file : files) {
                if (!file.isInLocalFileSystem() || !typeManager.isImage(file)) continue;
                commandLine.append(" \"");
                commandLine.append(VfsUtil.virtualToIoFile((VirtualFile)file).getAbsolutePath());
                commandLine.append('\"');
            }
            try {
                File executableFile = new File(executablePath);
                Runtime.getRuntime().exec(commandLine.toString(), null, executableFile.getParentFile());
            }
            catch (IOException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                OptionsConfigurabe.show(project);
            }
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        VirtualFile[] files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        boolean isEnabled = EditExternalyAction.isImages(files);
        if (e.getPlace().equals("ProjectViewPopup")) {
            e.getPresentation().setVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private static boolean isImages(VirtualFile[] files) {
        boolean isImagesFound = false;
        if (files != null) {
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            for (VirtualFile file : files) {
                boolean isImage = typeManager.isImage(file);
                isImagesFound |= isImage;
                if (file.isInLocalFileSystem() && isImage) continue;
                return false;
            }
        }
        return isImagesFound;
    }
}

