/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.AbstractBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointsPanel;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointPanelProvider
extends BreakpointPanelProvider<XBreakpoint> {
    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @Nullable
    public XBreakpoint<?> findBreakpoint(@NotNull Project project, @NotNull Document document, int offset) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPanelProvider.findBreakpoint must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPanelProvider.findBreakpoint must not be null");
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        int line = document.getLineNumber(offset);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return null;
        }
        for (XLineBreakpointType type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file, line);
            if (breakpoint == null) continue;
            return breakpoint;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<AbstractBreakpointPanel<XBreakpoint>> getBreakpointPanels(@NotNull Project project, @NotNull DialogWrapper parentDialog) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPanelProvider.getBreakpointPanels must not be null");
        }
        if (parentDialog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPanelProvider.getBreakpointPanels must not be null");
        }
        XBreakpointType<?, ?>[] types = XBreakpointUtil.getBreakpointTypes();
        ArrayList<AbstractBreakpointPanel<XBreakpoint>> panels = new ArrayList<AbstractBreakpointPanel<XBreakpoint>>();
        for (XBreakpointType<?, ?> type : types) {
            XBreakpointsPanel<?> panel = XBreakpointPanelProvider.createBreakpointsPanel(project, parentDialog, type);
            panels.add(panel);
        }
        ArrayList<AbstractBreakpointPanel<XBreakpoint>> arrayList = panels;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPanelProvider.getBreakpointPanels must not return null");
        }
        return arrayList;
    }

    private static <B extends XBreakpoint<?>> XBreakpointsPanel<B> createBreakpointsPanel(Project project, DialogWrapper parentDialog, XBreakpointType<B, ?> type) {
        return new XBreakpointsPanel<B>(project, parentDialog, type);
    }

    @Override
    public void onDialogClosed(Project project) {
    }
}

