/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionImpl
implements XDebugSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebugSessionImpl");
    private XDebugProcess myDebugProcess;
    private final Map<XBreakpoint<?>, CustomizedBreakpointPresentation> myRegisteredBreakpoints;
    private final Set<XBreakpoint<?>> myDisabledSlaveBreakpoints;
    private boolean myBreakpointsMuted;
    private boolean myBreakpointsDisabled;
    private final XDebuggerManagerImpl myDebuggerManager;
    private MyBreakpointListener myBreakpointListener;
    private XSuspendContext mySuspendContext;
    private XStackFrame myCurrentStackFrame;
    private XSourcePosition myCurrentPosition;
    private boolean myPaused;
    private MyDependentBreakpointListener myDependentBreakpointListener;
    private String mySessionName;
    private XDebugSessionTab mySessionTab;
    private final EventDispatcher<XDebugSessionListener> myDispatcher;
    private Project myProject;
    @Nullable
    private ExecutionEnvironment myEnvironment;
    private ProgramRunner myRunner;
    private boolean myStopped;
    private boolean myPauseActionSupported;

    public XDebugSessionImpl(@NotNull ExecutionEnvironment env, @NotNull ProgramRunner runner, XDebuggerManagerImpl debuggerManager) {
        if (env == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.<init> must not be null");
        }
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.<init> must not be null");
        }
        this(env, runner, debuggerManager, env.getRunProfile().getName());
    }

    public XDebugSessionImpl(@Nullable ExecutionEnvironment env, @Nullable ProgramRunner runner, XDebuggerManagerImpl debuggerManager, @NotNull String sessionName) {
        if (sessionName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.<init> must not be null");
        }
        this.myRegisteredBreakpoints = new HashMap();
        this.myDisabledSlaveBreakpoints = new HashSet();
        this.myDispatcher = EventDispatcher.create(XDebugSessionListener.class);
        this.myEnvironment = env;
        this.myRunner = runner;
        this.mySessionName = sessionName;
        this.myDebuggerManager = debuggerManager;
        this.myProject = debuggerManager.getProject();
    }

    @NotNull
    public String getSessionName() {
        String string = this.mySessionName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebugSessionImpl.getSessionName must not return null");
        }
        return string;
    }

    @NotNull
    public RunContentDescriptor getRunContentDescriptor() {
        LOG.assertTrue(this.mySessionTab != null, (Object)"Call init() first!");
        RunContentDescriptor runContentDescriptor = this.mySessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebugSessionImpl.getRunContentDescriptor must not return null");
        }
        return runContentDescriptor;
    }

    public void setPauseActionSupported(boolean isSupported) {
        this.myPauseActionSupported = isSupported;
    }

    public void rebuildViews() {
        this.mySessionTab.rebuildViews();
    }

    @Nullable
    public RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public boolean isPauseActionSupported() {
        return this.myPauseActionSupported;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDebuggerManager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebugSessionImpl.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public XDebugProcess getDebugProcess() {
        XDebugProcess xDebugProcess = this.myDebugProcess;
        if (xDebugProcess == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebugSessionImpl.getDebugProcess must not return null");
        }
        return xDebugProcess;
    }

    public boolean isSuspended() {
        return this.myPaused && this.mySuspendContext != null;
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    @Nullable
    public XStackFrame getCurrentStackFrame() {
        return this.myCurrentStackFrame;
    }

    public XSuspendContext getSuspendContext() {
        return this.mySuspendContext;
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        return this.myCurrentPosition;
    }

    public XDebugSessionTab init(XDebugProcess process, @NotNull XDebugSessionData sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.init must not be null");
        }
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebugProcess = process;
        XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
        XDependentBreakpointManager dependentBreakpointManager = breakpointManager.getDependentBreakpointManager();
        this.disableSlaveBreakpoints(dependentBreakpointManager);
        this.processAllBreakpoints(true, false);
        this.myBreakpointListener = new MyBreakpointListener();
        breakpointManager.addBreakpointListener(this.myBreakpointListener);
        this.myDependentBreakpointListener = new MyDependentBreakpointListener();
        dependentBreakpointManager.addListener(this.myDependentBreakpointListener);
        this.initSessionTab(sessionData);
        process.sessionInitialized();
        return this.mySessionTab;
    }

    public XDebugSessionTab getSessionTab() {
        return this.mySessionTab;
    }

    private void initSessionTab(@NotNull XDebugSessionData sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.initSessionTab must not be null");
        }
        this.mySessionTab = new XDebugSessionTab(this.myProject, this.mySessionName);
        if (this.myEnvironment != null) {
            this.mySessionTab.setEnvironment(this.myEnvironment);
        }
        Disposer.register((Disposable)this.myProject, (Disposable)this.mySessionTab);
        this.mySessionTab.attachToSession(this, this.myRunner, this.myEnvironment, sessionData);
    }

    private void disableSlaveBreakpoints(XDependentBreakpointManager dependentBreakpointManager) {
        Set<XBreakpoint<?>> slaveBreakpoints = dependentBreakpointManager.getAllSlaveBreakpoints();
        HashSet breakpointTypes = new HashSet();
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            breakpointTypes.add(XDebugSessionImpl.getBreakpointTypeClass(handler));
        }
        for (XBreakpoint<?> slaveBreakpoint : slaveBreakpoints) {
            if (!breakpointTypes.contains(slaveBreakpoint.getType())) continue;
            this.myDisabledSlaveBreakpoints.add(slaveBreakpoint);
        }
    }

    private static <B extends XBreakpoint<?>> XBreakpointType<?, ?> getBreakpointTypeClass(XBreakpointHandler<B> handler) {
        return XDebuggerUtil.getInstance().findBreakpointType(handler.getBreakpointTypeClass());
    }

    private <B extends XBreakpoint<?>> void processBreakpoints(XBreakpointHandler<B> handler, boolean register, boolean temporary) {
        XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(handler.getBreakpointTypeClass());
        Collection breakpoints = this.myDebuggerManager.getBreakpointManager().getBreakpoints(type);
        for (XBreakpoint b : breakpoints) {
            this.handleBreakpoint(handler, b, register, temporary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <B extends XBreakpoint<?>> void handleBreakpoint(XBreakpointHandler<B> handler, B b, boolean register, boolean temporary) {
        if (register && this.isBreakpointActive(b)) {
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
            synchronized (map) {
                this.myRegisteredBreakpoints.put(b, new CustomizedBreakpointPresentation());
            }
            handler.registerBreakpoint(b);
        }
        if (!register) {
            boolean removed = false;
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
            synchronized (map) {
                if (this.myRegisteredBreakpoints.containsKey(b)) {
                    this.myRegisteredBreakpoints.remove(b);
                    removed = true;
                }
            }
            if (removed) {
                handler.unregisterBreakpoint(b, temporary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CustomizedBreakpointPresentation getBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.getBreakpointPresentation must not be null");
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            return this.myRegisteredBreakpoints.get(breakpoint);
        }
    }

    private void processAllHandlers(XBreakpoint<?> breakpoint, boolean register) {
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoint(breakpoint, handler, register);
        }
    }

    private <B extends XBreakpoint<?>> void processBreakpoint(XBreakpoint<?> breakpoint, XBreakpointHandler<B> handler, boolean register) {
        XBreakpointType type = breakpoint.getType();
        if (handler.getBreakpointTypeClass().equals(type.getClass())) {
            XBreakpoint<?> b = breakpoint;
            this.handleBreakpoint(handler, b, register, false);
        }
    }

    private boolean isBreakpointActive(XBreakpoint<?> b) {
        return !this.myBreakpointsMuted && b.isEnabled() && !this.myDisabledSlaveBreakpoints.contains(b);
    }

    public boolean areBreakpointsMuted() {
        return this.myBreakpointsMuted;
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.addSessionListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeSessionListener(@NotNull XDebugSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.removeSessionListener must not be null");
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setBreakpointMuted(boolean muted) {
        if (this.myBreakpointsMuted == muted) {
            return;
        }
        this.myBreakpointsMuted = muted;
        this.processAllBreakpoints(!muted, muted);
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    public void stepOver(boolean ignoreBreakpoints) {
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.doResume();
        this.myDebugProcess.startStepOver();
    }

    public void stepInto() {
        this.doResume();
        this.myDebugProcess.startStepInto();
    }

    public void stepOut() {
        this.doResume();
        this.myDebugProcess.startStepOut();
    }

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> handler, V variant) {
        this.doResume();
        handler.startStepInto(variant);
    }

    public void forceStepInto() {
        this.stepInto();
    }

    public void runToPosition(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.runToPosition must not be null");
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.doResume();
        this.myDebugProcess.runToPosition(position);
    }

    public void pause() {
        this.myDebugProcess.startPausing();
    }

    private void processAllBreakpoints(boolean register, boolean temporary) {
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoints(handler, register, temporary);
        }
    }

    private void disableBreakpoints() {
        this.myBreakpointsDisabled = true;
        this.processAllBreakpoints(false, true);
    }

    public void resume() {
        this.doResume();
        this.myDebugProcess.resume();
    }

    private void doResume() {
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).beforeSessionResume();
        this.myDebuggerManager.updateExecutionPosition(this, null, false);
        this.mySuspendContext = null;
        this.myCurrentStackFrame = null;
        this.myCurrentPosition = null;
        this.myPaused = false;
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionResumed();
    }

    public void showExecutionPoint() {
        XStackFrame topFrame;
        XExecutionStack executionStack;
        if (this.mySuspendContext != null && (executionStack = this.mySuspendContext.getActiveExecutionStack()) != null && (topFrame = executionStack.getTopFrame()) != null) {
            this.setCurrentStackFrame(topFrame);
            this.myDebuggerManager.showExecutionPosition();
        }
    }

    public void setCurrentStackFrame(@NotNull XStackFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.setCurrentStackFrame must not be null");
        }
        if (this.mySuspendContext == null) {
            return;
        }
        boolean frameChanged = this.myCurrentStackFrame != frame;
        this.myCurrentStackFrame = frame;
        XSourcePosition position = frame.getSourcePosition();
        if (position != null) {
            XExecutionStack activeExecutionStack = this.mySuspendContext.getActiveExecutionStack();
            boolean isTopFrame = activeExecutionStack != null && activeExecutionStack.getTopFrame() == frame;
            this.myDebuggerManager.updateExecutionPosition(this, position, !isTopFrame);
        }
        if (frameChanged) {
            ((XDebugSessionListener)this.myDispatcher.getMulticaster()).stackFrameChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        CustomizedBreakpointPresentation presentation;
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.updateBreakpointPresentation must not be null");
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            presentation = this.myRegisteredBreakpoints.get(breakpoint);
            if (presentation != null) {
                presentation.setErrorMessage(errorMessage);
                presentation.setIcon(icon);
            }
        }
        if (presentation != null) {
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate((XLineBreakpointImpl)breakpoint);
        }
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.breakpointReached must not be null");
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.breakpointReached must not be null");
        }
        return this.breakpointReached(breakpoint, null, suspendContext);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.breakpointReached must not be null");
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.breakpointReached must not be null");
        }
        XDebuggerEvaluator evaluator = XDebuggerUtilImpl.getEvaluator(suspendContext);
        String condition = breakpoint.getCondition();
        if (condition != null && evaluator != null) {
            LOG.debug("evaluating condition: " + condition);
            boolean result = evaluator.evaluateCondition(condition);
            LOG.debug("condition evaluates to " + result);
            if (!result) {
                return false;
            }
        }
        if (breakpoint.isLogMessage()) {
            String text = StringUtil.decapitalize((String)XBreakpointUtil.getDisplayText(breakpoint));
            XSourcePosition position = breakpoint.getSourcePosition();
            OpenFileHyperlinkInfo hyperlinkInfo = position != null ? new OpenFileHyperlinkInfo(this.myProject, position.getFile(), position.getLine()) : null;
            this.printMessage(XDebuggerBundle.message((String)"xbreakpoint.reached.text", (Object[])new Object[0]) + " ", text, (HyperlinkInfo)hyperlinkInfo);
        }
        if (evaluatedLogExpression != null) {
            this.printMessage(evaluatedLogExpression, null, null);
        } else {
            String expression = breakpoint.getLogExpression();
            if (expression != null && evaluator != null) {
                LOG.debug("evaluating log expression: " + expression);
                String message = evaluator.evaluateMessage(expression);
                if (message != null) {
                    this.printMessage(message, null, null);
                }
            }
        }
        this.processDependencies(breakpoint);
        if (breakpoint.getSuspendPolicy() == SuspendPolicy.NONE) {
            return false;
        }
        this.positionReached(suspendContext);
        return true;
    }

    private void processDependencies(XBreakpoint<?> breakpoint) {
        boolean added;
        XDependentBreakpointManager dependentBreakpointManager = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager();
        if (!dependentBreakpointManager.isMasterOrSlave(breakpoint)) {
            return;
        }
        List<XBreakpoint<?>> breakpoints = dependentBreakpointManager.getSlaveBreakpoints(breakpoint);
        this.myDisabledSlaveBreakpoints.removeAll(breakpoints);
        for (XBreakpoint<?> slaveBreakpoint : breakpoints) {
            this.processAllHandlers(slaveBreakpoint, true);
        }
        if (dependentBreakpointManager.getMasterBreakpoint(breakpoint) != null && !dependentBreakpointManager.isLeaveEnabled(breakpoint) && (added = this.myDisabledSlaveBreakpoints.add(breakpoint))) {
            this.processAllHandlers(breakpoint, false);
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate(breakpoint);
        }
    }

    private void printMessage(final String message, final String hyperLinkText, final @Nullable HyperlinkInfo info) {
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                ConsoleView consoleView = XDebugSessionImpl.this.getConsoleView();
                consoleView.print(message, ConsoleViewContentType.SYSTEM_OUTPUT);
                if (info != null) {
                    consoleView.printHyperlink(hyperLinkText, info);
                } else if (hyperLinkText != null) {
                    consoleView.print(hyperLinkText, ConsoleViewContentType.SYSTEM_OUTPUT);
                }
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    private ConsoleView getConsoleView() {
        return (ConsoleView)this.mySessionTab.getConsole();
    }

    public void positionReached(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl.positionReached must not be null");
        }
        this.enableBreakpoints();
        this.mySuspendContext = suspendContext;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        this.myCurrentStackFrame = executionStack != null ? executionStack.getTopFrame() : null;
        this.myCurrentPosition = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        this.myPaused = true;
        if (this.myCurrentPosition != null) {
            this.myDebuggerManager.updateExecutionPosition(this, this.myCurrentPosition, false);
        }
        this.mySessionTab.toFront();
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionPaused();
    }

    private void enableBreakpoints() {
        if (this.myBreakpointsDisabled) {
            this.myBreakpointsDisabled = false;
            new ReadAction(){

                protected void run(Result result) {
                    XDebugSessionImpl.this.processAllBreakpoints(true, false);
                }
            }.execute();
        }
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void stopImpl() {
        if (this.myStopped) {
            return;
        }
        this.myDebugProcess.stop();
        this.myCurrentPosition = null;
        this.myCurrentStackFrame = null;
        this.mySuspendContext = null;
        this.myDebuggerManager.updateExecutionPosition(this, null, false);
        XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
        breakpointManager.removeBreakpointListener(this.myBreakpointListener);
        breakpointManager.getDependentBreakpointManager().removeListener(this.myDependentBreakpointListener);
        this.myStopped = true;
        this.myDebuggerManager.removeSession(this);
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionStopped();
    }

    public boolean isDisabledSlaveBreakpoint(XBreakpoint<?> breakpoint) {
        return this.myDisabledSlaveBreakpoints.contains(breakpoint);
    }

    public void stop() {
        ProcessHandler processHandler = this.myDebugProcess.getProcessHandler();
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            return;
        }
        if (processHandler.detachIsDefault()) {
            processHandler.detachProcess();
        } else {
            processHandler.destroyProcess();
        }
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(XBreakpoint<?> slave, XBreakpoint<?> master) {
            boolean added = XDebugSessionImpl.this.myDisabledSlaveBreakpoints.add(slave);
            if (added) {
                XDebugSessionImpl.this.processAllHandlers(slave, false);
            }
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            boolean removed = XDebugSessionImpl.this.myDisabledSlaveBreakpoints.remove(breakpoint);
            if (removed) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }
    }

    private class MyBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        private MyBreakpointListener() {
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener.breakpointAdded must not be null");
            }
            if (!XDebugSessionImpl.this.myBreakpointsDisabled) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener.breakpointRemoved must not be null");
            }
            XDebugSessionImpl.this.processAllHandlers(breakpoint, false);
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener.breakpointChanged must not be null");
            }
            this.breakpointRemoved(breakpoint);
            this.breakpointAdded(breakpoint);
        }
    }
}

