/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.LightCodeInsightTestCase");
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    private static final String CARET_MARKER = "<caret>";
    @NonNls
    private static final String SELECTION_START_MARKER = "<selection>";
    @NonNls
    private static final String SELECTION_END_MARKER = "</selection>";

    protected void runTest() throws Throwable {
        final Throwable[] throwable = new Throwable[]{null};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(LightPlatformTestCase.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LightPlatformCodeInsightTestCase.this.doRunTest();
                        }
                        catch (Throwable t) {
                            throwable[0] = t;
                        }
                    }
                }, "", null);
            }
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    protected void doRunTest() throws Throwable {
        LightPlatformCodeInsightTestCase.super.runTest();
    }

    protected void configureByFile(@NonNls String filePath) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        String fileText = new String(FileUtil.loadFileText((File)ioFile, (String)"UTF-8"));
        fileText = StringUtil.convertLineSeparators((String)fileText);
        LightPlatformCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
    }

    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected static void configureFromFileText(@NonNls String fileName, @NonNls String fileText) throws IOException {
        RangeMarker selEndMarker;
        DocumentImpl fakeDocument = new DocumentImpl(fileText);
        int caretIndex = fileText.indexOf(CARET_MARKER);
        int selStartIndex = fileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = fileText.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? fakeDocument.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? fakeDocument.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? fakeDocument.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (caretMarker != null) {
            fakeDocument.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            fakeDocument.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            fakeDocument.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        String newFileText = fakeDocument.getText();
        LightPlatformCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
        LightPlatformCodeInsightTestCase.setupCaret(caretMarker, newFileText);
        LightPlatformCodeInsightTestCase.setupSelection(selStartMarker, selEndMarker);
        LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
    }

    private static void setupSelection(RangeMarker selStartMarker, RangeMarker selEndMarker) {
        if (selStartMarker != null) {
            myEditor.getSelectionModel().setSelection(selStartMarker.getStartOffset(), selEndMarker.getStartOffset());
        }
    }

    private static void setupCaret(RangeMarker caretMarker, String fileText) {
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)fileText, (int)caretMarker.getStartOffset());
            int caretCol = EditorUtil.calcColumnNumber(null, myEditor.getDocument().getText(), myEditor.getDocument().getLineStartOffset(caretLine), caretMarker.getStartOffset(), CodeStyleSettingsManager.getSettings((Project)LightPlatformCodeInsightTestCase.getProject()).getIndentOptions((FileType)StdFileTypes.JAVA).TAB_SIZE);
            LogicalPosition pos = new LogicalPosition(caretLine, caretCol);
            myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
    }

    private static Editor createEditor(VirtualFile file) {
        return FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), file, 0), false);
    }

    private static void setupFileEditorAndDocument(String fileName, String fileText) throws IOException {
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance(ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.deleteVFile();
        myVFile = LightPlatformCodeInsightTestCase.getSourceRoot().createChildData(null, fileName);
        VfsUtil.saveText((VirtualFile)myVFile, (String)fileText);
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create document for '" + fileName + "'"), (Object)document);
        manager.reloadFromDisk(document);
        document.insertString(0, (CharSequence)" ");
        document.deleteString(0, 1);
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create PsiFile for '" + fileName + "'. Unknown file type most probably."), (Object)myFile);
        LightPlatformCodeInsightTestCase.assertTrue((boolean)myFile.isPhysical());
        myEditor = LightPlatformCodeInsightTestCase.createEditor(myVFile);
        myVFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
    }

    private static void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(myEditor, myFile);
        if (editor instanceof EditorWindow) {
            myFile = ((EditorWindow)editor).getInjectedFile();
            myEditor = editor;
        }
    }

    private static void deleteVFile() {
        if (myVFile != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        myVFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    protected void tearDown() throws Exception {
        VirtualFile[] openFiles;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        LightPlatformCodeInsightTestCase.deleteVFile();
        myEditor = null;
        myFile = null;
        myVFile = null;
        super.tearDown();
    }

    protected void checkResultByFile(@NonNls String filePath) throws Exception {
        this.checkResultByFile(null, filePath, false);
    }

    protected void checkResultByFile(String message, String filePath, boolean ignoreTrailingSpaces) throws Exception {
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        ((PostprocessReformattingAspect)LightPlatformCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = myEditor;
            ((DocumentEx)editor.getDocument()).stripTrailingSpaces(false);
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        String fileText = null;
        try {
            fileText = new String(FileUtil.loadFileText((File)ioFile, (String)"UTF-8"));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces);
    }

    protected void checkResultByText(@NonNls String fileText) {
        this.checkResultByText(null, fileText, false);
    }

    protected void checkResultByText(String message, String fileText, boolean ignoreTrailingSpaces) {
        RangeMarker selEndMarker;
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
        int caretIndex = fileText.indexOf(CARET_MARKER);
        int selStartIndex = fileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = fileText.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (ignoreTrailingSpaces) {
            ((DocumentEx)document).stripTrailingSpaces(false);
        }
        if (caretMarker != null) {
            document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        PostprocessReformattingAspect.getInstance(LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
        String newFileText = document.getText();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message), (String)newFileText, (String)myFile.getText());
        LightPlatformCodeInsightTestCase.checkCaretPosition(caretMarker, newFileText, message);
        LightPlatformCodeInsightTestCase.checkSelection(selStartMarker, selEndMarker, newFileText, message);
    }

    private static String getMessage(@NonNls String engineMessage, String userMessage) {
        if (userMessage == null) {
            return engineMessage;
        }
        return userMessage + " [" + engineMessage + "]";
    }

    private static void checkSelection(RangeMarker selStartMarker, RangeMarker selEndMarker, String newFileText, String message) {
        if (selStartMarker != null && selEndMarker != null) {
            int selStartLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)selStartMarker.getStartOffset());
            int selStartCol = selStartMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selStartLine, (int)0);
            int selEndLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)selEndMarker.getEndOffset());
            int selEndCol = selEndMarker.getEndOffset() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selEndLine, (int)0);
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("selectionStartLine", message), (int)(selStartLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)myEditor.getSelectionModel().getSelectionStart()) + 1));
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("selectionStartCol", message), (int)(selStartCol + 1), (int)(myEditor.getSelectionModel().getSelectionStart() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selStartLine, (int)0) + 1));
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("selectionEndLine", message), (int)(selEndLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)myEditor.getSelectionModel().getSelectionEnd()) + 1));
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("selectionEndCol", message), (int)(selEndCol + 1), (int)(myEditor.getSelectionModel().getSelectionEnd() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selEndLine, (int)0) + 1));
        } else {
            LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("must not have selection", message), (!myEditor.getSelectionModel().hasSelection() ? 1 : 0) != 0);
        }
    }

    private static void checkCaretPosition(RangeMarker caretMarker, String newFileText, String message) {
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)caretMarker.getStartOffset());
            int caretCol = EditorUtil.calcColumnNumber(null, newFileText, StringUtil.lineColToOffset((CharSequence)newFileText, (int)caretLine, (int)0), caretMarker.getStartOffset(), CodeStyleSettingsManager.getSettings((Project)LightPlatformCodeInsightTestCase.getProject()).getIndentOptions((FileType)StdFileTypes.JAVA).TAB_SIZE);
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("caretLine", message), (int)(caretLine + 1), (int)(LightPlatformCodeInsightTestCase.myEditor.getCaretModel().getLogicalPosition().line + 1));
            LightPlatformCodeInsightTestCase.assertEquals((String)LightPlatformCodeInsightTestCase.getMessage("caretColumn", message), (int)(caretCol + 1), (int)(LightPlatformCodeInsightTestCase.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return myEditor;
        }
        if (dataId.equals(AnActionEvent.injectedId((String)PlatformDataKeys.EDITOR.getName()))) {
            return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getFile());
        }
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return myFile;
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()))) {
            Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getFile());
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getInjectedFile() : LightPlatformCodeInsightTestCase.getFile();
        }
        return super.getData(dataId);
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected static void type(char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        DataContext dataContext = DataManager.getInstance().getDataContext();
        if (c == '\n') {
            actionManager.getActionHandler("EditorEnter").execute(LightPlatformCodeInsightTestCase.getEditor(), dataContext);
        } else if (c == '\b') {
            actionManager.getActionHandler("EditorBackSpace").execute(LightPlatformCodeInsightTestCase.getEditor(), dataContext);
        } else {
            actionManager.getTypedAction().actionPerformed(LightPlatformCodeInsightTestCase.getEditor(), c, dataContext);
        }
    }

    protected static void type(@NonNls String s) {
        for (char c : s.toCharArray()) {
            LightPlatformCodeInsightTestCase.type(c);
        }
    }

    protected static void backspace() {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorBackSpace");
        actionHandler.execute(LightPlatformCodeInsightTestCase.getEditor(), DataManager.getInstance().getDataContext());
    }

    protected static void delete() {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorDelete");
        actionHandler.execute(LightPlatformCodeInsightTestCase.getEditor(), DataManager.getInstance().getDataContext());
    }

    protected static DataContext getCurrentEditorDataContext() {
        final DataContext defaultContext = DataManager.getInstance().getDataContext();
        return new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.EDITOR.is(dataId)) {
                    return LightPlatformCodeInsightTestCase.getEditor();
                }
                if (PlatformDataKeys.PROJECT.is(dataId)) {
                    return LightPlatformTestCase.getProject();
                }
                if (LangDataKeys.PSI_FILE.is(dataId)) {
                    return LightPlatformCodeInsightTestCase.getFile();
                }
                if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
                    return LightPlatformCodeInsightTestCase.getFile().findElementAt(LightPlatformCodeInsightTestCase.getEditor().getCaretModel().getOffset());
                }
                return defaultContext.getData(dataId);
            }
        };
    }
}

