/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CodeFragmentTableCellRenderer
implements TableCellRenderer {
    private final Project myProject;

    public CodeFragmentTableCellRenderer(Project project) {
        this.myProject = project;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditorTextField editorTextField;
        PsiCodeFragment codeFragment = (PsiCodeFragment)value;
        if (codeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)codeFragment);
            editorTextField = new EditorTextField(document, this.myProject, (FileType)StdFileTypes.JAVA){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        } else {
            editorTextField = new EditorTextField("", this.myProject, (FileType)StdFileTypes.JAVA){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        }
        editorTextField.setBorder(hasFocus ? BorderFactory.createLineBorder(table.getForeground()) : null);
        return editorTextField;
    }
}

