/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private Project myProject;
    private PsiClass mySelectedClass;
    private String myChooserTitle;

    public ClassNameReferenceEditor(@NotNull PsiManager manager, @Nullable PsiClass selectedClass) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/ClassNameReferenceEditor.<init> must not be null");
        }
        this(manager, selectedClass, null);
    }

    public ClassNameReferenceEditor(final @NotNull PsiManager manager, @Nullable PsiClass selectedClass, final @Nullable GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/ClassNameReferenceEditor.<init> must not be null");
        }
        super(null, manager.getProject(), new Function<String, Document>(){

            public Document fun(String s) {
                PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
                PsiJavaCodeReferenceCodeFragment fragment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createReferenceCodeFragment(s, (PsiElement)defaultPackage, true, true);
                fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
                if (resolveScope != null) {
                    fragment.forceResolveScope(resolveScope);
                }
                return PsiDocumentManager.getInstance((Project)manager.getProject()).getDocument((PsiFile)fragment);
            }
        }, selectedClass != null ? selectedClass.getQualifiedName() : "");
        this.myProject = manager.getProject();
        this.myChooserTitle = "Choose Class";
        this.addActionListener(new ChooseClassAction());
    }

    public String getChooserTitle() {
        return this.myChooserTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ClassNameReferenceEditor.this.myProject).createWithInnerClassesScopeChooser(ClassNameReferenceEditor.this.myChooserTitle, GlobalSearchScope.projectScope((Project)ClassNameReferenceEditor.this.myProject), new TreeClassChooser.ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getParent() instanceof PsiJavaFile || aClass.hasModifierProperty("static");
                }
            }, null);
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                chooser.selectDirectory(ClassNameReferenceEditor.this.mySelectedClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            ClassNameReferenceEditor.this.mySelectedClass = chooser.getSelectedClass();
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                ClassNameReferenceEditor.this.setText(ClassNameReferenceEditor.this.mySelectedClass.getQualifiedName());
            }
        }
    }
}

