/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorComboWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

class CopyFilesOrDirectoriesDialog
extends DialogWrapper {
    private JLabel myInformationLabel;
    private EditorComboWithBrowseButton myTargetDirectoryField;
    private JTextField myNewNameField;
    private final Project myProject;
    private final boolean myShowDirectoryField;
    private final boolean myShowNewNameField;
    private PsiDirectory myTargetDirectory;
    @NonNls
    private static final String RECENT_KEYS = "CopyFile.RECENT_KEYS";

    public CopyFilesOrDirectoriesDialog(PsiElement[] elements, PsiDirectory defaultTargetDirectory, Project project, boolean doClone) {
        super(project, true);
        this.myProject = project;
        this.myShowDirectoryField = !doClone;
        boolean bl = this.myShowNewNameField = elements.length == 1;
        if (doClone && elements.length != 1) {
            throw new IllegalArgumentException("wrong number of elements to clone: " + elements.length);
        }
        this.setTitle(doClone ? RefactoringBundle.message((String)"copy.files.clone.title") : RefactoringBundle.message((String)"copy.files.copy.title"));
        this.init();
        if (elements.length == 1) {
            String text;
            if (elements[0] instanceof PsiFile) {
                PsiFile file = (PsiFile)elements[0];
                text = doClone ? RefactoringBundle.message((String)"copy.files.clone.file.0", (Object[])new Object[]{file.getVirtualFile().getPresentableUrl()}) : RefactoringBundle.message((String)"copy.files.copy.file.0", (Object[])new Object[]{file.getVirtualFile().getPresentableUrl()});
                this.myNewNameField.setText(file.getName());
            } else {
                PsiDirectory directory = (PsiDirectory)elements[0];
                text = doClone ? RefactoringBundle.message((String)"copy.files.clone.directory.0", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl()}) : RefactoringBundle.message((String)"copy.files.copy.directory.0", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl()});
                this.myNewNameField.setText(directory.getName());
            }
            this.myInformationLabel.setText(text);
        } else {
            this.setMultipleElementCopyLabel(elements);
        }
        if (this.myShowDirectoryField) {
            this.myTargetDirectoryField.prependItem(defaultTargetDirectory == null ? "" : defaultTargetDirectory.getVirtualFile().getPresentableUrl());
        }
        this.validateOKButton();
    }

    private void setMultipleElementCopyLabel(PsiElement[] elements) {
        boolean allFiles = true;
        boolean allDirectories = true;
        for (PsiElement element : elements) {
            if (element instanceof PsiDirectory) {
                allFiles = false;
                continue;
            }
            allDirectories = false;
        }
        if (allFiles) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.files.label"));
        } else if (allDirectories) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.directories.label"));
        } else {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.mixed.label"));
        }
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowDirectoryField ? this.myTargetDirectoryField.getChildComponent() : this.myNewNameField;
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(IdeBorderFactory.createBorder());
        this.myInformationLabel = new JLabel();
        panel.add((Component)this.myInformationLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 4, 8), 0, 0));
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void textChanged(javax.swing.event.DocumentEvent event) {
                CopyFilesOrDirectoriesDialog.this.validateOKButton();
            }
        };
        if (this.myShowDirectoryField) {
            panel.add((Component)new JLabel(RefactoringBundle.message((String)"copy.files.to.directory.label")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 8, 4, 8), 0, 0));
            this.myTargetDirectoryField = new EditorComboWithBrowseButton(null, "", this.myProject, RECENT_KEYS);
            this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.copied.to.this.directory"), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor(), EditorComboBox.COMPONENT_ACCESSOR);
            this.myTargetDirectoryField.setTextFieldPreferredWidth(60);
            panel.add((Component)((Object)this.myTargetDirectoryField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 4, 8), 0, 0));
            ((EditorComboBox)this.myTargetDirectoryField.getChildComponent()).getDocument().addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)new com.intellij.openapi.editor.event.DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    CopyFilesOrDirectoriesDialog.this.validateOKButton();
                }
            });
        }
        if (this.myShowNewNameField) {
            this.myNewNameField = new JTextField();
            Dimension size = this.myNewNameField.getPreferredSize();
            FontMetrics fontMetrics = this.myNewNameField.getFontMetrics(this.myNewNameField.getFont());
            size.width = fontMetrics.charWidth('a') * 60;
            this.myNewNameField.setPreferredSize(size);
            panel.add((Component)new JLabel(RefactoringBundle.message((String)"copy.files.new.name.label")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 8, 4, 8), 0, 0));
            panel.add((Component)this.myNewNameField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 4, 8), 0, 0));
            this.myNewNameField.getDocument().addDocumentListener((DocumentListener)documentListener);
        }
        return panel;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getNewName() {
        return this.myNewNameField != null ? this.myNewNameField.getText().trim() : null;
    }

    protected void doOKAction() {
        String newName;
        if (this.myShowNewNameField && (newName = this.getNewName()).length() == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.new.name.specified"), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            return;
        }
        if (this.myShowDirectoryField) {
            final String targetDirectoryName = this.myTargetDirectoryField.getText();
            if (targetDirectoryName.length() == 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.target.directory.specified"), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                return;
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, targetDirectoryName);
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CopyFilesOrDirectoriesDialog.this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)CopyFilesOrDirectoriesDialog.this.myProject), targetDirectoryName.replace(File.separatorChar, '/'));
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, RefactoringBundle.message((String)"create.directory"), null);
            if (this.myTargetDirectory == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        super.doOKAction();
    }

    private void validateOKButton() {
        if (this.myShowDirectoryField && this.myTargetDirectoryField.getText().length() == 0) {
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myShowNewNameField && this.getNewName().length() == 0) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(true);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.copyClass");
    }
}

