/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.lang.LanguageExtractInclude;
import com.intellij.refactoring.lang.TitledHandler;

public class ExtractIncludeAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return false;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        RefactoringActionHandler handler = this.getHandler(e.getDataContext());
        if (handler instanceof TitledHandler) {
            e.getPresentation().setText(((TitledHandler)handler).getActionTitle());
        } else {
            e.getPresentation().setText("Extract Include File...");
        }
    }

    @Override
    protected boolean isAvailableForFile(PsiFile file) {
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        return LanguageExtractInclude.INSTANCE.forLanguage(baseLanguage) != null;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return (RefactoringActionHandler)LanguageExtractInclude.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage());
    }
}

