/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDClassComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDMethodComment;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class JDParser {
    private final CodeStyleSettings mySettings;
    private static final char lineSeparator = '\n';
    @NonNls
    private static final String SEE_TAG = "see";
    @NonNls
    private static final String SINCE_TAG = "since";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String DEPRECATED_TAG = "deprecated";
    @NonNls
    private static final String RETURN_TAG = "return";
    @NonNls
    private static final String PARAM_TAG = "param";
    @NonNls
    private static final String THROWS_TAG = "throws";
    @NonNls
    private static final String EXCEPTION_TAG = "exception";
    @NonNls
    private static final String AUTHOR_TAG = "author";
    private static final TagParser[] tagParsers = new TagParser[]{new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDParser.SEE_TAG.equals(tag);
            if (isMyTag) {
                c.addSeeAlso(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDParser.SINCE_TAG.equals(tag);
            if (isMyTag) {
                c.setSince(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDClassComment && JDParser.VERSION_TAG.equals(tag);
            if (isMyTag) {
                ((JDClassComment)c).setVersion(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDParser.DEPRECATED_TAG.equals(tag);
            if (isMyTag) {
                c.setDeprecated(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDMethodComment && JDParser.RETURN_TAG.equals(tag);
            if (isMyTag) {
                JDMethodComment mc = (JDMethodComment)c;
                mc.setReturnTag(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDMethodComment && JDParser.PARAM_TAG.equals(tag);
            if (isMyTag) {
                char ch;
                int idx;
                JDMethodComment mc = (JDMethodComment)c;
                for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
                }
                if (idx == line.length()) {
                    mc.addParameter(line, "");
                } else {
                    String name = line.substring(0, idx);
                    String desc = line.substring(idx).trim();
                    mc.addParameter(name, desc);
                }
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDMethodComment && (JDParser.THROWS_TAG.equals(tag) || JDParser.EXCEPTION_TAG.equals(tag));
            if (isMyTag) {
                char ch;
                int idx;
                JDMethodComment mc = (JDMethodComment)c;
                for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
                }
                if (idx == line.length()) {
                    mc.addThrow(line, "");
                } else {
                    String name = line.substring(0, idx);
                    String desc = line.substring(idx).trim();
                    mc.addThrow(name, desc);
                }
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDClassComment && JDParser.AUTHOR_TAG.equals(tag);
            if (isMyTag) {
                JDClassComment cl = (JDClassComment)c;
                cl.addAuthor(line.trim());
            }
            return isMyTag;
        }
    }};

    public JDParser(CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public JDComment parse(String text, JDComment c) {
        if (text == null) {
            return c;
        }
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        ArrayList<String> l = this.toArray(text, "\n", markers);
        if (l == null) {
            return c;
        }
        int size = l.size();
        if (size == 0) {
            return c;
        }
        for (int i = 0; i < size; ++i) {
            String line = l.get(i);
            if ((line = line.trim()).length() > 0 && line.charAt(0) == '*') {
                line = markers.get(i).booleanValue() ? (line.length() > 1 && line.charAt(1) == ' ' ? line.substring(2) : line.substring(1)) : line.substring(1).trim();
            }
            l.set(i, line);
        }
        StringBuffer sb = new StringBuffer();
        String tag = null;
        for (int i = 0; i <= size; ++i) {
            String line;
            String string = line = i == size ? null : l.get(i);
            if (i == size || line.length() > 0) {
                if (i == size || line.charAt(0) == '@') {
                    if (tag == null) {
                        c.setDescription(sb.toString());
                    } else {
                        TagParser parser;
                        int j;
                        String myline = sb.toString();
                        for (j = 0; j < tagParsers.length && !(parser = tagParsers[j]).parse(tag, myline, c); ++j) {
                        }
                        if (j == tagParsers.length) {
                            c.addUnknownTag("@" + tag + " " + myline);
                        }
                    }
                    if (i >= size) continue;
                    int last_idx = line.indexOf(32);
                    if (last_idx == -1) {
                        tag = line.substring(1);
                        line = "";
                    } else {
                        tag = line.substring(1, last_idx);
                        line = line.substring(last_idx).trim();
                    }
                    sb.setLength(0);
                    sb.append(line);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                continue;
            }
            if (sb.length() <= 0) continue;
            sb.append('\n');
        }
        return c;
    }

    public ArrayList<String> toArrayByNL(String s) {
        return this.toArray(s, "\n", null);
    }

    public ArrayList<String> toArrayByComma(String s) {
        return this.toArray(s, ",", null);
    }

    private ArrayList<String> toArray(String s, String separators, ArrayList<Boolean> markers) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        boolean p2nl = markers != null && this.mySettings.JD_P_AT_EMPTY_LINES;
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, separators, true);
        boolean first = true;
        int preCount = 0;
        int curPos = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            curPos += token.length();
            if (separators.indexOf(token) >= 0) {
                if (!first) {
                    list.add("");
                    if (markers != null) {
                        markers.add(preCount > 0);
                    }
                }
                first = false;
                continue;
            }
            first = true;
            if (p2nl && this.isParaTag(token) && s.indexOf("</p>", curPos) < 0) {
                list.add("");
                markers.add(preCount > 0);
                continue;
            }
            if (preCount == 0) {
                token = token.trim();
            }
            list.add(token);
            if (markers == null) continue;
            if (token.indexOf("<pre>") >= 0) {
                ++preCount;
            }
            markers.add(preCount > 0);
            if (token.indexOf("</pre>") < 0) continue;
            --preCount;
        }
        return list;
    }

    private boolean isParaTag(String token) {
        String withoutWS = this.removeWhiteSpacesFrom(token).toLowerCase();
        return withoutWS.equals("<p/>") || withoutWS.equals("<p>");
    }

    private String removeWhiteSpacesFrom(String token) {
        StringBuffer result = new StringBuffer();
        for (char c : token.toCharArray()) {
            if (c == ' ') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String toLines(ArrayList l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Object aL : l) {
            String s = (String)aL;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toCommaSeparated(ArrayList<String> l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            String s = l.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private ArrayList<String> toArrayWrapping(String s, int width) {
        int i;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        ArrayList<String> listParagraphs = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        ArrayList<String> list = this.toArray(s, "\n", markers);
        Boolean[] marks = markers.toArray(new Boolean[markers.size()]);
        markers.clear();
        for (i = 0; i < list.size(); ++i) {
            String s1 = list.get(i);
            if (marks[i].booleanValue()) {
                if (sb.length() != 0) {
                    listParagraphs.add(sb.toString());
                    markers.add(false);
                    sb.setLength(0);
                }
                listParagraphs.add(s1);
                markers.add(marks[i]);
                continue;
            }
            if (s1.length() == 0) {
                if (sb.length() != 0) {
                    listParagraphs.add(sb.toString());
                    markers.add(false);
                    sb.setLength(0);
                }
                listParagraphs.add("");
                markers.add(marks[i]);
                continue;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(s1);
        }
        if (sb.length() != 0) {
            listParagraphs.add(sb.toString());
            markers.add(false);
        }
        list.clear();
        block1: for (i = 0; i < listParagraphs.size(); ++i) {
            String seq = (String)listParagraphs.get(i);
            boolean isMarked = markers.get(i);
            if (seq.length() == 0) {
                list.add("");
                continue;
            }
            while (true) {
                if (seq.length() < width) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block1;
                }
                int wrapPos = Math.min(seq.length() - 1, width);
                if ((wrapPos = seq.lastIndexOf(32, wrapPos)) <= 2 * width / 3) {
                    wrapPos = Math.min(seq.length() - 1, width);
                    wrapPos = seq.indexOf(32, wrapPos);
                }
                if (wrapPos >= seq.length() - 1 || wrapPos == -1) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block1;
                }
                list.add(seq.substring(0, wrapPos));
                seq = seq.substring(wrapPos + 1);
            }
        }
        return list;
    }

    protected StringBuffer splitIntoCLines(String s, String prefix) {
        return this.splitIntoCLines(s, prefix, true);
    }

    protected StringBuffer splitIntoCLines(String s, String prefix, boolean add_prefix_to_first_line) {
        return this.splitIntoCLines(s, new StringBuffer(prefix), add_prefix_to_first_line);
    }

    protected StringBuffer splitIntoCLines(String s, StringBuffer prefix, boolean add_prefix_to_first_line) {
        ArrayList<String> list;
        StringBuffer sb = new StringBuffer();
        if (add_prefix_to_first_line) {
            sb.append(prefix);
        }
        ArrayList<String> arrayList = list = this.mySettings.WRAP_COMMENTS ? this.toArrayWrapping(s, this.mySettings.RIGHT_MARGIN - prefix.length()) : this.toArray(s, "\n", new ArrayList<Boolean>());
        if (list == null) {
            sb.append('\n');
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String line = list.get(i);
                if (line.length() == 0 && !this.mySettings.JD_KEEP_EMPTY_LINES) continue;
                if (i != 0) {
                    sb.append(prefix);
                }
                if (line.length() == 0 && this.mySettings.JD_P_AT_EMPTY_LINES) {
                    sb.append("<p/>");
                } else {
                    sb.append(line);
                }
                sb.append('\n');
            }
        }
        return sb;
    }

    static abstract class TagParser {
        TagParser() {
        }

        abstract boolean parse(String var1, String var2, JDComment var3);
    }
}

