/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
implements SmartPointerElementInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.AnchorElementInfo");
    private PsiFile myFile;
    private final RangeMarker myMarker;
    private int mySyncStartOffset;
    private int mySyncEndOffset;
    private boolean mySyncMarkerIsValid;
    private final Project myProject;

    AnchorElementInfo(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/AnchorElementInfo.<init> must not be null");
        }
        LOG.assertTrue(anchor.isPhysical());
        LOG.assertTrue(anchor.isValid());
        this.myFile = anchor.getContainingFile();
        this.myProject = this.myFile.getProject();
        TextRange range = anchor.getTextRange();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = documentManager.getDocument(this.myFile);
        LOG.assertTrue(!documentManager.isUncommited(document));
        if (this.myFile.getTextLength() != document.getTextLength()) {
            final String docText = document.getText();
            this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    TextRange elementRange = element.getTextRange();
                    String rangeText = docText.length() <= elementRange.getEndOffset() ? "(IOOBE: " + docText.length() + " is out of " + elementRange + ")" : elementRange.substring(docText);
                    String elemText = element.getText();
                    if (!rangeText.equals(elemText)) {
                        throw new AssertionError((Object)("PSI text doesn't equal to the document's one: element" + element + "\ndocText=" + rangeText + "\npsiText" + elemText));
                    }
                }
            });
            LOG.error("File=" + this.myFile);
        }
        this.myMarker = document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        this.mySyncStartOffset = range.getStartOffset();
        this.mySyncEndOffset = range.getEndOffset();
        this.mySyncMarkerIsValid = true;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return this.myMarker.getDocument();
    }

    @Override
    public void documentAndPsiInSync() {
        if (!this.myMarker.isValid()) {
            this.mySyncMarkerIsValid = false;
            return;
        }
        this.mySyncStartOffset = this.myMarker.getStartOffset();
        this.mySyncEndOffset = this.myMarker.getEndOffset();
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        this.myFile = SelfElementInfo.restoreFile(this.myFile, this.myProject);
        if (this.myFile == null) {
            return null;
        }
        PsiElement anchor = this.myFile.findElementAt(this.mySyncStartOffset);
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != this.mySyncStartOffset || range.getEndOffset() != this.mySyncEndOffset) {
            return null;
        }
        if (anchor instanceof PsiIdentifier) {
            PsiElement parent = anchor.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement) {
                parent = parent.getParent();
            }
            if (!anchor.equals(AnchorElementInfoFactory.getAnchor(parent))) {
                return null;
            }
            return parent;
        }
        if (anchor instanceof XmlToken) {
            XmlToken token = (XmlToken)anchor;
            return token.getTokenType() == XmlTokenType.XML_NAME ? token.getParent() : null;
        }
        return null;
    }
}

