/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;

public class CachesBasedRefSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public static boolean DEBUG = false;

    public boolean execute(final ReferencesSearch.SearchParameters p, final Processor<PsiReference> consumer) {
        SearchScope searchScope;
        final PsiElement refElement = p.getElementToSearch();
        String text = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiMetaData metaData;
                String text = null;
                if (refElement instanceof PsiFile) {
                    VirtualFile vFile = ((PsiFile)refElement).getVirtualFile();
                    if (vFile != null) {
                        text = vFile.getNameWithoutExtension();
                    }
                } else if (refElement instanceof PsiNamedElement) {
                    text = ((PsiNamedElement)refElement).getName();
                    if (refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
                        text = metaData.getName();
                    }
                }
                if (text == null && refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
                    text = metaData.getName();
                }
                return text;
            }
        });
        if (StringUtil.isEmpty((String)text)) {
            return true;
        }
        if (DEBUG) {
            System.out.println("Searching for :" + text);
        }
        final boolean ignoreInjectedPsi = (searchScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return p.getEffectiveSearchScope();
            }
        })) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        TextOccurenceProcessor processor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                PsiReference[] refs;
                ProgressManager.checkCanceled();
                if (DEBUG) {
                    System.out.println("!!! About to check " + element);
                }
                if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                    return true;
                }
                for (PsiReference ref : refs = element.getReferences()) {
                    if (DEBUG) {
                        System.out.println("!!!!!!!!!!!!!! Ref " + ref);
                    }
                    if (!ref.getRangeInElement().contains(offsetInElement)) continue;
                    if (DEBUG) {
                        System.out.println("!!!!!!!!!!!!!!!!!!!!! Ref " + ref + " contains");
                    }
                    if (!ref.isReferenceTo(refElement)) continue;
                    if (DEBUG) {
                        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!   Found ref " + ref);
                    }
                    return consumer.process((Object)ref);
                }
                return true;
            }
        };
        short searchContext = 11;
        PsiSearchHelper helper = PsiManager.getInstance((Project)refElement.getProject()).getSearchHelper();
        return helper.processElementsWithWord(processor, searchScope, text, searchContext, refElement.getLanguage().isCaseSensitive());
    }
}

