/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private StringRef myPackageName;
    private final boolean myCompiled;

    public PsiJavaFileStubImpl(PsiJavaFile file, boolean compiled) {
        super((PsiFile)file);
        this.myPackageName = StringRef.fromString((String)file.getPackageName());
        this.myCompiled = compiled;
    }

    public PsiJavaFileStubImpl(String packageName, boolean compiled) {
        this(StringRef.fromString((String)packageName), compiled);
    }

    public PsiJavaFileStubImpl(StringRef packageName, boolean compiled) {
        super(null);
        this.myPackageName = packageName;
        this.myCompiled = compiled;
    }

    @Override
    public String getPackageName() {
        return StringRef.toString((StringRef)this.myPackageName);
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = StringRef.fromString((String)packageName);
    }

    public IStubFileElementType getType() {
        return JavaStubElementTypes.FILE;
    }

    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }

    public PsiClass[] getClasses() {
        return (PsiClass[])this.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
    }
}

