/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsModifierListOwner;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsFieldImpl
extends ClsRepositoryPsiElement<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsFieldImpl");
    private final PsiIdentifier myNameIdentifier;
    private final PsiDocComment myDocComment = this.isDeprecated() ? new ClsDocCommentImpl((PsiDocCommentOwner)this) : null;
    private PsiTypeElement myType = null;
    private PsiExpression myInitializer = null;
    private boolean myInitializerInitialized = false;

    public ClsFieldImpl(PsiFieldStub stub) {
        super(stub);
        this.myNameIdentifier = new ClsIdentifierImpl(this, this.getName());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiTypeElement type = this.getTypeElement();
        PsiIdentifier name = this.getNameIdentifier();
        int count = (docComment != null ? 1 : 0) + (modifierList != null ? 1 : 0) + (type != null ? 1 : 0) + (name != null ? 1 : 0);
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        if (modifierList != null) {
            children[offset++] = modifierList;
        }
        if (type != null) {
            children[offset++] = type;
        }
        if (name != null) {
            children[offset++] = name;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getChildren must not return null");
        }
        return children;
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myNameIdentifier;
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = ((PsiFieldStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getType must not return null");
        }
        return psiType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiTypeElement getTypeElement() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myType == null) {
                String typeText = TypeInfo.createTypeText(((PsiFieldStub)this.getStub()).getType(false));
                this.myType = new ClsTypeElementImpl(this, typeText, '\u0000');
            }
            return this.myType;
        }
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiExpression getInitializer() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (!this.myInitializerInitialized) {
                this.myInitializerInitialized = true;
                String initializerText = ((PsiFieldStub)this.getStub()).getInitializerText();
                if (initializerText != null && !Comparing.equal((String)";INITIALIZER_TOO_LONG;", (String)initializerText)) {
                    this.myInitializer = ClsParsingUtil.createExpressionFromText(initializerText, this.getManager(), this);
                }
            }
            return this.myInitializer;
        }
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        String qName = this.getContainingClass().getQualifiedName();
        if ("java.lang.Float".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Float(Float.NaN);
            }
        } else if ("java.lang.Double".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Double(Double.NaN);
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated();
    }

    public PsiDocComment getDocComment() {
        return this.myDocComment;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsFieldImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)this.getModifierList()).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)this.getTypeElement()).appendMirrorText(indentLevel, buffer);
        buffer.append(' ');
        ((ClsElementImpl)this.getNameIdentifier()).appendMirrorText(indentLevel, buffer);
        if (this.getInitializer() != null) {
            buffer.append(" = ");
            buffer.append(this.getInitializer().getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeElementToPsi(element);
        if (this.getDocComment() != null) {
            ((ClsElementImpl)this.getDocComment()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getDocComment()));
        }
        ((ClsElementImpl)this.getModifierList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getModifierList()));
        ((ClsElementImpl)this.getTypeElement()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getTypeElement()));
        ((ClsElementImpl)this.getNameIdentifier()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getNameIdentifier()));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField((PsiField)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        PsiField sourceFieldMirror = sourceClassMirror != null ? sourceClassMirror.findFieldByName(this.getName(), false) : null;
        Object object = sourceFieldMirror != null ? sourceFieldMirror : this;
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNavigationElement must not return null");
        }
        return object;
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation(this);
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ClsFieldImpl.createLayeredIcon((Icon)Icons.FIELD_ICON, (int)ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

