/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.idea.LoggerFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexers;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.TodoOccurrenceConsumer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdTableBuilding {
    private static final HashMap<FileType, FileTypeIdIndexer> ourIdIndexers = new HashMap();
    private static final HashMap<FileType, DataIndexer<TodoIndexEntry, Integer, FileContent>> ourTodoIndexers = new HashMap();
    private static final TokenSet ABSTRACT_FILE_COMMENT_TOKENS;

    private IdTableBuilding() {
    }

    @Deprecated
    public static void registerIdIndexer(FileType fileType, FileTypeIdIndexer indexer) {
        ourIdIndexers.put(fileType, indexer);
    }

    @Deprecated
    public static void registerTodoIndexer(FileType fileType, DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
        ourTodoIndexers.put(fileType, indexer);
    }

    public static boolean isIdIndexerRegistered(FileType fileType) {
        return ourIdIndexers.containsKey(fileType) || IdIndexers.INSTANCE.forFileType(fileType) != null;
    }

    public static boolean isTodoIndexerRegistered(FileType fileType) {
        return ourIdIndexers.containsKey(fileType) || TodoIndexers.INSTANCE.forFileType(fileType) != null;
    }

    @Nullable
    public static FileTypeIdIndexer getFileTypeIndexer(FileType fileType) {
        FileTypeIdIndexer idIndexer = ourIdIndexers.get(fileType);
        if (idIndexer != null) {
            return idIndexer;
        }
        FileTypeIdIndexer extIndexer = (FileTypeIdIndexer)IdIndexers.INSTANCE.forFileType(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return new WordsScannerFileTypeIdIndexerAdapter(customWordsScanner);
        }
        if (fileType instanceof LanguageFileType) {
            WordsScanner scanner;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            FindUsagesProvider findUsagesProvider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
            WordsScanner wordsScanner = scanner = findUsagesProvider == null ? null : findUsagesProvider.getWordsScanner();
            if (scanner == null) {
                scanner = new SimpleWordsScanner();
            }
            return new WordsScannerFileTypeIdIndexerAdapter(scanner);
        }
        if (fileType instanceof AbstractFileType) {
            return new WordsScannerFileTypeIdIndexerAdapter(IdTableBuilding.createWordScaner((AbstractFileType)fileType));
        }
        return null;
    }

    private static WordsScanner createWordScaner(AbstractFileType abstractFileType) {
        return new DefaultWordsScanner((Lexer)new CustomFileTypeLexer(abstractFileType.getSyntaxTable(), true), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING}));
    }

    @Nullable
    public static DataIndexer<TodoIndexEntry, Integer, FileContent> getTodoIndexer(FileType fileType, VirtualFile virtualFile) {
        DataIndexer<TodoIndexEntry, Integer, FileContent> indexer = ourTodoIndexers.get(fileType);
        if (indexer != null) {
            return indexer;
        }
        DataIndexer extIndexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        if (fileType instanceof LanguageFileType) {
            TokenSet commentTokens;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet tokenSet = commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            if (commentTokens != null) {
                return new TokenSetTodoIndexer(commentTokens, virtualFile);
            }
        }
        if (fileType instanceof AbstractFileType) {
            return new TokenSetTodoIndexer(ABSTRACT_FILE_COMMENT_TOKENS, virtualFile);
        }
        return null;
    }

    public static boolean checkCanUseCachedEditorHighlighter(CharSequence chars, EditorHighlighter editorHighlighter) {
        assert (editorHighlighter instanceof LexerEditorHighlighter);
        boolean b = ((LexerEditorHighlighter)editorHighlighter).checkContentIsEqualTo(chars);
        if (!b) {
            Logger logger = LoggerFactory.getInstance().getLoggerInstance(IdTableBuilding.class.getName());
            logger.warn("Unexpected mismatch of editor highlighter content with indexing content");
        }
        return b;
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, int startOffset, int endOffset) {
        IdTableBuilding.scanWords(processor, chars, CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars), startOffset, endOffset, false);
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, @Nullable char[] charArray, int startOffset, int endOffset, boolean mayHaveEscapes) {
        boolean hasArray;
        int index = startOffset;
        boolean bl = hasArray = charArray != null;
        while (index < endOffset) {
            char c;
            char c2 = c = hasArray ? charArray[index] : chars.charAt(index);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierStart(c) && c != '$')) {
                ++index;
                if (!mayHaveEscapes || c != '\\') continue;
                ++index;
                continue;
            }
            int index1 = index;
            while (++index < endOffset) {
                char c3;
                char c4 = c3 = hasArray ? charArray[index] : chars.charAt(index);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3) && c3 != '$') continue;
                break;
            }
            if (index - index1 > 100) continue;
            processor.run(chars, index1, index);
        }
    }

    static {
        IdTableBuilding.registerIdIndexer((FileType)FileTypes.PLAIN_TEXT, new PlainTextIndexer());
        IdTableBuilding.registerTodoIndexer((FileType)FileTypes.PLAIN_TEXT, new PlainTextTodoIndexer());
        IdTableBuilding.registerIdIndexer(StdFileTypes.IDEA_MODULE, null);
        IdTableBuilding.registerIdIndexer(StdFileTypes.IDEA_WORKSPACE, null);
        IdTableBuilding.registerIdIndexer(StdFileTypes.IDEA_PROJECT, null);
        IdTableBuilding.registerTodoIndexer(StdFileTypes.IDEA_MODULE, null);
        IdTableBuilding.registerTodoIndexer(StdFileTypes.IDEA_WORKSPACE, null);
        IdTableBuilding.registerTodoIndexer(StdFileTypes.IDEA_PROJECT, null);
        ABSTRACT_FILE_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});
    }

    private static class TokenSetTodoIndexer
    implements DataIndexer<TodoIndexEntry, Integer, FileContent> {
        @NotNull
        private final TokenSet myCommentTokens;
        private final VirtualFile myFile;

        public TokenSetTodoIndexer(@NotNull TokenSet commentTokens, @NotNull VirtualFile file) {
            if (commentTokens == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/id/IdTableBuilding$TokenSetTodoIndexer.<init> must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/cache/impl/id/IdTableBuilding$TokenSetTodoIndexer.<init> must not be null");
            }
            this.myCommentTokens = commentTokens;
            this.myFile = file;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Map<TodoIndexEntry, Integer> map(FileContent inputData) {
            Map<TodoIndexEntry, Integer> map;
            if (CacheUtil.getIndexPatternCount() <= 0) {
                map = Collections.emptyMap();
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$TokenSetTodoIndexer.map must not return null");
                return map;
            } else {
                EditorHighlighter highlighter;
                CharSequence chars = inputData.getContentAsText();
                TodoOccurrenceConsumer occurrenceConsumer = new TodoOccurrenceConsumer();
                EditorHighlighter editorHighlighter = (EditorHighlighter)inputData.getUserData(FileBasedIndex.EDITOR_HIGHLIGHTER);
                if (editorHighlighter != null && IdTableBuilding.checkCanUseCachedEditorHighlighter(chars, editorHighlighter)) {
                    highlighter = editorHighlighter;
                } else {
                    highlighter = HighlighterFactory.createHighlighter(null, (VirtualFile)this.myFile);
                    highlighter.setText(chars);
                }
                int documentLength = chars.length();
                BaseFilterLexer.TodoScanningData[] todoScanningDatas = null;
                HighlighterIterator iterator = highlighter.createIterator(0);
                while (!iterator.atEnd()) {
                    IElementType token = iterator.getTokenType();
                    if (this.myCommentTokens.contains(token) || CacheUtil.isInComments(token)) {
                        int start = iterator.getStart();
                        if (start >= documentLength) break;
                        int end = iterator.getEnd();
                        todoScanningDatas = BaseFilterLexer.advanceTodoItemsCount(chars.subSequence(start, Math.min(end, documentLength)), occurrenceConsumer, todoScanningDatas);
                        if (end > documentLength) break;
                    }
                    iterator.advance();
                }
                HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
                for (IndexPattern pattern : CacheUtil.getIndexPatterns()) {
                    int count = occurrenceConsumer.getOccurrenceCount(pattern);
                    if (count <= 0) continue;
                    map2.put(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), count);
                }
                map = map2;
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$TokenSetTodoIndexer.map must not return null");
                return map;
            }
        }
    }

    private static class WordsScannerFileTypeIdIndexerAdapter
    extends FileTypeIdIndexer {
        private final WordsScanner myScanner;

        public WordsScannerFileTypeIdIndexerAdapter(@NotNull WordsScanner scanner) {
            if (scanner == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/id/IdTableBuilding$WordsScannerFileTypeIdIndexerAdapter.<init> must not be null");
            }
            this.myScanner = scanner;
        }

        @Override
        @NotNull
        public Map<IdIndexEntry, Integer> map(FileContent inputData) {
            final CharSequence chars = inputData.getContentAsText();
            final char[] charsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars);
            final IdDataConsumer consumer = new IdDataConsumer();
            this.myScanner.processWords(chars, (Processor)new Processor<WordOccurrence>(){

                public boolean process(WordOccurrence t) {
                    if (charsArray != null && t.getBaseText() == chars) {
                        consumer.addOccurrence(charsArray, t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                    } else {
                        consumer.addOccurrence(t.getBaseText(), t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                    }
                    return true;
                }

                private int convertToMask(WordOccurrence.Kind kind) {
                    if (kind == null) {
                        return 255;
                    }
                    if (kind == WordOccurrence.Kind.CODE) {
                        return 1;
                    }
                    if (kind == WordOccurrence.Kind.COMMENTS) {
                        return 2;
                    }
                    if (kind == WordOccurrence.Kind.LITERALS) {
                        return 4;
                    }
                    if (kind == WordOccurrence.Kind.FOREIGN_LANGUAGE) {
                        return 8;
                    }
                    return 0;
                }
            });
            Map<IdIndexEntry, Integer> map = consumer.getResult();
            if (map == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$WordsScannerFileTypeIdIndexerAdapter.map must not return null");
            }
            return map;
        }
    }

    public static class PlainTextTodoIndexer
    implements DataIndexer<TodoIndexEntry, Integer, FileContent> {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Map<TodoIndexEntry, Integer> map(FileContent inputData) {
            Map<TodoIndexEntry, Integer> map;
            CharSequence chars = inputData.getContentAsText();
            IndexPattern[] indexPatterns = CacheUtil.getIndexPatterns();
            if (indexPatterns.length <= 0) {
                map = Collections.emptyMap();
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$PlainTextTodoIndexer.map must not return null");
                return map;
            } else {
                TodoOccurrenceConsumer occurrenceConsumer = new TodoOccurrenceConsumer();
                for (IndexPattern indexPattern : indexPatterns) {
                    Pattern pattern = indexPattern.getPattern();
                    if (pattern == null) continue;
                    Matcher matcher = pattern.matcher(chars);
                    while (matcher.find()) {
                        if (matcher.start() == matcher.end()) continue;
                        occurrenceConsumer.incTodoOccurrence(indexPattern);
                    }
                }
                HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
                for (IndexPattern indexPattern : indexPatterns) {
                    int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
                    if (count <= 0) continue;
                    map2.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
                }
                map = map2;
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$PlainTextTodoIndexer.map must not return null");
                return map;
            }
        }
    }

    public static class PlainTextIndexer
    extends FileTypeIdIndexer {
        @Override
        @NotNull
        public Map<IdIndexEntry, Integer> map(FileContent inputData) {
            final IdDataConsumer consumer = new IdDataConsumer();
            CharSequence chars = inputData.getContentAsText();
            IdTableBuilding.scanWords(new ScanWordProcessor(){

                @Override
                public void run(CharSequence chars11, int start, int end) {
                    consumer.addOccurrence(chars11, start, end, 16);
                }
            }, chars, 0, chars.length());
            Map<IdIndexEntry, Integer> map = consumer.getResult();
            if (map == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdTableBuilding$PlainTextIndexer.map must not return null");
            }
            return map;
        }
    }

    public static interface ScanWordProcessor {
        public void run(CharSequence var1, int var2, int var3);
    }
}

