/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiManager;

public class ClassFileViewProviderFactory
implements FileViewProviderFactory {
    public FileViewProvider createFileViewProvider(VirtualFile file, Language language, PsiManager manager, boolean physical) {
        ContentBasedClassFileProcessor[] processors;
        for (ContentBasedClassFileProcessor processor : processors = (ContentBasedClassFileProcessor[])Extensions.getExtensions((ExtensionPointName)ContentBasedClassFileProcessor.EP_NAME)) {
            Language lang = processor.obtainLanguageForFile(file);
            if (lang == null) continue;
            FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
            return factory.createFileViewProvider(file, language, manager, physical);
        }
        return new ClassFileViewProvider(manager, file, physical);
    }
}

