/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.DeprecatedVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.testFramework.DummyFileIdGenerator;
import org.jetbrains.annotations.NotNull;

abstract class VirtualFileImpl
extends DeprecatedVirtualFile
implements VirtualFileWithId {
    private final DummyFileSystem myFileSystem;
    private final VirtualFileDirectoryImpl myParent;
    private String myName;
    protected boolean myIsValid = true;
    private final int myId = DummyFileIdGenerator.next();

    protected VirtualFileImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name) {
        this.myFileSystem = fileSystem;
        this.myParent = parent;
        this.myName = name;
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        DummyFileSystem dummyFileSystem = this.myFileSystem;
        if (dummyFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl.getFileSystem must not return null");
        }
        return dummyFileSystem;
    }

    public String getPath() {
        if (this.myParent == null) {
            return this.myName;
        }
        return this.myParent.getPath() + "/" + this.myName;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl.getName must not return null");
        }
        return string;
    }

    void setName(String name) {
        this.myName = name;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }
}

